/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GrTypeConverter {
    public static final ExtensionPointName<GrTypeConverter> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.typeConverter");

    protected static boolean isMethodCallConversion(GroovyPsiElement context) {
        return PsiUtil.isInMethodCallContext(context);
    }

    @Nullable
    protected static GrLiteral getLiteral(@NotNull GroovyPsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrTypeConverter", "getLiteral"));
        }
        GrExpression expression = context instanceof GrTypeCastExpression ? ((GrTypeCastExpression)context).getOperand() : (context instanceof GrAssignmentExpression ? ((GrAssignmentExpression)context).getRValue() : (context instanceof GrVariable ? ((GrVariable)context).getInitializerGroovy() : (context instanceof GrReturnStatement ? ((GrReturnStatement)context).getReturnValue() : (context instanceof GrExpression ? (GrExpression)context : null))));
        return expression instanceof GrLiteral ? (GrLiteral)expression : null;
    }

    @Deprecated
    public boolean isAllowedInMethodCall() {
        return false;
    }

    public boolean isApplicableTo(@NotNull ApplicableTo position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrTypeConverter", "isApplicableTo"));
        }
        switch (position) {
            case EXPLICIT_CAST: {
                return false;
            }
            case ASSIGNMENT: {
                return true;
            }
            case METHOD_PARAMETER: {
                return this.isAllowedInMethodCall();
            }
            case RETURN_VALUE: {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    @Nullable
    public Boolean isConvertible(@NotNull PsiType lType, @NotNull PsiType rType, @NotNull GroovyPsiElement context) {
        if (lType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lType", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrTypeConverter", "isConvertible"));
        }
        if (rType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rType", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrTypeConverter", "isConvertible"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrTypeConverter", "isConvertible"));
        }
        return null;
    }

    @Nullable
    public ConversionResult isConvertibleEx(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GroovyPsiElement context, @NotNull ApplicableTo currentPosition) {
        if (targetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetType", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrTypeConverter", "isConvertibleEx"));
        }
        if (actualType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualType", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrTypeConverter", "isConvertibleEx"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrTypeConverter", "isConvertibleEx"));
        }
        if (currentPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentPosition", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrTypeConverter", "isConvertibleEx"));
        }
        Boolean result = this.isConvertible(targetType, actualType, context);
        return result == null ? null : (result != false ? ConversionResult.OK : ConversionResult.ERROR);
    }

    public static enum ApplicableTo {
        EXPLICIT_CAST,
        ASSIGNMENT,
        METHOD_PARAMETER,
        RETURN_VALUE;

    }
}

