/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.properties;

import com.intellij.lang.Language;
import com.intellij.lang.properties.parsing.PropertiesElementTypes;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.PropertyKeyIndex;
import com.intellij.lang.properties.psi.PropertyStub;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyStubImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class PropertyStubElementType
extends IStubElementType<PropertyStub, Property> {
    public PropertyStubElementType() {
        super("PROPERTY", (Language)PropertiesElementTypes.LANG);
    }

    public Property createPsi(@NotNull PropertyStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/properties/PropertyStubElementType", "createPsi"));
        }
        return new PropertyImpl(stub, (IStubElementType)this);
    }

    public PropertyStub createStub(@NotNull Property psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/properties/PropertyStubElementType", "createStub"));
        }
        return new PropertyStubImpl(parentStub, psi.getKey());
    }

    @NotNull
    public String getExternalId() {
        if ("properties.prop" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/properties/PropertyStubElementType", "getExternalId"));
        }
        return "properties.prop";
    }

    public void serialize(@NotNull PropertyStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/properties/PropertyStubElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/properties/PropertyStubElementType", "serialize"));
        }
        dataStream.writeName(stub.getKey());
    }

    @NotNull
    public PropertyStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/properties/PropertyStubElementType", "deserialize"));
        }
        StringRef ref = dataStream.readName();
        PropertyStubImpl propertyStubImpl = new PropertyStubImpl(parentStub, ref.getString());
        if (propertyStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/properties/PropertyStubElementType", "deserialize"));
        }
        return propertyStubImpl;
    }

    public void indexStub(@NotNull PropertyStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/properties/PropertyStubElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/properties/PropertyStubElementType", "indexStub"));
        }
        sink.occurrence(PropertyKeyIndex.KEY, (Object)PropertyImpl.unescape(stub.getKey()));
    }
}

