/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.frame;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeVariablesGroupKt;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.VariableContext;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"w\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\f\u0015\tAAA\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!\u0005Q!\u0001C\u0003\u0019\u0001I\u0012\u0001'\u0001\u001a\u0003a\t\u00115\bC\u0004\u0013\rA\u0019!D\u0001\u0019\u0005%\u0019\u0001RA\u0007\u00021\rIQ\u0001B\u0001\t\b5\u0011A\u0012\u0001\r\u0005\u0013\u0015!\u0011\u0001#\u0003\u000e\u00051\u0005\u0001$B\u0005\u0006\t\u0005AY!\u0004\u0002\r\u0002a1\u0011kA\u0001\t\u000e\u0015BAa\u0003\u0005\u000b\u001b\u0005A*\"G\u0002\t\u00175\t\u0001tC\u0013\t\t-AA\"D\u0001\u0019\u0016e\u0019\u0001\u0012D\u0007\u000215)C\u0001B\u0006\t\u001c5\t\u0001DD\u0013\u0005\t-Ai\"D\u0001\u0019\u001f\u0015*Aa\u0003E\u0010\u001b\ta\t\u0001'\u0005&\u000f\u0011Y\u0001\u0002E\u0007\u0005\u0013\tI\u0011\u0001G\t\u0019\"\u0015\u0006\u0002\u0002EG\u000b\u0013\u0019IQ\u0001e\t\u0016\u00051\u0005\u0001$\u0005\r\u00121C\t6!\u0001\u0003\u00133\rA)#D\u0001\u0019'\u0015*Aa\u0003E\u0014\u001b\ta\t\u0001\u0007\u000b&\u000b\u0011Y\u0001\u0012F\u0007\u0003\u0019\u0003AB#J\u0003\u0005\u0017!)RB\u0001G\u00011Q)S\u0001B\u0006\t,5\u0011A\u0012\u0001\r\u0006K\u0011!1\u0002\u0003\f\u000e\u0003a\u0019Q\u0005\u0002\u0003\f\u0011[i\u0011\u0001\u0007\u0004*\u0015\u0011\u0019\u0005\u0002c\u0001\u000e\u0003a\u0011\u0011k\u0001\u0003\u0006\u00015\u0011Aa\u0002E\bS!!\u0011\t\b\u0005\t\u001b\ta\t\u0001'\u0005R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"AY!D\u0001\u0019\rE\u001b\u0011!\u0002\u0001*\u0017\u0011\u0019\u0005\u0002c\u0002\u000e\u00051\u0005\u0001\u0004B)\u0004\t\u0015\u0001QB\u0001\u0003\n\u0011'I\u0003\u0002B!\t\u0011\u0013i!\u0001$\u0001\u0019\u000bE\u001b\u0011!\u0002\u0001*\u000f\u0011\t\u0005\u0002#\u0002\u000e\u0003a\u0019\u0011kA\u0001\u0006\u0001\u0001"}, strings={"Lorg/jetbrains/debugger/frame/CallFrameView;", "Lcom/intellij/xdebugger/frame/XStackFrame;", "Lorg/jetbrains/debugger/VariableContext;", "callFrame", "Lorg/jetbrains/debugger/CallFrame;", "viewSupport", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "script", "Lorg/jetbrains/debugger/Script;", "sourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "isInLibraryContent", "", "(Lorg/jetbrains/debugger/CallFrame;Lorg/jetbrains/debugger/DebuggerViewSupport;Lorg/jetbrains/debugger/Script;Lorg/jetbrains/debugger/SourceInfo;Ljava/lang/Boolean;)V", "getCallFrame", "()Lorg/jetbrains/debugger/CallFrame;", "evaluator", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "getScript", "()Lorg/jetbrains/debugger/Script;", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "customizePresentation", "component", "Lcom/intellij/ui/ColoredTextContainer;", "getEqualityObject", "", "getEvaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "getEvaluator", "getMemberFilter", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/MemberFilter;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "scope", "Lorg/jetbrains/debugger/Scope;", "getName", "", "getParent", "getScope", "getSourcePosition", "getViewSupport", "watchableAsEvaluationExpression"}, moduleName="script-debugger-ui")
public final class CallFrameView
extends XStackFrame
implements VariableContext {
    private final SourceInfo sourceInfo;
    private final boolean isInLibraryContent;
    private XDebuggerEvaluator evaluator;
    @NotNull
    private final CallFrame callFrame;
    private final DebuggerViewSupport viewSupport;
    @Nullable
    private final Script script;

    @NotNull
    public Object getEqualityObject() {
        return this.callFrame.getEqualityObject();
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        node.setAlreadySorted(true);
        ScopeVariablesGroupKt.createAndAddScopeList(node, this.callFrame.getVariableScopes(), this, this.callFrame);
    }

    @Override
    @NotNull
    public EvaluateContext getEvaluateContext() {
        return this.callFrame.getEvaluateContext();
    }

    @Nullable
    public Void getName() {
        return null;
    }

    @Nullable
    public Void getParent() {
        return null;
    }

    @Override
    public boolean watchableAsEvaluationExpression() {
        return true;
    }

    @Override
    @NotNull
    public DebuggerViewSupport getViewSupport() {
        return this.viewSupport;
    }

    @Override
    @NotNull
    public Promise<MemberFilter> getMemberFilter() {
        return this.viewSupport.getMemberFilter(this);
    }

    @NotNull
    public final Promise<MemberFilter> getMemberFilter(@NotNull Scope scope) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        return ScopeVariablesGroupKt.createVariableContext(scope, this, this.callFrame).getMemberFilter();
    }

    @Nullable
    public Void getScope() {
        return null;
    }

    @Nullable
    public XDebuggerEvaluator getEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = this.viewSupport.createFrameEvaluator(this);
        }
        return this.evaluator;
    }

    @Nullable
    public SourceInfo getSourcePosition() {
        return this.sourceInfo;
    }

    /*
     * WARNING - void declaration
     */
    public void customizePresentation(@NotNull ColoredTextContainer component) {
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        if (this.sourceInfo == null) {
            String scriptName = this.script == null ? "unknown" : this.script.getUrl().trimParameters().toDecodedForm();
            int line = this.callFrame.getLine();
            component.append(line == -1 ? scriptName : scriptName + ":" + line, SimpleTextAttributes.ERROR_ATTRIBUTES);
            return;
        }
        String fileName = this.sourceInfo.getFile().getName();
        int line = this.sourceInfo.getLine() + 1;
        SimpleTextAttributes textAttributes = this.isInLibraryContent ? SimpleTextAttributes.GRAYED_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        String functionName = this.sourceInfo.getFunctionName();
        if (functionName == null || StringsKt.isEmpty((CharSequence)functionName) && this.callFrame.getHasOnlyGlobalScope()) {
            if (StringsKt.startsWith$default((String)fileName, (String)"index.", (boolean)false, (int)2)) {
                Unit unit;
                VirtualFile virtualFile = this.sourceInfo.getFile().getParent();
                if (virtualFile != null) {
                    void $receiver$iv;
                    VirtualFile virtualFile2 = virtualFile;
                    VirtualFile it = (VirtualFile)$receiver$iv;
                    component.append(it.getName() + "/", textAttributes);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            component.append(fileName + ":" + line, textAttributes);
        } else {
            if (StringsKt.isEmpty((CharSequence)functionName)) {
                component.append("anonymous", this.isInLibraryContent ? SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES : SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
            } else {
                component.append(functionName, textAttributes);
            }
            component.append("(), " + fileName + ":" + line, textAttributes);
        }
        component.setIcon(AllIcons.Debugger.StackFrame);
    }

    @NotNull
    public final CallFrame getCallFrame() {
        return this.callFrame;
    }

    @Nullable
    public final Script getScript() {
        return this.script;
    }

    @JvmOverloads
    public CallFrameView(@NotNull CallFrame callFrame, @NotNull DebuggerViewSupport viewSupport, @Nullable Script script, @Nullable SourceInfo sourceInfo, @Nullable Boolean isInLibraryContent) {
        Intrinsics.checkParameterIsNotNull((Object)callFrame, (String)"callFrame");
        Intrinsics.checkParameterIsNotNull((Object)viewSupport, (String)"viewSupport");
        this.callFrame = callFrame;
        this.viewSupport = viewSupport;
        this.script = script;
        SourceInfo sourceInfo2 = sourceInfo;
        if (sourceInfo2 == null) {
            sourceInfo2 = this.viewSupport.getSourceInfo(this.script, this.callFrame);
        }
        this.sourceInfo = sourceInfo2;
        Boolean bl = isInLibraryContent;
        this.isInLibraryContent = bl != null ? bl : this.sourceInfo != null && this.viewSupport.isInLibraryContent(this.sourceInfo, this.script);
    }

    @JvmOverloads
    public /* synthetic */ CallFrameView(CallFrame callFrame, DebuggerViewSupport debuggerViewSupport, Script script, SourceInfo sourceInfo, Boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            script = null;
        }
        if ((n & 8) != 0) {
            sourceInfo = null;
        }
        if ((n & 0x10) != 0) {
            bl = null;
        }
        this(callFrame, debuggerViewSupport, script, sourceInfo, bl);
    }

    @JvmOverloads
    public CallFrameView(@NotNull CallFrame callFrame, @NotNull DebuggerViewSupport debuggerViewSupport, @Nullable Script script, @Nullable SourceInfo sourceInfo) {
        this(callFrame, debuggerViewSupport, script, sourceInfo, null, 16, null);
    }

    @JvmOverloads
    public CallFrameView(@NotNull CallFrame callFrame, @NotNull DebuggerViewSupport debuggerViewSupport, @Nullable Script script) {
        this(callFrame, debuggerViewSupport, script, null, null, 24, null);
    }

    @JvmOverloads
    public CallFrameView(@NotNull CallFrame callFrame, @NotNull DebuggerViewSupport debuggerViewSupport) {
        this(callFrame, debuggerViewSupport, null, null, null, 28, null);
    }
}

