/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.UriUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.net.NetUtils;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServer;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.WebServerPathHandler;
import org.jetbrains.builtInWebServer.WebServerPathHandlerKt;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"?\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\t\u00012B\u0003\u0001\u000b\u0005Aq!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u001b3A1!D\u0001\u0019\be\u0019\u0001\u0002B\u0007\u00021\u0013I2\u0001C\u0003\u000e\u0003a-Ak!\u0002\u000e&\u0011\t\u0001BB\u0007\u00021\u000fI2\u0001#\u0004\u000e\u0003a9\u0011d\u0001E\b\u001b\u0005A\u0002\"\u0007\u0003\t\u00125\u0011A\u0012\u0001M\u0005)\u000e\u0015Q2\u0003\u0005\n\u001b\ta\t\u0001g\u0005\u001a\u0007!QQ\"\u0001M\n)\u000e\u0015Q2\u0003\u0005\n\u001b\ta\t\u0001'\u0006\u001a\u0007!QQ\"\u0001M\u000b)\u000e\u0015Q\u0012\u0003\u0005\f\u001b\u0005A:!G\u0002\t\u00185\t\u0001\u0014\u0002+\u0004\u0006EqA\u0001\u0011\u0005\t\u00015\u001d\u0001\u0014A)\u0004\u0003\u0011\t\u0011k\u0001\u0003\u0006\u00015\u0011A1\u0001\u0005\u0003)\u000e\u0015\u0001"}, strings={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "BuiltInWebServerKt", "compareNameAndProjectBasePath", "", "projectName", "", "project", "Lcom/intellij/openapi/project/Project;", "doProcess", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "projectNameAsHost", "findIndexFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "basedir", "Ljava/io/File;", "isOwnHostName", "host"}, moduleName="built-in-server")
public final class BuiltInWebServerKt {
    @NotNull
    private static final Logger LOG = Logger.getInstance(BuiltInWebServer.class);

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    /*
     * Unable to fully structure code
     */
    private static final boolean doProcess(FullHttpRequest request, ChannelHandlerContext context, String projectNameAsHost) {
        block15: {
            decodedPath = URLUtil.unescapePercentSequences((String)UriUtil.trimParameters(request.uri()));
            offset = new Ref.IntRef();
            isEmptyPath = new Ref.BooleanRef();
            isCustomHost = projectNameAsHost != null;
            projectName = new Ref.ObjectRef();
            if (isCustomHost) {
                v0 = projectNameAsHost;
                if (v0 == null) {
                    Intrinsics.throwNpe();
                }
                projectName.element = v0;
                offset.element = 0;
                isEmptyPath.element = StringsKt.isEmpty((CharSequence)decodedPath);
            } else {
                offset.element = StringsKt.indexOf$default((CharSequence)decodedPath, (char)'/', (int)1, (boolean)false, (int)4);
                projectName.element = StringsKt.substring((String)decodedPath, (int)1, (int)(offset.element == -1 ? decodedPath.length() : offset.element));
                isEmptyPath.element = offset.element == -1;
            }
            var8_8 = new Ref.ObjectRef();
            var8_8.element = null;
            var10_9 = ProjectManager.getInstance().getOpenProjects();
            for (var11_10 = 0; var11_10 < ((void)$receiver$iv).length; ++var11_10) {
                block17: {
                    block18: {
                        block16: {
                            element$iv = $receiver$iv[var11_10];
                            project = (Project)element$iv;
                            if (!project.isDisposed()) break block16;
                            v1 = false;
                            break block17;
                        }
                        name = project.getName();
                        if (!isCustomHost) break block18;
                        if (!StringsKt.equals((String)((String)projectName.element), (String)name, (boolean)true)) ** GOTO lbl-1000
                        if (!SystemInfoRt.isFileSystemCaseSensitive) {
                            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
                            projectName.element = projectName.element;
                        }
                        v1 = true;
                        break block17;
                    }
                    v2 = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"name");
                    if (!StringsKt.regionMatches((String)decodedPath, (int)1, (String)v2, (int)0, (int)name.length(), (boolean)(SystemInfoRt.isFileSystemCaseSensitive == false))) ** GOTO lbl-1000
                    v3 = isEmptyPathCandidate = decodedPath.length() == name.length() + 1;
                    if (isEmptyPathCandidate || decodedPath.charAt(name.length() + 1) == '/') {
                        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
                        projectName.element = projectName.element;
                        offset.element = name.length() + 1;
                        isEmptyPath.element = isEmptyPathCandidate;
                        v1 = true;
                    } else lbl-1000:
                    // 3 sources

                    {
                        if ((Project)candidateByDirectoryName.element == null && BuiltInWebServerKt.compareNameAndProjectBasePath((String)projectName.element, project)) {
                            candidateByDirectoryName.element = project;
                        }
                        v1 = false;
                    }
                }
                if (!v1) continue;
                v4 = element$iv;
                break block15;
            }
            v4 = null;
        }
        if ((v5 = (Project)v4) == null) {
            v5 = (Project)candidateByDirectoryName.element;
        }
        if (v5 == null) {
            return false;
        }
        project = v5;
        if (isEmptyPath.element) {
            v6 = (HttpRequest)request;
            v7 = context.channel();
            Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"context.channel()");
            WebServerPathHandlerKt.redirectToDirectory(v6, v7, (String)projectName.element);
            return true;
        }
        path = FileUtil.toCanonicalPath((String)StringsKt.substring((String)decodedPath, (int)(offset.element + 1)), (char)'/');
        var13_14 = (WebServerPathHandler[])WebServerPathHandler.Companion.getEP_NAME$built_in_server().getExtensions();
        for (var12_13 = 0; var12_13 < var13_14.length; ++var12_13) {
            pathHandler = var13_14[var12_13];
            name = BuiltInWebServerKt.LOG;
            try {
                v8 = path;
                Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"path");
                v9 = (String)projectName.element;
                v10 = decodedPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"decodedPath");
                if (!pathHandler.process(v8, project, request, context, v9, v10, isCustomHost)) continue;
                return true;
            }
            catch (ProcessCanceledException e$iv) {
                continue;
            }
            catch (Throwable e$iv) {
                $receiver$iv.error(e$iv);
            }
        }
        return false;
    }

    public static final boolean compareNameAndProjectBasePath(@NotNull String projectName, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String basePath = project.getBasePath();
        return basePath != null && FileUtilKt.endsWithName(basePath, projectName);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final VirtualFile findIndexFile(@NotNull VirtualFile basedir) {
        void elements$iv;
        Intrinsics.checkParameterIsNotNull((Object)basedir, (String)"basedir");
        VirtualFile[] children2 = basedir.getChildren();
        if (children2 == null || ArraysKt.isEmpty((Object[])children2)) {
            return null;
        }
        String[] stringArray = new String[]{"index.", "default."};
        String[] stringArray2 = (String[])((Object[])elements$iv);
        for (int i = 0; i < stringArray2.length; ++i) {
            String indexNamePrefix = stringArray2[i];
            VirtualFile index = null;
            String preferredName = indexNamePrefix + "html";
            for (int j = 0; j < children2.length; ++j) {
                VirtualFile child = children2[j];
                if (child.isDirectory()) continue;
                String name = child.getName();
                if (Intrinsics.areEqual((Object)name, (Object)preferredName)) {
                    return child;
                }
                if (index != null || !StringsKt.startsWith$default((String)name, (String)indexNamePrefix, (boolean)false, (int)2)) continue;
                index = child;
            }
            if (index == null) continue;
            return index;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final File findIndexFile(@NotNull File basedir) {
        void elements$iv;
        Intrinsics.checkParameterIsNotNull((Object)basedir, (String)"basedir");
        File[] children2 = basedir.listFiles(findIndexFile.children.1.INSTANCE);
        if (children2 == null || ArraysKt.isEmpty((Object[])children2)) {
            return null;
        }
        String[] stringArray = new String[]{"index.", "default."};
        String[] stringArray2 = (String[])((Object[])elements$iv);
        for (int i = 0; i < stringArray2.length; ++i) {
            String indexNamePrefix = stringArray2[i];
            File index = null;
            String preferredName = indexNamePrefix + "html";
            for (int j = 0; j < children2.length; ++j) {
                File child = children2[j];
                if (child.isDirectory()) continue;
                String name = child.getName();
                if (Intrinsics.areEqual((Object)name, (Object)preferredName)) {
                    return child;
                }
                if (index != null || !StringsKt.startsWith$default((String)name, (String)indexNamePrefix, (boolean)false, (int)2)) continue;
                index = child;
            }
            if (index == null) continue;
            return index;
        }
        return null;
    }

    public static final boolean isOwnHostName(@NotNull String host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        if (NetUtils.isLocalhost((String)host)) {
            return true;
        }
        try {
            InetAddress address = InetAddress.getByName(host);
            if (Intrinsics.areEqual((Object)host, (Object)address.getHostAddress()) || StringsKt.equals((String)host, (String)address.getCanonicalHostName(), (boolean)true)) {
                return true;
            }
            String localHostName = InetAddress.getLocalHost().getHostName();
            return StringsKt.equals((String)localHostName, (String)host, (boolean)true) || StringsKt.endsWith$default((String)host, (String)".local", (boolean)false, (int)2) && StringsKt.regionMatches((String)localHostName, (int)0, (String)host, (int)0, (int)(host.length() - ".local".length()), (boolean)true);
        }
        catch (UnknownHostException ignored) {
            return false;
        }
    }

    public static final /* synthetic */ boolean access$doProcess(@NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context, @Nullable String projectNameAsHost) {
        return BuiltInWebServerKt.doProcess(request, context, projectNameAsHost);
    }
}

