/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncDefine;
import org.intellij.plugins.relaxNG.compact.psi.RncElementVisitor;
import org.intellij.plugins.relaxNG.compact.psi.RncFile;
import org.intellij.plugins.relaxNG.compact.psi.RncGrammar;
import org.intellij.plugins.relaxNG.compact.psi.RncInclude;
import org.intellij.plugins.relaxNG.compact.psi.RncPattern;
import org.intellij.plugins.relaxNG.compact.psi.impl.RncElementImpl;
import org.intellij.plugins.relaxNG.compact.psi.util.EscapeUtil;
import org.intellij.plugins.relaxNG.compact.psi.util.RenameUtil;
import org.intellij.plugins.relaxNG.model.CommonElement;
import org.intellij.plugins.relaxNG.model.Define;
import org.intellij.plugins.relaxNG.model.resolve.DefinitionResolver;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RncDefineImpl
extends RncElementImpl
implements RncDefine,
PsiMetaOwner {
    public RncDefineImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull RncElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/intellij/plugins/relaxNG/compact/psi/impl/RncDefineImpl", "accept"));
        }
        visitor.visitDefine(this);
    }

    @Override
    public void accept(CommonElement.Visitor visitor) {
        visitor.visitDefine(this);
    }

    @Override
    public String getName() {
        ASTNode node = this.getNameNode();
        return EscapeUtil.unescapeText(node);
    }

    @Override
    public PsiElement getNameElement() {
        return this.getNameNode().getPsi();
    }

    @NotNull
    public ASTNode getNameNode() {
        ASTNode node = this.getNode().findChildByType(RncTokenTypes.IDENTIFIERS);
        assert (node != null);
        ASTNode aSTNode = node;
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/compact/psi/impl/RncDefineImpl", "getNameNode"));
        }
        return aSTNode;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/intellij/plugins/relaxNG/compact/psi/impl/RncDefineImpl", "setName"));
        }
        ASTNode node = this.getNameNode();
        node.getTreeParent().replaceChild(node, RenameUtil.createIdentifierNode(this.getManager(), name));
        return this;
    }

    @Override
    @Nullable
    public RncPattern getPattern() {
        return this.findChildByClass(RncPattern.class);
    }

    @Override
    public PsiReference getReference() {
        if (this.getParent() instanceof RncInclude) {
            TextRange range = TextRange.from((int)0, (int)this.getNameNode().getTextLength());
            return new PsiReferenceBase<RncDefine>((RncDefine)this, range, true){

                public PsiElement resolve() {
                    return RncDefineImpl.this;
                }

                @NotNull
                public Object[] getVariants() {
                    RncInclude parent = (RncInclude)RncDefineImpl.this.getParent();
                    RncFile referencedFile = parent.getReferencedFile();
                    if (referencedFile == null) {
                        if (EMPTY_ARRAY == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/compact/psi/impl/RncDefineImpl$1", "getVariants"));
                        }
                        return EMPTY_ARRAY;
                    }
                    RncGrammar grammar = referencedFile.getGrammar();
                    if (grammar == null) {
                        if (EMPTY_ARRAY == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/compact/psi/impl/RncDefineImpl$1", "getVariants"));
                        }
                        return EMPTY_ARRAY;
                    }
                    Map<String, Set<Define>> map = DefinitionResolver.getAllVariants(grammar);
                    if (map != null) {
                        Object[] objectArray = map.keySet().toArray();
                        if (objectArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/compact/psi/impl/RncDefineImpl$1", "getVariants"));
                        }
                        return objectArray;
                    }
                    if (EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/compact/psi/impl/RncDefineImpl$1", "getVariants"));
                    }
                    return EMPTY_ARRAY;
                }
            };
        }
        return super.getReference();
    }

    @Nullable
    public Icon getIcon(int flags) {
        return AllIcons.Nodes.Property;
    }

    public boolean isMetaEnough() {
        return true;
    }

    @Nullable
    public PsiMetaData getMetaData() {
        return new MyMetaData();
    }

    private class MyMetaData
    implements PsiMetaData,
    PsiPresentableMetaData {
        private MyMetaData() {
        }

        @Nullable
        public Icon getIcon() {
            return RncDefineImpl.this.getIcon(0);
        }

        public String getTypeName() {
            return "Pattern Definition";
        }

        public PsiElement getDeclaration() {
            return RncDefineImpl.this;
        }

        @NonNls
        public String getName(PsiElement context) {
            return RncDefineImpl.this.getName();
        }

        @NonNls
        public String getName() {
            return RncDefineImpl.this.getName();
        }

        public void init(PsiElement element) {
        }

        public Object[] getDependences() {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
    }
}

