/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.utils.stream;

import com.jetbrains.sourceglider.utils.FileHelper;
import com.jetbrains.sourceglider.utils.stream.RSAKey;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class RSAOutputStream
extends OutputStream {
    private OutputStream stream;
    private RSAKey key;
    private BigInteger code;
    private int pos;

    public RSAOutputStream(OutputStream stream, RSAKey key) throws IOException {
        this.stream = stream;
        this.key = key;
        this.code = BigInteger.ZERO;
        this.pos = 0;
    }

    @Override
    public void write(int b) throws IOException {
        this.code = this.code.shiftLeft(8).add(BigInteger.valueOf(128 + (byte)b));
        if (++this.pos == this.key.blockSize) {
            FileHelper.writeBigIntToStream(this.stream, this.code.modPow(this.key.exponent, this.key.modulus));
            this.code = BigInteger.ZERO;
            this.pos = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        this.code = this.code.shiftLeft(8 * (this.key.blockSize - this.pos));
        FileHelper.writeBigIntToStream(this.stream, this.code.modPow(this.key.exponent, this.key.modulus));
        this.stream.flush();
    }
}

