/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainConstraint;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.VariablesManager;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import java.util.List;
import java.util.Map;

public class RelExprVar
extends RelExpr {
    public static final int DOMAIN = 0;
    public static final int ATTRIBUTE = 1;
    public static final int UNDERSCORE = 2;
    public static final int REGEXP = 3;
    private String relname;
    private String[] values;
    private int[] flags;
    private boolean fastRename;

    public RelExprVar(String relname, String[] values, int[] flags, Context context) {
        super(context);
        this.relname = relname;
        this.values = values;
        this.flags = flags;
        this.fastRename = true;
        for (int flag : flags) {
            if (flag == 0) continue;
            this.fastRename = false;
            break;
        }
    }

    public RelExprVar(String relname, String[] values, Context context) {
        super(context);
        this.relname = relname;
        this.values = values;
        this.fastRename = true;
        this.flags = new int[values.length];
        for (int i = 0; i < this.flags.length; ++i) {
            this.flags[i] = 0;
        }
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, ProfileManager profileManager) {
        IRelation result2 = relationsManager.makeRepositoryRelation(variablesManager.getRelation(this.relname), this.relname);
        if (this.fastRename) {
            Domain[] domains = new Domain[this.values.length];
            for (int i = 0; i < domains.length; ++i) {
                domains[i] = variablesManager.getDomain(this.values[i]);
            }
            IRelation oldResult = result2;
            result2 = result2.fastRename(domains, threadCallback);
            oldResult.kill();
            return result2;
        }
        for (int i = this.values.length - 1; i >= 0; --i) {
            IRelation oldResult = result2;
            if (this.flags[i] == 1) {
                Domain domain = result2.getDomain(i);
                int attr = symbolTable.findAttributeInt(domain.getType(), this.values[i]);
                if (attr == -1) {
                    result2 = relationsManager.makeEmptyRelation((Domain[])ArrayHelper.deleteElement((Object[])result2.getDomains(), i, Domain.class));
                    uiInstancesProvider.getConsole().println(Messages.getString(RelExprVar.class.getName() + "-0") + this.values[i] + Messages.getString(RelExprVar.class.getName() + "-1"));
                } else {
                    result2 = result2.project(i, attr, threadCallback);
                }
            } else if (this.flags[i] == 2) {
                result2 = result2.exists(i, threadCallback);
            } else if (this.flags[i] == 3) {
                result2 = result2.relprod(relationsManager.makeRegExprSet(result2.getDomain(i), this.values[i], threadCallback), result2.getDomain(i), threadCallback);
            } else if (this.flags[i] == 0) {
                result2 = result2.rename(i, variablesManager.getDomain(this.values[i]), threadCallback);
            }
            oldResult.kill();
        }
        return result2;
    }

    public Domain getDomain(RuntimeVariablesManager variablesManager, int index) {
        return variablesManager.getRelation(this.relname).getDomain(index);
    }

    public String getDomainName(int index) {
        return this.flags[index] == 0 ? this.values[index] : "_";
    }

    @Override
    public void collectDomainConstraints(Map<String, List> constraints, VariablesManager variablesManager) {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.flags[i] != 0) continue;
            DomainType type = variablesManager.getRelation(this.relname)[i];
            List vector = constraints.get(this.values[i]);
            for (int j = 0; j < this.values.length; ++j) {
                if (this.flags[j] != 0 && this.flags[j] != 2 || variablesManager.getRelation(this.relname)[j] != type) continue;
                vector.add(new DomainConstraint(this, j));
            }
        }
    }
}

