/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.toolchains;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.jetbrains.cidr.toolchains.CidrTool;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrToolSet
extends CidrTool {
    @NotNull
    protected final File myHome;

    public CidrToolSet(@NotNull File home) {
        if (home == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "home", "com/jetbrains/cidr/toolchains/CidrToolSet", "<init>"));
        }
        this.myHome = home;
    }

    @NotNull
    public abstract String getName();

    public boolean isCygwin() {
        return false;
    }

    public boolean isCygwin64() {
        return false;
    }

    public boolean isMinGW() {
        return false;
    }

    public boolean isMinGW64() {
        return false;
    }

    @NotNull
    public File getHome() {
        File file2 = this.myHome;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/toolchains/CidrToolSet", "getHome"));
        }
        return file2;
    }

    @NotNull
    public String getHomePath() {
        String string = this.myHome.getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/toolchains/CidrToolSet", "getHomePath"));
        }
        return string;
    }

    @Contract(value="null -> null")
    public File getSubFile(@Nullable String relativePath) {
        return relativePath == null ? null : new File(this.myHome, relativePath);
    }

    @Contract(value="null -> null")
    public String getSubFilePath(@Nullable String relativePath) {
        File result2 = this.getSubFile(relativePath);
        return result2 == null ? null : result2.getPath();
    }

    @NotNull
    public abstract File getGDBPath();

    public abstract boolean forceToolSetGDB();

    public void prepareEnvironment(@NotNull GeneralCommandLine cl) {
        if (cl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cl", "com/jetbrains/cidr/toolchains/CidrToolSet", "prepareEnvironment"));
        }
    }

    protected static void prependPathVariable(@NotNull GeneralCommandLine cl, @NotNull String path) {
        if (cl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cl", "com/jetbrains/cidr/toolchains/CidrToolSet", "prependPathVariable"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/cidr/toolchains/CidrToolSet", "prependPathVariable"));
        }
        path = FileUtil.toSystemDependentName((String)path);
        THashMap system = new THashMap(cl.getParentEnvironment(), (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        if (cl.isPassParentEnvironment() && system.containsKey("PATH")) {
            path = path + ";" + (String)system.get("PATH");
        }
        cl.getEnvironment().put("PATH", path);
    }
}

