/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PathTree<Self extends PathTree<Self, T>, T> {
    @Nullable
    protected THashSet<T> myItems;
    @Nullable
    protected THashMap<String, Self> myChildren;

    public void addItem(@NotNull String path, @NotNull T item) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/cidr/lang/workspace/headerRoots/PathTree", "addItem"));
        }
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/cidr/lang/workspace/headerRoots/PathTree", "addItem"));
        }
        Self subTree = this.getNotNullSubTree(path);
        super.getItemsForWrite().add(item);
    }

    public int removeItem(@NotNull String path, @NotNull T ref) {
        THashSet<T> references;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/cidr/lang/workspace/headerRoots/PathTree", "removeItem"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/jetbrains/cidr/lang/workspace/headerRoots/PathTree", "removeItem"));
        }
        Self subTree = this.getSubTree(path, SearchStrategy.NULL_IF_NOT_FOUND);
        if (subTree != null && (references = ((PathTree)subTree).myItems) != null) {
            references.remove(ref);
            return references.size();
        }
        return 0;
    }

    @NotNull
    public Set<T> getItems() {
        Set set = this.myItems == null ? Collections.emptySet() : this.myItems;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/headerRoots/PathTree", "getItems"));
        }
        return set;
    }

    @NotNull
    public Collection<Self> getChildren() {
        Collection<Object> collection = this.myChildren == null ? Collections.emptySet() : this.myChildren.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/headerRoots/PathTree", "getChildren"));
        }
        return collection;
    }

    @NotNull
    protected Self getNotNullSubTree(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/cidr/lang/workspace/headerRoots/PathTree", "getNotNullSubTree"));
        }
        Self Self = this.getSubTree(path, SearchStrategy.BUILD_IF_NOT_FOUND);
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/headerRoots/PathTree", "getNotNullSubTree"));
        }
        return Self;
    }

    @Deprecated
    @Nullable
    public Self getSubTree(@NotNull String path, boolean createSubtrees) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/cidr/lang/workspace/headerRoots/PathTree", "getSubTree"));
        }
        return this.getSubTree(path, createSubtrees ? SearchStrategy.BUILD_IF_NOT_FOUND : SearchStrategy.NULL_IF_NOT_FOUND);
    }

    @Nullable
    public Self getSubTree(@NotNull String path, @NotNull SearchStrategy strategy) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/cidr/lang/workspace/headerRoots/PathTree", "getSubTree"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/jetbrains/cidr/lang/workspace/headerRoots/PathTree", "getSubTree"));
        }
        return this.getSubTree(StringUtil.split((String)FileUtil.toCanonicalPath((String)path), (String)"/", (boolean)true, (boolean)false), strategy);
    }

    @Nullable
    private Self getSubTree(@NotNull List<String> pathComps, SearchStrategy strategy) {
        if (pathComps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathComps", "com/jetbrains/cidr/lang/workspace/headerRoots/PathTree", "getSubTree"));
        }
        Self result2 = this.self();
        int pathCompsCount = pathComps.size();
        for (int i = 0; i < pathCompsCount && result2 != null; ++i) {
            Self t = result2;
            String key = pathComps.get(i);
            Self st = super.getChild(key);
            if (st == null) {
                if (strategy == SearchStrategy.BUILD_IF_NOT_FOUND) {
                    st = super.createChild(key);
                } else if (strategy == SearchStrategy.DEEPEST_EXISTING_PREFIX) {
                    return result2;
                }
            }
            result2 = st;
        }
        return result2;
    }

    protected Self self() {
        return (Self)this;
    }

    protected abstract Self createNewTree(@Nullable Self var1);

    @NotNull
    private Set<T> getItemsForWrite() {
        if (this.myItems == null) {
            this.myItems = new THashSet();
        }
        THashSet<T> tHashSet = this.myItems;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/headerRoots/PathTree", "getItemsForWrite"));
        }
        return tHashSet;
    }

    @Nullable
    private Self getChild(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/cidr/lang/workspace/headerRoots/PathTree", "getChild"));
        }
        if (this.myChildren == null) {
            return null;
        }
        return (Self)((PathTree)this.myChildren.get((Object)key));
    }

    private Self createChild(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/workspace/headerRoots/PathTree", "createChild"));
        }
        if (this.myChildren == null) {
            this.myChildren = new THashMap(FileUtil.PATH_HASHING_STRATEGY);
        }
        Self tree = this.createNewTree(this.self());
        this.myChildren.put((Object)name, tree);
        return tree;
    }

    public static enum SearchStrategy {
        NULL_IF_NOT_FOUND,
        BUILD_IF_NOT_FOUND,
        DEEPEST_EXISTING_PREFIX;

    }
}

