/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.SyntheticFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SpecificNameItemProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.FrameworksSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.IncludedFilesProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.IncludedHeadersRoot;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HeadersSearchRoot
extends SyntheticFileSystemItem {
    @Nullable
    public static HeadersSearchRoot createFromHeaderSearchPath(@NotNull Project project, @NotNull HeadersSearchPath searchPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot", "createFromHeaderSearchPath"));
        }
        if (searchPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchPath", "com/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot", "createFromHeaderSearchPath"));
        }
        VirtualFile headersDir = LocalFileSystem.getInstance().findFileByIoFile(searchPath.getFile());
        if (headersDir == null || !headersDir.isDirectory()) {
            return null;
        }
        return searchPath.isFrameworksSearchPath() ? new FrameworksSearchRoot(project, headersDir) : new IncludedHeadersRoot(project, headersDir, searchPath.isRecursive(), searchPath.isUserHeaders());
    }

    public HeadersSearchRoot(Project project) {
        super(project);
    }

    public PsiFileSystemItem getParent() {
        return null;
    }

    public boolean isUserHeaders() {
        return false;
    }

    protected boolean processUnder(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @Nullable VirtualFile base) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot", "processUnder"));
        }
        return this.processUnder(processor2, base, null);
    }

    protected boolean processUnder(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @Nullable VirtualFile base, @Nullable Condition<VirtualFile> condition) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot", "processUnder"));
        }
        return this.processUnder(processor2, base, false, condition);
    }

    protected boolean processUnder(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @Nullable VirtualFile base, boolean recursive, @Nullable Condition<VirtualFile> condition) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot", "processUnder"));
        }
        if (base == null) {
            return true;
        }
        if (IncludedFilesProcessor.shouldSkip(base)) {
            return true;
        }
        if (processor2 instanceof HeadersSearchRootProcessor) {
            if (!IncludedFilesProcessor.processFile(this.myProject, base, condition, processor2)) {
                return false;
            }
            if (((HeadersSearchRootProcessor)processor2).shouldProcessRootsOnly()) {
                return true;
            }
        }
        if (processor2 instanceof SpecificNameItemProcessor) {
            String name = ((SpecificNameItemProcessor)processor2).getName();
            VirtualFile file2 = base.findChild(name);
            return file2 == null || IncludedFilesProcessor.processFile(this.myProject, file2, condition, processor2);
        }
        VirtualFile[] children2 = base.getChildren();
        return children2 == null || IncludedFilesProcessor.processFiles(this.myProject, Arrays.asList(children2), condition, recursive, processor2);
    }

    protected boolean processCustomFileSet(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @NotNull Iterable<VirtualFile> files, boolean recursive) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot", "processCustomFileSet"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot", "processCustomFileSet"));
        }
        return IncludedFilesProcessor.processFiles(this.myProject, files, null, recursive, processor2);
    }
}

