/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomHeadersRoot
extends HeadersSearchRoot {
    @Nullable
    private final VirtualFile myRoot;
    @NotNull
    private final VirtualFile[] myFilesCache;
    private final int myHashCodeCache;

    public CustomHeadersRoot(@NotNull Project project, @Nullable VirtualFile root, @NotNull Collection<VirtualFile> files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/workspace/headerRoots/CustomHeadersRoot", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/cidr/lang/workspace/headerRoots/CustomHeadersRoot", "<init>"));
        }
        super(project);
        this.myRoot = root;
        this.myFilesCache = files.toArray(new VirtualFile[files.size()]);
        Arrays.sort(this.myFilesCache, new Comparator<VirtualFile>(){

            @Override
            public int compare(VirtualFile o1, VirtualFile o2) {
                return FileUtil.comparePaths((String)o1.getPath(), (String)o2.getPath());
            }
        });
        this.myHashCodeCache = Arrays.hashCode(this.myFilesCache);
    }

    public VirtualFile getVirtualFile() {
        return this.myRoot;
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor2) {
        return this.processCustomFileSet(processor2, Arrays.asList(this.myFilesCache), false);
    }

    public String toString() {
        return this.getName() + ", size: " + this.myFilesCache.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CustomHeadersRoot root = (CustomHeadersRoot)((Object)o);
        return this.myHashCodeCache == root.myHashCodeCache && Arrays.equals(this.myFilesCache, root.myFilesCache);
    }

    public int hashCode() {
        return this.myHashCodeCache;
    }
}

