/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCCompilerSettings {
    @Nullable
    public abstract OCCompilerKind getCompiler(@NotNull OCLanguageKind var1);

    @Nullable
    public abstract File getCompilerExecutable(@NotNull OCLanguageKind var1);

    @NotNull
    public abstract File getCompilerWorkingDir();

    @NotNull
    public abstract CidrToolEnvironment getEnvironment();

    @NotNull
    public abstract CidrCompilerSwitches getCompilerSwitches(@NotNull OCLanguageKind var1, @Nullable VirtualFile var2);

    @NotNull
    public String getCompilerKey(@NotNull OCLanguageKind languageKind, @Nullable VirtualFile sourceFile) {
        if (languageKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageKind", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerSettings", "getCompilerKey"));
        }
        String string = (String)this.getCompilerKeyAndSwitches((OCLanguageKind)languageKind, (VirtualFile)sourceFile).first;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerSettings", "getCompilerKey"));
        }
        return string;
    }

    @NotNull
    public Pair<String, CidrCompilerSwitches> getCompilerKeyAndSwitches(@NotNull OCLanguageKind languageKind, @Nullable VirtualFile sourceFile) {
        if (languageKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageKind", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerSettings", "getCompilerKeyAndSwitches"));
        }
        CidrCompilerSwitches switches = this.getCompilerSwitches(languageKind, sourceFile);
        File compilerExec = this.getCompilerExecutable(languageKind);
        String key = (compilerExec == null ? "no compiler" : compilerExec.getPath()) + "-" + this.getCompilerWorkingDir() + "-" + languageKind.getDisplayName() + "-" + switches.getCommandLineString();
        Pair pair = Pair.pair((Object)key, (Object)switches);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerSettings", "getCompilerKeyAndSwitches"));
        }
        return pair;
    }
}

