/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultModificationTracker;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.util.messages.MessageBus;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCWorkspaceModificationTrackers {
    private final Project myProject;
    private final PsiModificationTrackerImpl myPsiTracker;
    private final DefaultModificationTracker myProjectsListTracker;
    private final DefaultModificationTracker myProjectFilesListTracker;
    private final DefaultModificationTracker mySourceFilesListTracker;
    private final DefaultModificationTracker myBuildSettingsChangesTracker;
    private final DefaultModificationTracker myBuildConfigurationChangesTracker;
    private final DefaultModificationTracker myBuildsTracker;

    public OCWorkspaceModificationTrackers(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/workspace/OCWorkspaceModificationTrackers", "<init>"));
        }
        this.myProject = project;
        this.myPsiTracker = (PsiModificationTrackerImpl)PsiManager.getInstance((Project)project).getModificationTracker();
        final MessageBus bus = project.getMessageBus();
        this.myProjectsListTracker = new MyModificationTracker(new Runnable(){

            @Override
            public void run() {
                ((OCWorkspaceModificationListener)bus.syncPublisher(OCWorkspaceModificationListener.TOPIC)).projectsChanged();
            }
        });
        this.myProjectFilesListTracker = new MyModificationTracker(new Runnable(){

            @Override
            public void run() {
                ((OCWorkspaceModificationListener)bus.syncPublisher(OCWorkspaceModificationListener.TOPIC)).projectFilesChanged();
            }
        });
        this.mySourceFilesListTracker = new MyModificationTracker(new Runnable(){

            @Override
            public void run() {
                ((OCWorkspaceModificationListener)bus.syncPublisher(OCWorkspaceModificationListener.TOPIC)).sourceFilesChanged();
            }
        });
        this.myBuildSettingsChangesTracker = new MyModificationTracker(new Runnable(){

            @Override
            public void run() {
                ((OCWorkspaceModificationListener)bus.syncPublisher(OCWorkspaceModificationListener.TOPIC)).buildSettingsChanged();
            }
        });
        this.myBuildConfigurationChangesTracker = new MyModificationTracker(new Runnable(){

            @Override
            public void run() {
                ((OCWorkspaceModificationListener)bus.syncPublisher(OCWorkspaceModificationListener.TOPIC)).activeBuildConfigurationChanged();
            }
        });
        this.myBuildsTracker = new MyModificationTracker(new Runnable(){

            @Override
            public void run() {
                ((OCWorkspaceModificationListener)bus.syncPublisher(OCWorkspaceModificationListener.TOPIC)).buildFinished();
            }
        });
    }

    @NotNull
    public DefaultModificationTracker getProjectsListTracker() {
        DefaultModificationTracker defaultModificationTracker = this.myProjectsListTracker;
        if (defaultModificationTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCWorkspaceModificationTrackers", "getProjectsListTracker"));
        }
        return defaultModificationTracker;
    }

    @NotNull
    public DefaultModificationTracker getProjectFilesListTracker() {
        DefaultModificationTracker defaultModificationTracker = this.myProjectFilesListTracker;
        if (defaultModificationTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCWorkspaceModificationTrackers", "getProjectFilesListTracker"));
        }
        return defaultModificationTracker;
    }

    @NotNull
    public DefaultModificationTracker getSourceFilesListTracker() {
        DefaultModificationTracker defaultModificationTracker = this.mySourceFilesListTracker;
        if (defaultModificationTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCWorkspaceModificationTrackers", "getSourceFilesListTracker"));
        }
        return defaultModificationTracker;
    }

    @NotNull
    public DefaultModificationTracker getBuildSettingsChangesTracker() {
        DefaultModificationTracker defaultModificationTracker = this.myBuildSettingsChangesTracker;
        if (defaultModificationTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCWorkspaceModificationTrackers", "getBuildSettingsChangesTracker"));
        }
        return defaultModificationTracker;
    }

    @NotNull
    public DefaultModificationTracker getBuildConfigurationChangesTracker() {
        DefaultModificationTracker defaultModificationTracker = this.myBuildConfigurationChangesTracker;
        if (defaultModificationTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCWorkspaceModificationTrackers", "getBuildConfigurationChangesTracker"));
        }
        return defaultModificationTracker;
    }

    @NotNull
    public DefaultModificationTracker getBuildsTracker() {
        DefaultModificationTracker defaultModificationTracker = this.myBuildsTracker;
        if (defaultModificationTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCWorkspaceModificationTrackers", "getBuildsTracker"));
        }
        return defaultModificationTracker;
    }

    private class MyModificationTracker
    extends DefaultModificationTracker {
        @Nullable
        private final Runnable myPublisher;

        private MyModificationTracker(Runnable publisher) {
            this.myPublisher = publisher;
        }

        public void incModificationCount() {
            super.incModificationCount();
            OCWorkspaceModificationTrackers.this.myPsiTracker.incCounter();
            OCWorkspaceModificationTrackers.this.myPsiTracker.incOutOfCodeBlockModificationCounter();
            if (this.myPublisher != null) {
                this.myPublisher.run();
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (OCWorkspaceModificationTrackers.this.myProject.isDisposed()) {
                        return;
                    }
                    DaemonCodeAnalyzer.getInstance((Project)OCWorkspaceModificationTrackers.this.myProject).restart();
                }
            }, ModalityState.NON_MODAL);
        }
    }
}

