/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeaderRoots;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCResolveRootAndConfiguration {
    private final VirtualFile myRootFile;
    @Nullable
    private final OCResolveConfiguration myConfiguration;
    private final OCLanguageKind myKind;

    public OCResolveRootAndConfiguration(@Nullable OCResolveConfiguration configuration, @NotNull OCLanguageKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/cidr/lang/workspace/OCResolveRootAndConfiguration", "<init>"));
        }
        this.myConfiguration = configuration;
        this.myRootFile = null;
        this.myKind = kind;
    }

    public OCResolveRootAndConfiguration(@Nullable OCResolveConfiguration configuration, @NotNull VirtualFile rootFile) {
        if (rootFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootFile", "com/jetbrains/cidr/lang/workspace/OCResolveRootAndConfiguration", "<init>"));
        }
        this.myConfiguration = configuration;
        this.myRootFile = rootFile;
        this.myKind = null;
    }

    @Nullable
    public VirtualFile getRootFile() {
        return this.myRootFile;
    }

    @Nullable
    public Project getProject() {
        return this.myConfiguration == null ? null : this.myConfiguration.getProject();
    }

    @Nullable
    public OCResolveConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    public OCLanguageKind getKind() {
        return this.myKind;
    }

    @NotNull
    public HeaderRoots getLibraryHeadersRoots() {
        if (this.myConfiguration == null) {
            HeaderRoots headerRoots = HeaderRoots.EMPTY;
            if (headerRoots == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCResolveRootAndConfiguration", "getLibraryHeadersRoots"));
            }
            return headerRoots;
        }
        HeaderRoots headerRoots = this.myConfiguration.getLibraryHeadersRoots(this);
        if (headerRoots == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCResolveRootAndConfiguration", "getLibraryHeadersRoots"));
        }
        return headerRoots;
    }

    @NotNull
    public HeaderRoots getProjectHeadersRoots() {
        if (this.myConfiguration == null) {
            HeaderRoots headerRoots = HeaderRoots.EMPTY;
            if (headerRoots == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCResolveRootAndConfiguration", "getProjectHeadersRoots"));
            }
            return headerRoots;
        }
        HeaderRoots headerRoots = this.myConfiguration.getProjectHeadersRoots();
        if (headerRoots == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCResolveRootAndConfiguration", "getProjectHeadersRoots"));
        }
        return headerRoots;
    }
}

