/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.lexer.OCLexer;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNamesValidator
implements NamesValidator {
    public boolean isKeyword(@NotNull String name, Project project) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/util/OCNamesValidator", "isKeyword"));
        }
        return OCNamesValidator.isKeyword(name);
    }

    public static boolean isKeyword(String name) {
        IElementType tokenType = OCNamesValidator.getTokenType(name, OCLanguageKind.OBJ_CPP);
        return OCTokenTypes.KEYWORDS.contains(tokenType);
    }

    public boolean isIdentifier(@NotNull String name, Project project) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/util/OCNamesValidator", "isIdentifier"));
        }
        return OCNamesValidator.isIdentifier(name);
    }

    public static boolean isIdentifier(String name) {
        return OCNamesValidator.getTokenType(name, OCLanguageKind.OBJ_CPP) == OCTokenTypes.IDENTIFIER;
    }

    @Nullable
    private static IElementType getTokenType(String name, OCLanguageKind kind) {
        OCLexer lexer = new OCLexer(kind, false, false);
        lexer.start(name);
        IElementType tt = lexer.getTokenType();
        lexer.advance();
        return lexer.getTokenType() == null ? tt : null;
    }
}

