/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCallExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCReferenceExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCSizeofExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCNumber;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCExpressionEvaluator {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.editor.OCConstantIntegerExpressionEvaluator");

    private OCExpressionEvaluator() {
    }

    @Nullable
    public static Number evaluate(@Nullable OCExpression psi) {
        if (psi == null) {
            return null;
        }
        Object o = OCExpressionEvaluator.evaluate(psi, new ValueEvaluator(psi));
        if (o instanceof Number) {
            return (Number)o;
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1L : 0L;
        }
        return null;
    }

    @Nullable
    public static Object evaluateToIntOrBoolean(@Nullable OCExpression psi) {
        return psi != null ? OCExpressionEvaluator.evaluate(psi, new ValueEvaluator(psi)) : null;
    }

    public static boolean isPositive(OCExpression psi, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator", "isPositive"));
        }
        Pair<Boolean, Number> result2 = OCExpressionEvaluator.evaluate(psi, new PositiveEvaluator(context));
        return result2 != null ? (Boolean)result2.getFirst() : false;
    }

    @Nullable
    public static OCType getPointerType(OCExpression psi, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator", "getPointerType"));
        }
        return OCExpressionEvaluator.evaluate(psi, new PointerTypeEvaluator(context));
    }

    public static boolean isLikeNil(OCExpression psi, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator", "isLikeNil"));
        }
        return OCExpressionEvaluator.getPointerType(psi, context) instanceof OCUnknownType;
    }

    @Nullable
    public static <T> T evaluate(@Nullable OCExpression psi, CachingEvaluator<T> evaluator) {
        if (psi == null) {
            return null;
        }
        EvaluationVisitor<T> visitor = new EvaluationVisitor<T>(evaluator);
        psi.accept(visitor);
        return (T)((EvaluationVisitor)visitor).getResult();
    }

    @Nullable
    public static Object evaluate(@NotNull OCExpression psi, @NotNull OCResolveContext context) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator", "evaluate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator", "evaluate"));
        }
        return OCExpressionEvaluator.evaluate(psi, new ValueEvaluator(context));
    }

    @Nullable
    public static Object evaluate(@NotNull OCExpressionSymbol symbol, @NotNull OCResolveContext context) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator", "evaluate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator", "evaluate"));
        }
        return symbol.evaluate(new ValueEvaluator(context));
    }

    @Nullable
    public static Object evaluate(@Nullable OCSymbol symbol, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator", "evaluate"));
        }
        return OCExpressionEvaluator.evaluate(symbol, new ValueEvaluator(context));
    }

    @Nullable
    public static <T> T evaluate(@Nullable OCSymbol symbol, @NotNull CachingEvaluator<T> evaluator) {
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator", "evaluate"));
        }
        if (!(symbol instanceof OCDeclaratorSymbol)) {
            return null;
        }
        if (evaluator.contains(symbol)) {
            return evaluator.get(symbol);
        }
        evaluator.cache(symbol, null);
        T result2 = null;
        if (symbol.getKind() == OCSymbolKind.ENUM_CONST) {
            Integer value = OCExpressionEvaluator.evaluateEnumConst(symbol, evaluator);
            if (value != null) {
                result2 = evaluator.evalInteger(value);
            }
        } else if (symbol instanceof OCTypeParameterValueSymbol) {
            OCTypeArgument type = ((OCDeclaratorSymbol)symbol).getSubstitution().getSubstitutionFor((OCTypeParameterSymbol)((Object)symbol));
            if (type instanceof OCExpressionTypeArgument) {
                result2 = ((OCExpressionTypeArgument)type).getSymbol().evaluate(evaluator);
            }
        } else {
            result2 = OCExpressionEvaluator.evaluateConstDeclarator((OCDeclaratorSymbol)symbol, evaluator);
        }
        evaluator.cache(symbol, result2);
        return result2;
    }

    @Nullable
    private static <T> T evaluateConstDeclarator(@NotNull OCDeclaratorSymbol symbol, @NotNull CachingEvaluator<T> evaluator) {
        OCExpressionSymbol initializer;
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator", "evaluateConstDeclarator"));
        }
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator", "evaluateConstDeclarator"));
        }
        if (symbol.isConst() && (initializer = symbol.getInitializer()) != null) {
            OCResolveContext oldContext = evaluator.myContext;
            evaluator.myContext = oldContext.substituteFirst(symbol.getSubstitution());
            T result2 = initializer.evaluate(evaluator);
            evaluator.myContext = oldContext;
            return result2;
        }
        return null;
    }

    @Nullable
    public static Integer evaluateEnumConst(@Nullable OCSymbol symbol, @NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator", "evaluateEnumConst"));
        }
        return OCExpressionEvaluator.evaluateEnumConst(symbol, new ValueEvaluator(new OCResolveContext((PsiElement)file2)));
    }

    @Nullable
    private static <T> Integer evaluateEnumConst(@Nullable OCSymbol symbol, @NotNull CachingEvaluator<T> evaluator) {
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator", "evaluateEnumConst"));
        }
        if (symbol == null || symbol.getKind() != OCSymbolKind.ENUM_CONST || !(symbol instanceof OCDeclaratorSymbol)) {
            return null;
        }
        OCType type = symbol.getType();
        OCDeclaratorSymbol declarator = (OCDeclaratorSymbol)symbol;
        if (type instanceof OCStructType) {
            OCStructType structType = (OCStructType)type;
            List<OCDeclaratorSymbol> fields = structType.getFields();
            int index = fields.indexOf(declarator);
            int base = 0;
            int baseIndex = 0;
            assert (index != -1);
            for (int i = index; i >= 0; --i) {
                OCDeclaratorSymbol field = fields.get(i);
                T initializer = OCExpressionEvaluator.evaluateConstDeclarator(field, evaluator);
                if (!(initializer instanceof Number)) continue;
                base = ((Number)initializer).intValue();
                baseIndex = i;
                break;
            }
            return base + index - baseIndex;
        }
        return null;
    }

    @Nullable
    public static OCSymbol findMatchingEnumConst(OCStructType enumType, int value, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator", "findMatchingEnumConst"));
        }
        OCStructSymbol enumSymbol = enumType.getSymbol();
        if (enumSymbol.getKind() != OCSymbolKind.ENUM) {
            return null;
        }
        int curValue = -1;
        for (OCDeclaratorSymbol field : enumType.getFields()) {
            Object initializer = OCExpressionEvaluator.evaluateConstDeclarator(field, new ValueEvaluator(context));
            curValue = initializer instanceof Number ? ((Number)initializer).intValue() : ++curValue;
            if (curValue != value) continue;
            return field;
        }
        return null;
    }

    @Nullable
    public static Boolean evaluateGNUBuiltInTrait(OCCallExpression expression, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator", "evaluateGNUBuiltInTrait"));
        }
        OCExpression function = expression.getFunctionReferenceExpression();
        List<OCExpression> arguments = expression.getArguments();
        if (!(function instanceof OCReferenceExpression) || arguments.size() != 1 || !(arguments.get(0) instanceof OCReferenceExpression) || context == null) {
            return null;
        }
        OCReferenceElement funElement = ((OCReferenceExpression)function).getReferenceElement();
        OCReferenceElement argElement = ((OCReferenceExpression)arguments.get(0)).getReferenceElement();
        String funName = funElement != null ? funElement.getName() : null;
        String argName = argElement != null ? argElement.getName() : null;
        OCSymbolReference argRef = new OCReferenceTypeBuilder(OCQualifiedName.interned(argName), context.getElement()).build().getReference();
        return OCExpressionEvaluator.evaluateGNUBuiltInTrait(context, funName, argRef);
    }

    @Nullable
    public static Boolean evaluateGNUBuiltInTrait(@NotNull OCResolveContext context, String funName, OCSymbolReference argRef) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator", "evaluateGNUBuiltInTrait"));
        }
        if (funName == null || argRef == null || !funName.startsWith("__")) {
            return null;
        }
        OCReferenceType referenceType = new OCReferenceTypeBuilder(argRef).setSubstitution(context.getSubstitution()).build();
        OCType type = referenceType.resolve(context);
        if (funName.equals("__is_class")) {
            return type instanceof OCStructType && type.isCppStructType();
        }
        if (funName.equals("__is_enum")) {
            return type instanceof OCStructType && ((OCStructType)type).getKind() == OCSymbolKind.ENUM;
        }
        if (funName.equals("__is_union")) {
            return type instanceof OCStructType && ((OCStructType)type).getKind() == OCSymbolKind.UNION;
        }
        if (funName.equals("__is_pod")) {
            return type instanceof OCStructType && ((OCStructType)type).isPOD(false);
        }
        if (funName.equals("__is_abstract")) {
            return type instanceof OCStructType && ((OCStructType)type).isAbstract(context);
        }
        return null;
    }

    public static int singAsInC(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator", "singAsInC"));
        }
        if (o instanceof Boolean) {
            return ((Boolean)o).compareTo(Boolean.FALSE);
        }
        if (o instanceof OCNumber) {
            return ((OCNumber)o).compareTo(BigInteger.ZERO);
        }
        if (o instanceof Long) {
            return ((Long)o).compareTo(0L);
        }
        if (o instanceof Integer) {
            return ((Integer)o).compareTo(0);
        }
        OCLog.LOG.warn("Unknown type in evaluation:" + o.getClass());
        return 0;
    }

    @Contract(value="null -> false")
    public static boolean isIntValue(@Nullable Object o) {
        return o instanceof OCNumber || o instanceof BigInteger || o instanceof Long || o instanceof Integer || o instanceof Short || o instanceof Byte;
    }

    @Contract(value="null -> false")
    public static boolean isNullCompatible(@Nullable Object o) {
        return OCExpressionEvaluator.isIntValue(o) && OCExpressionEvaluator.singAsInC(o) == 0;
    }

    public static class PointerTypeEvaluator
    extends CachingEvaluator<OCType> {
        protected PointerTypeEvaluator(@NotNull OCResolveContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator$PointerTypeEvaluator", "<init>"));
            }
            super(context);
        }

        @Override
        public OCType evalDefault(OCExpression psi) {
            OCType type = psi.getResolvedType(this.myContext);
            return type instanceof OCPointerType ? type : null;
        }

        @Override
        @Nullable
        public OCType evalInteger(Number value) {
            return OCExpressionEvaluator.isNullCompatible(value) ? OCUnknownType.INSTANCE : null;
        }

        @Override
        public OCType evalBool(Boolean value) {
            return value == false ? OCUnknownType.INSTANCE : null;
        }

        @Override
        public OCType evalBinary(OCElementType t, OCType l, OCType r) {
            return null;
        }

        @Override
        public OCType evalUnary(OCElementType t, OCType arg) {
            return null;
        }

        @Override
        public OCType evalConditional(OCType condition, OCType l, OCType r) {
            if (l == OCUnknownType.INSTANCE) {
                return r;
            }
            if (r == OCUnknownType.INSTANCE) {
                return l;
            }
            return null;
        }

        @Override
        @Nullable
        public OCType evalCast(OCType type, OCType operand) {
            return null;
        }

        @Override
        @Nullable
        public OCType evalCall(OCCallExpressionSymbol symbol) {
            return null;
        }

        @Override
        @Nullable
        public OCType evalReference(OCReferenceExpressionSymbol symbol) {
            return null;
        }

        @Override
        @Nullable
        public OCType evalSizeof(OCSizeofExpressionSymbol symbol) {
            return null;
        }
    }

    public static class PositiveEvaluator
    extends CachingEvaluator<Pair<Boolean, Number>> {
        private ValueEvaluator valueEvaluator;

        public PositiveEvaluator(@NotNull OCResolveContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator$PositiveEvaluator", "<init>"));
            }
            super(context);
            this.valueEvaluator = new ValueEvaluator(context);
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalDefault(@NotNull OCExpression psi) {
            if (psi == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator$PositiveEvaluator", "evalDefault"));
            }
            OCType type = psi.getResolvedType(this.valueEvaluator.getContext());
            if (type instanceof OCIntType && !((OCIntType)type).isSigned()) {
                return new Pair((Object)true, null);
            }
            return null;
        }

        @Override
        @NotNull
        public Pair<Boolean, Number> evalInteger(@NotNull Number value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator$PositiveEvaluator", "evalInteger"));
            }
            Pair pair = new Pair((Object)(OCExpressionEvaluator.singAsInC(value) >= 0 ? 1 : 0), (Object)value);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator$PositiveEvaluator", "evalInteger"));
            }
            return pair;
        }

        @Override
        public Pair<Boolean, Number> evalBool(Boolean value) {
            return null;
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalUnary(OCElementType t, Pair<Boolean, Number> arg) {
            if (arg == null) {
                return null;
            }
            Object value = this.valueEvaluator.evalUnary(t, arg.getSecond());
            return new Pair((Object)(value instanceof Number && ((Number)value).longValue() >= 0L ? 1 : 0), (Object)(value instanceof Number ? (Number)((Number)value) : (Number)null));
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalBinary(OCElementType t, Pair<Boolean, Number> l, Pair<Boolean, Number> r) {
            if (l == null || r == null) {
                return null;
            }
            Object value = this.valueEvaluator.evalBinary(t, l.getSecond(), r.getSecond());
            boolean isPositive = value instanceof Number && OCExpressionEvaluator.singAsInC(value) >= 0 || t == OCTokenTypes.PLUS && (Boolean)l.getFirst() != false && (Boolean)r.getFirst() != false;
            return new Pair((Object)isPositive, (Object)(value instanceof Number ? (Number)((Number)value) : (Number)null));
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalConditional(Pair<Boolean, Number> condition, Pair<Boolean, Number> l, Pair<Boolean, Number> r) {
            if (l == null || r == null) {
                return null;
            }
            return new Pair((Object)((Boolean)l.getFirst() != false && (Boolean)r.getFirst() != false ? 1 : 0), null);
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalCast(OCType type, Pair<Boolean, Number> operand) {
            return null;
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalCall(OCCallExpressionSymbol symbol) {
            return null;
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalReference(OCReferenceExpressionSymbol symbol) {
            return null;
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalSizeof(OCSizeofExpressionSymbol symbol) {
            return null;
        }
    }

    public static class ValueEvaluator
    extends CachingEvaluator<Object> {
        public ValueEvaluator(PsiElement element) {
            super(new OCResolveContext(element));
        }

        public ValueEvaluator(@NotNull OCResolveContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator$ValueEvaluator", "<init>"));
            }
            super(context);
        }

        @Override
        public Number evalDefault(OCExpression psi) {
            return null;
        }

        @Override
        public Object evalConditional(Object condition, Object l, Object r) {
            if (condition instanceof Number || condition instanceof Boolean) {
                return OCExpressionEvaluator.singAsInC(condition) == 0 ? r : l;
            }
            return null;
        }

        @Override
        public Object evalInteger(Number value) {
            return value;
        }

        @Override
        public Object evalBool(Boolean value) {
            return value;
        }

        @Override
        @Nullable
        public Object evalBinary(OCElementType t, Object l, Object r) {
            Number rInt;
            Number lInt;
            if (t == OCTokenTypes.OROR && l != null && OCExpressionEvaluator.singAsInC(l) != 0 || t == OCTokenTypes.ANDAND && l != null && OCExpressionEvaluator.singAsInC(l) == 0) {
                return OCExpressionEvaluator.singAsInC(l) != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            if (t == OCTokenTypes.OROR && r != null && OCExpressionEvaluator.singAsInC(r) != 0 || t == OCTokenTypes.ANDAND && r != null && OCExpressionEvaluator.singAsInC(r) == 0) {
                return OCExpressionEvaluator.singAsInC(r) != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            if (l == null || r == null) {
                return null;
            }
            if (l instanceof Boolean && r instanceof Boolean) {
                Boolean lBool = (Boolean)l;
                Boolean rBool = (Boolean)r;
                if (t == OCTokenTypes.OR) {
                    return lBool | rBool;
                }
                if (t == OCTokenTypes.XOR) {
                    return lBool ^ rBool;
                }
                if (t == OCTokenTypes.AND) {
                    return lBool & rBool;
                }
                if (t == OCTokenTypes.OROR) {
                    return lBool != false || rBool != false;
                }
                if (t == OCTokenTypes.ANDAND) {
                    return lBool != false && rBool != false;
                }
            }
            if (l instanceof Boolean) {
                l = (Boolean)l != false ? 1L : 0L;
            }
            if (r instanceof Boolean) {
                r = (Boolean)r != false ? 1L : 0L;
            }
            if (l instanceof Integer) {
                l = ((Number)l).longValue();
            }
            if (r instanceof Integer) {
                r = ((Number)r).longValue();
            }
            if (l instanceof Long && r instanceof Long) {
                lInt = (Long)l;
                rInt = (Long)r;
                if (t == OCTokenTypes.PLUS) {
                    return (Long)lInt + (Long)rInt;
                }
                if (t == OCTokenTypes.MINUS) {
                    return (Long)lInt - (Long)rInt;
                }
                if (t == OCTokenTypes.MUL) {
                    return (Long)lInt * (Long)rInt;
                }
                if (t == OCTokenTypes.DIV) {
                    return (Long)rInt != 0L ? Long.valueOf((Long)lInt / (Long)rInt) : null;
                }
                if (t == OCTokenTypes.PERC) {
                    return (Long)rInt != 0L ? Long.valueOf((Long)lInt % (Long)rInt) : null;
                }
                if (t == OCTokenTypes.OR) {
                    return (Long)lInt | (Long)rInt;
                }
                if (t == OCTokenTypes.XOR) {
                    return (Long)lInt ^ (Long)rInt;
                }
                if (t == OCTokenTypes.AND) {
                    return (Long)lInt & (Long)rInt;
                }
                if (t == OCTokenTypes.LTLT) {
                    return (Long)lInt << (int)((Long)rInt).longValue();
                }
                if (t == OCTokenTypes.GTGT) {
                    return (Long)lInt >> (int)((Long)rInt).longValue();
                }
                if (t == OCTokenTypes.OROR) {
                    return (Long)lInt != 0L || (Long)rInt != 0L ? Boolean.TRUE : Boolean.FALSE;
                }
                if (t == OCTokenTypes.ANDAND) {
                    return (Long)lInt != 0L && (Long)rInt != 0L ? Boolean.TRUE : Boolean.FALSE;
                }
                if (t == OCTokenTypes.LT) {
                    return (Long)lInt < (Long)rInt;
                }
                if (t == OCTokenTypes.LTEQ) {
                    return (Long)lInt <= (Long)rInt;
                }
                if (t == OCTokenTypes.GT) {
                    return (Long)lInt > (Long)rInt;
                }
                if (t == OCTokenTypes.GTEQ) {
                    return (Long)lInt >= (Long)rInt;
                }
                if (t == OCTokenTypes.EQEQ) {
                    return ((Long)lInt).longValue() == ((Long)rInt).longValue();
                }
                if (t == OCTokenTypes.EXCLEQ) {
                    return ((Long)lInt).longValue() != ((Long)rInt).longValue();
                }
            }
            if (l instanceof Long) {
                l = OCNumber.valueOf(((Number)l).longValue());
            }
            if (r instanceof Long) {
                r = OCNumber.valueOf(((Number)r).longValue());
            }
            if (l instanceof OCNumber && r instanceof OCNumber) {
                lInt = (OCNumber)l;
                rInt = (OCNumber)r;
                if (t == OCTokenTypes.PLUS) {
                    return ((OCNumber)lInt).add((BigInteger)rInt);
                }
                if (t == OCTokenTypes.MINUS) {
                    return ((OCNumber)lInt).subtract((BigInteger)rInt);
                }
                if (t == OCTokenTypes.MUL) {
                    return ((OCNumber)lInt).multiply((BigInteger)rInt);
                }
                if (t == OCTokenTypes.DIV) {
                    return ((BigInteger)rInt).equals(BigInteger.ZERO) ? null : ((OCNumber)lInt).divide((BigInteger)rInt);
                }
                if (t == OCTokenTypes.PERC) {
                    return ((BigInteger)rInt).equals(BigInteger.ZERO) ? null : ((OCNumber)lInt).mod((BigInteger)rInt);
                }
                if (t == OCTokenTypes.OR) {
                    return ((OCNumber)lInt).or((BigInteger)rInt);
                }
                if (t == OCTokenTypes.XOR) {
                    return ((OCNumber)lInt).xor((BigInteger)rInt);
                }
                if (t == OCTokenTypes.AND) {
                    return ((OCNumber)lInt).and((BigInteger)rInt);
                }
                if (t == OCTokenTypes.LTLT) {
                    return ((OCNumber)lInt).shiftLeft(((BigInteger)rInt).intValue());
                }
                if (t == OCTokenTypes.GTGT) {
                    return ((OCNumber)lInt).shiftRight(((BigInteger)rInt).intValue());
                }
                if (t == OCTokenTypes.OROR) {
                    return !((BigInteger)lInt).equals(BigInteger.ZERO) || !((BigInteger)rInt).equals(BigInteger.ZERO) ? Boolean.TRUE : Boolean.FALSE;
                }
                if (t == OCTokenTypes.ANDAND) {
                    return !((BigInteger)lInt).equals(BigInteger.ZERO) && !((BigInteger)rInt).equals(BigInteger.ZERO) ? Boolean.TRUE : Boolean.FALSE;
                }
                if (t == OCTokenTypes.LT) {
                    return ((OCNumber)lInt).compareTo((BigInteger)rInt) < 0;
                }
                if (t == OCTokenTypes.LTEQ) {
                    return ((OCNumber)lInt).compareTo((BigInteger)rInt) <= 0;
                }
                if (t == OCTokenTypes.GT) {
                    return ((OCNumber)lInt).compareTo((BigInteger)rInt) > 0;
                }
                if (t == OCTokenTypes.GTEQ) {
                    return ((OCNumber)lInt).compareTo((BigInteger)rInt) >= 0;
                }
                if (t == OCTokenTypes.EQEQ) {
                    return ((OCNumber)lInt).compareTo((BigInteger)rInt) == 0;
                }
                if (t == OCTokenTypes.EXCLEQ) {
                    return ((OCNumber)lInt).compareTo((BigInteger)rInt) != 0;
                }
            }
            if (l instanceof Number && r instanceof Number) {
                return null;
            }
            LOG.error("Unexpected binary operation: " + (Object)((Object)t));
            return null;
        }

        @Override
        @Nullable
        public Object evalUnary(OCElementType t, Object arg) {
            if (arg == null) {
                return null;
            }
            if (arg instanceof Integer) {
                arg = ((Integer)arg).longValue();
            }
            if (t == OCTokenTypes.EXCL && (arg instanceof Number || arg instanceof Boolean)) {
                return OCExpressionEvaluator.singAsInC(arg) == 0 ? 1L : 0L;
            }
            if (t == OCTokenTypes.PLUS && arg instanceof Number) {
                return arg;
            }
            if (t == OCTokenTypes.MINUS) {
                if (arg instanceof Long) {
                    return -((Long)arg).longValue();
                }
                if (arg instanceof OCNumber) {
                    return ((OCNumber)arg).negate();
                }
            }
            if (t == OCTokenTypes.TILDE) {
                if (arg instanceof Long) {
                    return (Long)arg ^ 0xFFFFFFFFFFFFFFFFL;
                }
                if (arg instanceof OCNumber) {
                    return ((OCNumber)arg).inverse();
                }
            }
            return null;
        }

        @Override
        @Nullable
        public Object evalCast(@NotNull OCType type, @Nullable Object operand) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator$ValueEvaluator", "evalCast"));
            }
            if (OCIntType.isBool(type.resolve(this.getContext()), this.getContext().getElement()) && operand instanceof Number) {
                return this.evalBool(OCExpressionEvaluator.singAsInC(operand) != 0);
            }
            return operand;
        }

        @Override
        @Nullable
        public Object evalCall(@NotNull OCCallExpressionSymbol symbol) {
            if (symbol == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator$ValueEvaluator", "evalCall"));
            }
            OCExpressionSymbol callerSymbol = symbol.getCallerSymbol();
            List<OCExpressionSymbol> arguments = symbol.getArguments();
            if (callerSymbol instanceof OCReferenceExpressionSymbol && arguments.size() == 1 && arguments.get(0) instanceof OCReferenceExpressionSymbol) {
                return OCExpressionEvaluator.evaluateGNUBuiltInTrait(this.myContext, callerSymbol.getName(), ((OCReferenceExpressionSymbol)arguments.get(0)).getReference());
            }
            return null;
        }

        @Override
        @Nullable
        public Object evalReference(@NotNull OCReferenceExpressionSymbol symbol) {
            if (symbol == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator$ValueEvaluator", "evalReference"));
            }
            if (OCResolveUtil.isDependentCode(symbol.getReference().getQualifiedName(), this.myContext)) {
                return null;
            }
            OCSymbol target = symbol.resolveToSymbol(this.myContext);
            return target != null ? OCExpressionEvaluator.evaluate(target, this) : null;
        }

        @Override
        @Nullable
        public Object evalSizeof(@NotNull OCSizeofExpressionSymbol symbol) {
            if (symbol == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator$ValueEvaluator", "evalSizeof"));
            }
            OCExpressionSymbol expression = symbol.getExpressionOperand();
            OCType type = expression != null ? expression.getResolvedType(this.myContext) : symbol.getTypeOperand().resolve(this.myContext);
            int bytes = type != null ? type.getSizeInBytes(this.myContext.getFile(), null) : -1;
            return bytes != -1 ? this.evalInteger(bytes) : null;
        }
    }

    private static class EvaluationVisitor<T>
    extends OCVisitor {
        private T myResult;
        private CachingEvaluator<T> myEvaluator;

        public EvaluationVisitor(CachingEvaluator<T> evaluator) {
            this.myEvaluator = evaluator;
        }

        @Nullable
        private T getResult() {
            return this.myResult;
        }

        @Override
        public void visitLiteralExpression(OCLiteralExpression expression) {
            PsiElement argument = expression.getFirstChild();
            if (argument == null) {
                return;
            }
            ASTNode leaf = argument.getNode();
            IElementType type = leaf.getElementType();
            Object value = OCElementUtil.getConstValue(type, leaf.getText(), leaf.getPsi(), null);
            if (value instanceof Number) {
                this.myResult = this.myEvaluator.evalInteger((Number)value);
            } else if (value instanceof Boolean) {
                this.myResult = this.myEvaluator.evalBool((Boolean)value);
            }
        }

        @Override
        public void visitReferenceExpression(OCReferenceExpression expression) {
            OCReferenceElement referenceElement = expression.getReferenceElement();
            OCResolveContext context = this.myEvaluator.getContext();
            OCSymbol symbol = null;
            if (referenceElement != null) {
                symbol = referenceElement.resolveToSymbol(null, context, this.myEvaluator, false, false);
            }
            if (!OCResolveUtil.isDependentCode(expression, context)) {
                this.myResult = OCExpressionEvaluator.evaluate(symbol, this.myEvaluator);
            }
            if (this.myResult == null) {
                this.myResult = this.myEvaluator.evalDefault(expression);
            }
        }

        @Override
        public void visitCastExpression(OCCastExpression expression) {
            this.myResult = OCExpressionEvaluator.evaluate(expression.getOperand(), this.myEvaluator);
            if (this.myResult instanceof Number) {
                OCType type = expression.getResolvedType();
                if (OCIntType.isBool(type, expression)) {
                    this.myResult = this.myEvaluator.evalBool(OCExpressionEvaluator.singAsInC(this.myResult) != 0);
                } else if (type instanceof OCIntType) {
                    this.myResult = this.myEvaluator.evalInteger(OCNumber.convert(OCNumber.valueOf(this.myResult), type.getSizeInBytes(expression.getContainingFile(), null), ((OCIntType)type).isSigned()));
                }
            }
        }

        @Override
        public void visitSizeofExpression(OCSizeofExpression expression) {
            OCType type;
            OCExpression operand = expression.getOperand();
            OCTypeElement typeElement = expression.getTypeElement();
            if (operand != null) {
                type = operand.getResolvedType(this.myEvaluator.getContext());
            } else if (typeElement != null) {
                type = typeElement.getType();
                OCResolveContext context = this.myEvaluator.getContext();
                type = type.resolve(context);
            } else {
                return;
            }
            int bytes = type.getSizeInBytes(expression.getContainingFile(), null);
            if (bytes != -1) {
                this.myResult = this.myEvaluator.evalInteger(bytes);
            }
        }

        @Override
        public void visitParenthesizedExpression(OCParenthesizedExpression expression) {
            this.myResult = OCExpressionEvaluator.evaluate(expression.getOperand(), this.myEvaluator);
        }

        @Override
        public void visitBinaryExpression(OCBinaryExpression expression) {
            OCExpression left = expression.getLeft();
            OCExpression right = expression.getRight();
            OCElementType operator = expression.getOperationSign();
            if (left != null && right != null && !OCCodeInsightUtil.hasSideEffects(left)) {
                if ((operator == OCTokenTypes.XOR || operator == OCTokenTypes.EXCLEQ) && OCParenthesesUtils.areExpressionsEquivalent(left, right, true, this.myEvaluator.getContext())) {
                    this.myResult = this.myEvaluator.evalBool(false);
                } else if (operator == OCTokenTypes.EQEQ && OCParenthesesUtils.areExpressionsEquivalent(left, right, true, this.myEvaluator.getContext())) {
                    this.myResult = this.myEvaluator.evalBool(true);
                } else if ((operator == OCTokenTypes.OROR || operator == OCTokenTypes.XOR || operator == OCTokenTypes.EXCLEQ) && OCParenthesesUtils.areExpressionsOpposite(left, right, true, this.myEvaluator.getContext())) {
                    this.myResult = this.myEvaluator.evalBool(true);
                } else if ((operator == OCTokenTypes.ANDAND || operator == OCTokenTypes.EQEQ) && OCParenthesesUtils.areExpressionsOpposite(left, right, true, this.myEvaluator.getContext())) {
                    this.myResult = this.myEvaluator.evalBool(false);
                }
            }
            if (this.myResult == null) {
                this.myResult = this.myEvaluator.evalBinary(operator, OCExpressionEvaluator.evaluate(left, this.myEvaluator), OCExpressionEvaluator.evaluate(right, this.myEvaluator));
            }
        }

        @Override
        public void visitUnaryExpression(OCUnaryExpression expression) {
            this.myResult = this.myEvaluator.evalUnary(expression.getOperationSign(), OCExpressionEvaluator.evaluate(expression.getOperand(), this.myEvaluator));
        }

        @Override
        public void visitConditionalExpression(OCConditionalExpression expression) {
            this.myResult = this.myEvaluator.evalConditional(OCExpressionEvaluator.evaluate(expression.getCondition(), this.myEvaluator), OCExpressionEvaluator.evaluate(expression.getPositiveExpression(true), this.myEvaluator), OCExpressionEvaluator.evaluate(expression.getNegativeExpression(), this.myEvaluator));
        }

        @Override
        public void visitCompoundInitializer(OCCompoundInitializer initializer) {
            List<OCExpression> expressions = initializer.getInitializerExpressions();
            if (expressions.size() == 1) {
                this.myResult = OCExpressionEvaluator.evaluate(expressions.get(0), this.myEvaluator);
            }
        }

        @Override
        public void visitCallExpression(OCCallExpression expression) {
            Boolean result2 = OCExpressionEvaluator.evaluateGNUBuiltInTrait(expression, this.myEvaluator.getContext());
            this.myResult = result2 != null ? this.myEvaluator.evalBool(result2) : this.myEvaluator.evalDefault(expression);
        }

        @Override
        public void visitExpression(OCExpression expr) {
            this.myResult = this.myEvaluator.evalDefault(expr);
        }
    }

    public static abstract class CachingEvaluator<T>
    implements Evaluator<T> {
        private static final int MAX_SUBSTITUTIONS_PER_SYMBOL = 450;
        private Map<Pair<OCSymbol, OCTypeSubstitution>, T> mySymbolsWithSubstitutions;
        private MostlySingularMultiMap<OCSymbol, OCTypeSubstitution> mySubstitutions;
        @NotNull
        protected OCResolveContext myContext;

        protected CachingEvaluator(@NotNull OCResolveContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator$CachingEvaluator", "<init>"));
            }
            this.mySymbolsWithSubstitutions = new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<Pair<OCSymbol, OCTypeSubstitution>>(){

                public int computeHashCode(Pair<OCSymbol, OCTypeSubstitution> object) {
                    return object.hashCode();
                }

                public boolean equals(Pair<OCSymbol, OCTypeSubstitution> o1, Pair<OCSymbol, OCTypeSubstitution> o2) {
                    return ((OCSymbol)o1.getFirst()).equals(o2.getFirst()) && ((OCTypeSubstitution)o1.getSecond()).equals(o2.getSecond(), CachingEvaluator.this.myContext);
                }
            });
            this.mySubstitutions = new MostlySingularMultiMap();
            this.myContext = context;
        }

        private OCTypeSubstitution getSubstitution(OCSymbol symbol) {
            OCTypeSubstitution substitution = symbol instanceof OCDeclaratorSymbol ? ((OCDeclaratorSymbol)symbol).getSubstitution() : OCTypeSubstitution.ID;
            substitution = OCTypeSubstitution.compose(substitution, this.myContext.getSubstitution(), false, this.myContext);
            return substitution;
        }

        protected void cache(@Nullable OCSymbol symbol, @Nullable T value) {
            OCTypeSubstitution substitution = this.getSubstitution(symbol);
            this.mySymbolsWithSubstitutions.put((Pair<OCSymbol, OCTypeSubstitution>)Pair.create((Object)symbol, (Object)substitution), value);
            if (symbol != null) {
                this.mySubstitutions.add((Object)symbol, (Object)substitution);
            }
        }

        protected boolean contains(@Nullable OCSymbol symbol) {
            OCTypeSubstitution substitution = this.getSubstitution(symbol);
            return this.mySymbolsWithSubstitutions.containsKey(Pair.create((Object)symbol, (Object)substitution)) || symbol != null && ((List)this.mySubstitutions.get((Object)symbol)).size() >= 450;
        }

        @Nullable
        protected T get(@Nullable OCSymbol symbol) {
            return this.mySymbolsWithSubstitutions.get(Pair.create((Object)symbol, (Object)this.getSubstitution(symbol)));
        }

        @NotNull
        public OCResolveContext getContext() {
            OCResolveContext oCResolveContext = this.myContext;
            if (oCResolveContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCExpressionEvaluator$CachingEvaluator", "getContext"));
            }
            return oCResolveContext;
        }
    }

    public static interface Evaluator<T> {
        @Nullable
        public T evalInteger(Number var1);

        @Nullable
        public T evalBool(Boolean var1);

        @Nullable
        public T evalDefault(OCExpression var1);

        @Nullable
        public T evalBinary(OCElementType var1, @Nullable T var2, @Nullable T var3);

        @Nullable
        public T evalUnary(OCElementType var1, @Nullable T var2);

        @Nullable
        public T evalConditional(T var1, @Nullable T var2, @Nullable T var3);

        @Nullable
        public T evalCast(OCType var1, T var2);

        @Nullable
        public T evalCall(OCCallExpressionSymbol var1);

        @Nullable
        public T evalReference(OCReferenceExpressionSymbol var1);

        @Nullable
        public T evalSizeof(OCSizeofExpressionSymbol var1);
    }
}

