/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSymbolTextFieldCompletionProvider
extends TextFieldWithAutoCompletionListProvider<OCSymbol> {
    private final Function<OCSymbol, String> myLookupStringMapper;

    public OCSymbolTextFieldCompletionProvider(@Nullable Function<OCSymbol, String> nameMapper) {
        super(null);
        this.myLookupStringMapper = OCSymbolTextFieldCompletionProvider.wrapMapper(nameMapper);
    }

    @Override
    @NotNull
    public PrefixMatcher createPrefixMatcher(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/cidr/lang/ui/OCSymbolTextFieldCompletionProvider", "createPrefixMatcher"));
        }
        boolean caseSensitive = CodeInsightSettings.getInstance().COMPLETION_CASE_SENSITIVE != 3 && CodeInsightSettings.getInstance().COMPLETION_CASE_SENSITIVE != 2;
        CamelHumpMatcher camelHumpMatcher = new CamelHumpMatcher(prefix, caseSensitive);
        if (camelHumpMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/ui/OCSymbolTextFieldCompletionProvider", "createPrefixMatcher"));
        }
        return camelHumpMatcher;
    }

    @Override
    protected Icon getIcon(@NotNull OCSymbol item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/cidr/lang/ui/OCSymbolTextFieldCompletionProvider", "getIcon"));
        }
        return item.getIcon();
    }

    @Override
    @NotNull
    protected String getLookupString(@NotNull OCSymbol item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/cidr/lang/ui/OCSymbolTextFieldCompletionProvider", "getLookupString"));
        }
        String string = (String)this.myLookupStringMapper.fun((Object)item);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/ui/OCSymbolTextFieldCompletionProvider", "getLookupString"));
        }
        return string;
    }

    @Override
    protected String getTailText(@NotNull OCSymbol item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/cidr/lang/ui/OCSymbolTextFieldCompletionProvider", "getTailText"));
        }
        return null;
    }

    @Override
    protected String getTypeText(@NotNull OCSymbol item) {
        VirtualFile file2;
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/cidr/lang/ui/OCSymbolTextFieldCompletionProvider", "getTypeText"));
        }
        if (item instanceof OCSymbolWithQualifiedName) {
            OCQualifiedName name;
            OCSymbolWithQualifiedName owner = ((OCSymbolWithQualifiedName)item).getResolvedOwner();
            if (item instanceof OCFunctionSymbol && owner != null) {
                owner = owner.getResolvedOwner();
            }
            if (owner != null && (name = owner.getResolvedQualifiedName()) != null) {
                return name.getCanonicalName(true).substring(2);
            }
        }
        return (file2 = item.getContainingFile()) != null ? file2.getName() : "";
    }

    @Override
    public int compare(OCSymbol item1, OCSymbol item2) {
        return item1.getName().compareTo(item2.getName());
    }

    @NotNull
    public Collection<OCSymbol> collectSymbols(final @NotNull Project project, boolean topLevelOnly, final @Nullable Condition<OCSymbol> condition) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/ui/OCSymbolTextFieldCompletionProvider", "collectSymbols"));
        }
        final HashSet set = new HashSet();
        final Collection<OCSymbol> allSymbols = OCSymbolTextFieldCompletionProvider.collectAllSymbols(project, topLevelOnly);
        Collection<OCSymbol> collection = OCSymbolTextFieldCompletionProvider.computeWithWriteActionPriority(new Function<ProgressIndicator, Collection<OCSymbol>>(){

            public Collection<OCSymbol> fun(final ProgressIndicator indicator) {
                CommonProcessors.CollectProcessor<OCSymbol> collector = new CommonProcessors.CollectProcessor<OCSymbol>(){

                    protected boolean accept(final OCSymbol symbol) {
                        ProgressManager.checkCanceled();
                        Boolean res = null;
                        while (res == null) {
                            try {
                                res = (Boolean)ProgressManager.getInstance().runProcess((Computable)new Computable<Boolean>(){

                                    public Boolean compute() {
                                        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                                            public Boolean compute() {
                                                if (project.isDisposed()) {
                                                    return false;
                                                }
                                                String mappedSymbolName = (String)OCSymbolTextFieldCompletionProvider.this.myLookupStringMapper.fun((Object)symbol);
                                                if (mappedSymbolName != null && !set.contains(mappedSymbolName) && (condition == null || condition.value((Object)symbol))) {
                                                    set.add(mappedSymbolName);
                                                    return true;
                                                }
                                                return false;
                                            }
                                        });
                                    }
                                }, indicator);
                            }
                            catch (ProcessCanceledException processCanceledException) {}
                        }
                        return res;
                    }
                };
                ContainerUtil.process((Iterable)allSymbols, (Processor)collector);
                return collector.getResults();
            }
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/ui/OCSymbolTextFieldCompletionProvider", "collectSymbols"));
        }
        return collection;
    }

    @NotNull
    private static Collection<OCSymbol> collectAllSymbols(final Project project, final boolean topLevelOnly) {
        Collection<OCSymbol> collection = OCSymbolTextFieldCompletionProvider.computeWithWriteActionPriority(new Function<ProgressIndicator, Collection<OCSymbol>>(){

            public Collection<OCSymbol> fun(ProgressIndicator indicator) {
                Collection res = null;
                while (res == null) {
                    try {
                        res = (Collection)ProgressManager.getInstance().runProcess((Computable)new Computable<Collection<OCSymbol>>(){

                            public Collection<OCSymbol> compute() {
                                return (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<OCSymbol>>(){

                                    public Collection<OCSymbol> compute() {
                                        if (project.isDisposed()) {
                                            return Collections.emptyList();
                                        }
                                        CommonProcessors.CollectProcessor allCollector = new CommonProcessors.CollectProcessor();
                                        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project, (Processor<OCSymbol>)allCollector, null, topLevelOnly);
                                        return allCollector.getResults();
                                    }
                                });
                            }
                        }, indicator);
                    }
                    catch (ProcessCanceledException processCanceledException) {}
                }
                return res;
            }
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/ui/OCSymbolTextFieldCompletionProvider", "collectAllSymbols"));
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T computeWithWriteActionPriority(@NotNull Function<ProgressIndicator, T> f) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/jetbrains/cidr/lang/ui/OCSymbolTextFieldCompletionProvider", "computeWithWriteActionPriority"));
        }
        Disposable disposable = Disposer.newDisposable();
        EmptyProgressIndicator localIndicator = new EmptyProgressIndicator();
        ProgressIndicatorUtils.forceWriteActionPriority((ProgressIndicator)localIndicator, disposable);
        try {
            Object object = f.fun((Object)localIndicator);
            return (T)object;
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }

    @NotNull
    private static Function<OCSymbol, String> wrapMapper(final @Nullable Function<OCSymbol, String> nameMapper) {
        Function<OCSymbol, String> function = new Function<OCSymbol, String>(){

            public String fun(OCSymbol symbol) {
                String result2 = null;
                if (nameMapper != null) {
                    result2 = (String)nameMapper.fun((Object)symbol);
                }
                return result2 != null ? result2 : symbol.getPresentableName();
            }
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/ui/OCSymbolTextFieldCompletionProvider", "wrapMapper"));
        }
        return function;
    }
}

