/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCInternator;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCCompatibilityAliasSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCGenericParameterSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCNonPrimitiveTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeUnificationVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeResolveVisitor
extends OCNonPrimitiveTypeCloneVisitor {
    private static final int MAX_TYPES_TO_RESOLVE_PER_CONTEXT = 10000;
    private final boolean myResolveIgnoreImports;
    private final boolean myIsInOldC;
    private Set<VirtualFile> myUsedFiles;
    private OCFile myFile;
    @NotNull
    private final OCResolveContext myContext;
    private static final Key<CachedValue<Map<Pair<OCType, OCTypeSubstitution>, Pair<OCType, Collection<VirtualFile>>>>> RESOLVE_CACHE = Key.create((String)"RESOLVE_CACHE_IN_FILE");
    private static final OCInternator<ArrayList<VirtualFile>> USED_FILE_LIST_INTERNATOR = new OCInternator<ArrayList<VirtualFile>>(){

        @Override
        @NotNull
        protected ArrayList<VirtualFile> valueToStore(@NotNull ArrayList<VirtualFile> original) {
            if (original == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/jetbrains/cidr/lang/types/visitors/OCTypeResolveVisitor$2", "valueToStore"));
            }
            original.trimToSize();
            ArrayList<VirtualFile> arrayList = original;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeResolveVisitor$2", "valueToStore"));
            }
            return arrayList;
        }
    };
    private static final Comparator<VirtualFile> FILE_PATH_COMPARATOR = new Comparator<VirtualFile>(){

        @Override
        public int compare(@NotNull VirtualFile o1, @NotNull VirtualFile o2) {
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/jetbrains/cidr/lang/types/visitors/OCTypeResolveVisitor$3", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/jetbrains/cidr/lang/types/visitors/OCTypeResolveVisitor$3", "compare"));
            }
            return Comparing.compare((Comparable)((Object)o1.getPath()), (Comparable)((Object)o2.getPath()));
        }
    };

    public OCTypeResolveVisitor(@NotNull OCResolveContext context, boolean resolveIgnoreImports) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/visitors/OCTypeResolveVisitor", "<init>"));
        }
        this.myUsedFiles = new HashSet<VirtualFile>();
        PsiFile psiFile = context.getFile();
        this.myFile = psiFile instanceof OCFile ? (OCFile)psiFile : null;
        this.myResolveIgnoreImports = resolveIgnoreImports;
        this.myContext = context;
        boolean bl = this.myIsInOldC = this.myFile != null && !this.myFile.isCpp();
        if (this.myFile instanceof OCCodeFragment) {
            PsiElement parent = this.myFile.getContext();
            this.myFile = parent != null ? (OCFile)parent.getContainingFile() : null;
        }
    }

    public OCTypeResolveVisitor(@Nullable PsiFile file2, boolean resolveIgnoreImports) {
        this(new OCResolveContext((PsiElement)file2), resolveIgnoreImports);
    }

    public OCTypeResolveVisitor(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/visitors/OCTypeResolveVisitor", "<init>"));
        }
        this(context, false);
    }

    @Override
    public OCType visitStructType(OCStructType type) {
        return type;
    }

    @Override
    public OCType visitAutoType(OCAutoType type) {
        if (this.myContext.getSubstitution() == OCTypeSubstitution.ID) {
            return (OCType)this.getCachedOrResolve(type, PsiModificationTracker.MODIFICATION_COUNT).getFirst();
        }
        return this.doResolve(type);
    }

    @Override
    public OCType visitReferenceType(OCReferenceType type) {
        Pair resolved;
        if (type.getReference().getQualifiedName().getName() == null) {
            return OCUnknownType.INSTANCE;
        }
        if (this.myFile == null) {
            return type;
        }
        if (!this.myResolveIgnoreImports && type.getReference() instanceof OCSymbolReference.GlobalReference) {
            resolved = this.getCachedOrResolve(type, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        } else {
            OCType resolvedType = this.doResolve(type);
            resolved = Pair.create((Object)resolvedType, this.myUsedFiles);
        }
        OCFileSymbols.markImportsNeeded(this.myFile, (Collection)resolved.second);
        OCType myGuessedType = type.getGuessedType();
        return myGuessedType != type ? ((OCType)resolved.first).cloneWithGuessedType(myGuessedType.resolve(this.myFile)) : (OCType)resolved.first;
    }

    protected Pair<OCType, Collection<VirtualFile>> getCachedOrResolve(OCType type, final Key modificationTracker) {
        Pair resolved;
        OCTypeSubstitution substForCache;
        Pair typeKey;
        Map cacheValue;
        Pair cached;
        CachedValue cache = (CachedValue)this.myFile.getUserData(RESOLVE_CACHE);
        if (cache == null) {
            cache = CachedValuesManager.getManager((Project)this.myFile.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Map<Pair<OCType, OCTypeSubstitution>, Pair<OCType, Collection<VirtualFile>>>>(){

                public CachedValueProvider.Result<Map<Pair<OCType, OCTypeSubstitution>, Pair<OCType, Collection<VirtualFile>>>> compute() {
                    return new CachedValueProvider.Result(OCTypeUtils.newConcurrentTypeMap(), new Object[]{modificationTracker});
                }
            }, false);
            cache = (CachedValue)((UserDataHolderEx)this.myFile).putUserDataIfAbsent(RESOLVE_CACHE, (Object)cache);
        }
        if ((cached = (Pair)(cacheValue = (Map)cache.getValue()).get(typeKey = Pair.create((Object)type, (Object)(substForCache = this.myContext.getSubstitution().getMinimalDependentSubstitution(type, this.myContext))))) == null) {
            OCType resolvedType;
            if (type instanceof OCReferenceType) {
                OCReferenceType referenceType = (OCReferenceType)type;
                resolvedType = this.doResolve(referenceType);
                if (resolvedType instanceof OCArrayType && referenceType.isFunctionParameterType()) {
                    resolvedType = OCFunctionType.convertArrayParameterType(resolvedType);
                }
            } else {
                resolvedType = this.doResolve((OCAutoType)type);
            }
            resolved = Pair.create((Object)resolvedType, this.internedUsedFilesCopy());
            if (!(resolvedType instanceof OCUnknownType) && !(resolvedType instanceof OCReferenceType)) {
                cacheValue.put(typeKey, resolved);
            }
        } else {
            resolved = cached;
            ContainerUtil.addAllNotNull(this.myUsedFiles, (Iterable)((Iterable)cached.getSecond()));
        }
        return resolved;
    }

    @NotNull
    private Collection<VirtualFile> internedUsedFilesCopy() {
        if (this.myUsedFiles.isEmpty()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeResolveVisitor", "internedUsedFilesCopy"));
            }
            return list;
        }
        ArrayList<VirtualFile> copy = new ArrayList<VirtualFile>(this.myUsedFiles);
        Collections.sort(copy, FILE_PATH_COMPARATOR);
        Collection collection = USED_FILE_LIST_INTERNATOR.intern(copy);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeResolveVisitor", "internedUsedFilesCopy"));
        }
        return collection;
    }

    private OCType doResolve(OCReferenceType type) {
        int typesResolved = this.myContext.getTypeResolveCounter();
        this.myContext.incTypeResolveCounter();
        OCQualifiedName qualifiedName = type.getReference().getQualifiedName();
        if (typesResolved > 10000) {
            return new OCMagicType(type);
        }
        Resolver resolver = new Resolver(type);
        String canonicalName = type.getCanonicalName(this.myFile);
        OCSymbolReference.NameWithToken nameWithToken = OCSymbolReference.removeTypeToken(canonicalName);
        if (nameWithToken.typeToken != null) {
            resolver.setPreferableKind(OCSymbolKind.parse(nameWithToken.typeToken));
        }
        if (this.addProcessingType(type)) {
            OCType answer;
            if (qualifiedName.getQualifier() == null && "id".equals(qualifiedName.getName())) {
                OCIdType idType = new OCIdType(resolver.getProtocols(false, true), resolver.getProtocols(false, false), this.myFile.getProject(), false, false);
                return OCPointerType.to((OCType)idType, type.getARCAttribute());
            }
            if (this.myResolveIgnoreImports || !this.processPossibleSymbols(type, resolver, false) && this.myFile.isInLibraries()) {
                this.processPossibleSymbols(type, resolver, true);
            }
            if ((answer = resolver.getAnswer()) != null) {
                answer = answer.cloneWithAddedCVQualifiers(type.getCVQualifiers(), this.myContext.getProject());
            }
            this.removeProcessingType(type);
            return answer != null ? answer : type;
        }
        return OCUnknownType.INSTANCE;
    }

    protected OCType doResolve(OCAutoType type) {
        OCType result2;
        if (!this.addProcessingType(type)) {
            return OCUnknownType.INSTANCE;
        }
        OCResolveContext context = this.myContext.substitute(type.getSubstitution());
        OCExpressionSymbol symbol = type.getExpressionSymbol();
        OCExpression element = type.getExpressionElement();
        if (element != null && element.isValid()) {
            result2 = element.getResolvedType(context);
        } else {
            PsiFile file2;
            if (element != null && (file2 = this.myContext.getFile()) != null) {
                OCLog.LOG.error("Invalid PSI context in auto type", new Attachment[]{new Attachment(file2.getName(), file2.getText())});
            }
            result2 = symbol != null ? symbol.getResolvedType(context) : null;
        }
        this.removeProcessingType(type);
        if (result2 != null && element != null && element.getParent() instanceof OCForeachStatement) {
            result2 = OCCodeInsightUtil.getCollectionElementType(element, result2);
        }
        OCType incompleteType = type.getIncompleteType();
        if (result2 != null && incompleteType != null) {
            HashMap<OCTypeParameterSymbol, OCTypeArgument> substitutionMap;
            ArrayList autoSymbols;
            if (!(incompleteType instanceof OCCppReferenceType) && (result2 = result2.cloneWithCVQualifiers(new CVQualifiers(false, false), context.getProject())) instanceof OCCppReferenceType) {
                result2 = OCCppReferenceType.to(((OCCppReferenceType)result2).getRefType().cloneWithCVQualifiers(new CVQualifiers(false, false), context.getProject()), ((OCCppReferenceType)result2).isRvalueRef(), false, false);
            }
            if (OCSimpleTypeSubstitution.unify(incompleteType = incompleteType.accept(new OCNonPrimitiveTypeCloneVisitor(autoSymbols = new ArrayList(), symbol){
                final /* synthetic */ List val$autoSymbols;
                final /* synthetic */ OCExpressionSymbol val$symbol;
                {
                    this.val$autoSymbols = list;
                    this.val$symbol = oCExpressionSymbol;
                }

                @Override
                public OCType visitAutoType(OCAutoType type) {
                    String name = "auto" + this.val$autoSymbols.size();
                    OCTypeParameterTypeSymbol autoSymbol = new OCTypeParameterTypeSymbol(this.val$symbol.getProject(), this.val$symbol.getContainingFile(), this.val$symbol.getOffset(), name, null, Collections.<String>emptyList(), null, false);
                    this.val$autoSymbols.add(autoSymbol);
                    return new OCTypeParameterType(autoSymbol, type.isConst(), type.isVolatile());
                }
            }), result2, null, substitutionMap = new HashMap<OCTypeParameterSymbol, OCTypeArgument>(), true, context) != OCTypeUnificationVisitor.NOT_UNIFIED) {
                for (OCTypeParameterSymbol autoSymbol : autoSymbols) {
                    if (substitutionMap.containsKey(autoSymbol)) continue;
                    substitutionMap.put(autoSymbol, OCUnknownType.INSTANCE);
                }
                return new OCSimpleTypeSubstitution(substitutionMap).substitute(incompleteType, context);
            }
            return OCUnknownType.INSTANCE;
        }
        return result2 != null ? result2 : OCUnknownType.INSTANCE;
    }

    private boolean processPossibleSymbols(OCReferenceType type, Resolver resolver, boolean ignoreImports) {
        OCResolveContext context = this.myContext.substituteFirst(type.getSubstitution());
        context.setProcessNonImported(ignoreImports);
        boolean oldFlag = context.wasContextUsed();
        List<OCSymbol> symbols = context.resolveToSymbols(type.getReference(), false, false, false, true);
        resolver.myContextWasUsed = context.wasContextUsed();
        context.setContextWasUsed(oldFlag);
        ContainerUtil.process(symbols, (Processor)resolver);
        return !symbols.isEmpty();
    }

    private boolean addProcessingType(OCType type) {
        return this.myContext.getResolvingTypes().add(type);
    }

    private void removeProcessingType(OCType type) {
        this.myContext.getResolvingTypes().remove(type);
    }

    private boolean containsProcessingType(OCType type) {
        return this.myContext.getResolvingTypes().contains(type);
    }

    public static class OCObjectTypeReResolver
    extends OCTypeCloneVisitor {
        private PsiFile myFile;

        public OCObjectTypeReResolver(@Nullable PsiFile file2) {
            super(false);
            this.myFile = file2;
        }

        @Override
        public OCType visitObjectType(OCObjectType type) {
            Function<OCProtocolSymbol, String> protocolNameCalculator = new Function<OCProtocolSymbol, String>(){

                public String fun(OCProtocolSymbol symbol) {
                    return symbol.getName();
                }
            };
            return OCReferenceType.fromText(type.getClassName(), ContainerUtil.map(type.getAllProtocols(), (Function)protocolNameCalculator)).resolve(this.myFile, true);
        }
    }

    private class Resolver
    implements Processor<OCSymbol> {
        private OCReferenceType myType;
        private OCType myAnswer;
        private OCInterfaceSymbol myInterface;
        private OCImplementationSymbol myImplementation;
        private List<OCInterfaceSymbol> myCategoryInterfaces = new ArrayList<OCInterfaceSymbol>();
        private List<OCImplementationSymbol> myCategoryImplementations = new ArrayList<OCImplementationSymbol>();
        private OCSymbolKind myPreferableKind;
        private boolean myContextWasUsed;

        private Resolver(OCReferenceType type) {
            this.myType = type;
        }

        void setPreferableKind(OCSymbolKind kind) {
            this.myPreferableKind = kind;
        }

        private int getInterfaceClassRank(OCInterfaceSymbol clazz) {
            if (clazz == null) {
                return 0;
            }
            if (clazz.isPredeclaration()) {
                return 1;
            }
            return 2;
        }

        public boolean process(OCSymbol symbol) {
            OCSymbol definition;
            if (OCTypeResolveVisitor.this.myResolveIgnoreImports && symbol.isPredeclaration() && (definition = symbol.getDefinitionSymbol()) != null) {
                symbol = definition;
            }
            if (symbol instanceof OCClassSymbol) {
                OCClassSymbol aClass = (OCClassSymbol)symbol;
                if (aClass.getCategoryName() == null) {
                    if (aClass instanceof OCInterfaceSymbol && this.getInterfaceClassRank((OCInterfaceSymbol)aClass) > this.getInterfaceClassRank(this.myInterface)) {
                        this.myInterface = (OCInterfaceSymbol)aClass;
                        this.addUsedImport(symbol);
                    } else if (aClass instanceof OCImplementationSymbol) {
                        this.myImplementation = (OCImplementationSymbol)aClass;
                    }
                } else if (aClass instanceof OCInterfaceSymbol) {
                    this.myCategoryInterfaces.add((OCInterfaceSymbol)aClass);
                    if (!aClass.getProtocolNames().isEmpty()) {
                        this.addUsedImport(symbol);
                    }
                } else if (aClass instanceof OCImplementationSymbol) {
                    this.myCategoryImplementations.add((OCImplementationSymbol)aClass);
                }
            } else if (symbol instanceof OCDeclaratorSymbol || symbol instanceof OCCompatibilityAliasSymbol || symbol instanceof OCAliasUsingSymbol) {
                if (symbol.getKind().isTypedefOrAlias() && (this.isNullOrMagic(this.myAnswer) || this.myAnswer instanceof OCStructType)) {
                    OCType type = this.myType.getSubstitution().substitute(symbol.getType(), OCTypeResolveVisitor.this.myContext);
                    if ((type = type.cloneWithAddedCVQualifiers(this.myType.getCVQualifiers(), OCTypeResolveVisitor.this.myContext.getProject())).getName().startsWith("__builtin")) {
                        this.myAnswer = OCUnknownType.INSTANCE;
                    } else if (!(type instanceof OCReferenceType && OCTypeResolveVisitor.this.containsProcessingType(type) || symbol.getContainingFile() == null || symbol.getProject() == null)) {
                        OCFile containingFile = symbol.getContainingOCFile();
                        if (containingFile != null) {
                            OCQualifiedName qualifiedName;
                            OCType inner = type.accept(OCTypeResolveVisitor.this);
                            inner = this.myType.getSubstitution().substitute(inner, OCTypeResolveVisitor.this.myContext);
                            if (inner instanceof OCStructType) {
                                for (OCStructSymbol innerStruct : ((OCStructType)inner).getStructs()) {
                                    this.storeStructSymbolInAnswer(innerStruct, ((OCStructType)inner).getTypedefName());
                                }
                            }
                            if (this.isNullOrMagic(this.myAnswer)) {
                                this.myAnswer = inner;
                            }
                            if (symbol instanceof OCSymbolWithQualifiedName && (qualifiedName = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName(true, OCTypeResolveVisitor.this.myContext, true, true, true, true, true)) != null) {
                                String alias = qualifiedName.getCanonicalName(OCType.Presentation.FULL, false, OCTypeResolveVisitor.this.myContext, 0);
                                alias = CVQualifiers.appendCVQualifiers(alias, this.myType, OCTypeResolveVisitor.this.myContext.getProject());
                                this.myAnswer = this.myAnswer.equals((Object)OCIntType.BOOL, containingFile) && Comparing.equal((String)"BOOL", (String)alias) ? OCIntType.BOOL : this.myAnswer.cloneWithAliasName(alias);
                            }
                        }
                    } else {
                        this.myAnswer = OCUnknownType.INSTANCE;
                    }
                    this.addUsedImport(symbol);
                    if (this.myAnswer == null) {
                        this.myAnswer = type.cloneWithAliasName(this.myType.getCanonicalName(OCTypeResolveVisitor.this.myFile));
                    }
                    return true;
                }
            } else {
                if (symbol instanceof OCStructSymbol) {
                    if (this.myPreferableKind != null && this.myPreferableKind != symbol.getKind() || OCTypeResolveVisitor.this.myIsInOldC && this.myPreferableKind == null) {
                        return true;
                    }
                    this.addUsedImport(symbol);
                    this.storeStructSymbolInAnswer((OCStructSymbol)symbol, null);
                    return true;
                }
                if (symbol instanceof OCTypeParameterSymbol) {
                    OCTypeArgument argument = this.myType.getSubstitution().getSubstitutionFor((OCTypeParameterSymbol)((Object)symbol));
                    if (argument == null) {
                        argument = OCTypeResolveVisitor.this.myContext.getSubstitution().getSubstitutionFor((OCTypeParameterSymbol)((Object)symbol));
                    }
                    if (argument instanceof OCReferenceType) {
                        this.myAnswer = ((OCReferenceType)argument).accept(OCTypeResolveVisitor.this).cloneWithAliasName(this.myType.getCanonicalName(OCTypeResolveVisitor.this.myFile));
                    } else {
                        if (argument instanceof OCTypeParameterType && OCTypeResolveVisitor.this.addProcessingType((OCType)argument)) {
                            boolean result2 = this.process((OCSymbol)((Object)((OCTypeParameterType)argument).getSymbol()));
                            OCTypeResolveVisitor.this.removeProcessingType((OCType)argument);
                            return result2;
                        }
                        if (argument instanceof OCType) {
                            this.myAnswer = (OCType)argument;
                        } else if (this.myAnswer == null) {
                            this.myAnswer = symbol instanceof OCGenericParameterSymbol ? ((OCGenericParameterSymbol)symbol).getDefaultValue() : new OCTypeParameterType((OCTypeParameterSymbol)((Object)symbol));
                        }
                    }
                } else if (symbol instanceof OCUsingSymbol) {
                    this.addUsedImport(symbol);
                    return ((OCUsingSymbol)symbol).getSymbolReference().processPossibleSymbols((Processor<OCSymbol>)this, OCTypeResolveVisitor.this.myFile);
                }
            }
            return true;
        }

        protected boolean isNullOrMagic(OCType type) {
            return type == null || type instanceof OCTypeParameterType;
        }

        private void addUsedImport(@NotNull OCSymbol symbol) {
            if (symbol == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/types/visitors/OCTypeResolveVisitor$Resolver", "addUsedImport"));
            }
            ContainerUtil.addIfNotNull((Collection)OCTypeResolveVisitor.this.myUsedFiles, (Object)OCFileSymbols.getFileToImport(OCTypeResolveVisitor.this.myFile, symbol));
        }

        private void storeStructSymbolInAnswer(OCStructSymbol symbol, String typedefName) {
            OCStructSymbol substitute = this.myType.getSubstitution().substitute(symbol, OCTypeResolveVisitor.this.myContext);
            if (this.myAnswer instanceof OCStructType) {
                if (((OCStructType)this.myAnswer).isPredeclaration() && !symbol.isPredeclaration()) {
                    ArrayList<OCStructSymbol> innerStructs = new ArrayList<OCStructSymbol>();
                    innerStructs.add(substitute);
                    this.myAnswer = new OCStructType(innerStructs, typedefName);
                } else if (((OCStructType)this.myAnswer).isPredeclaration() == symbol.isPredeclaration() && !((OCStructType)this.myAnswer).getStructs().contains(substitute)) {
                    ((OCStructType)this.myAnswer).getStructs().add(substitute);
                }
            } else if (this.isNullOrMagic(this.myAnswer)) {
                ArrayList<OCStructSymbol> innerStructs = new ArrayList<OCStructSymbol>();
                innerStructs.add(substitute);
                this.myAnswer = new OCStructType(innerStructs, typedefName);
            }
        }

        public List<OCProtocolSymbol> getProtocols(boolean addDeclaredProtocols, boolean isTransitive) {
            ArrayDeque<String> queue = new ArrayDeque<String>(this.myType.getProtocolNames());
            if (addDeclaredProtocols) {
                if (this.myInterface != null) {
                    queue.addAll(this.myInterface.getProtocolNames());
                }
                for (OCInterfaceSymbol category : this.myCategoryInterfaces) {
                    queue.addAll(category.getProtocolNames());
                }
            }
            com.intellij.util.containers.HashSet processed = new com.intellij.util.containers.HashSet();
            ArrayList<OCProtocolSymbol> result2 = new ArrayList<OCProtocolSymbol>();
            while (!queue.isEmpty()) {
                String protocol = (String)queue.poll();
                if (processed.contains(protocol)) continue;
                processed.add(protocol);
                OCClassSymbol foundProtocol = null;
                for (OCSymbol symbol : OCSymbolReference.getGlobalReference(protocol, null).resolveToSymbols(OCTypeResolveVisitor.this.myFile)) {
                    if (!(symbol instanceof OCProtocolSymbol)) continue;
                    if (!symbol.isPredeclaration()) {
                        foundProtocol = (OCProtocolSymbol)symbol;
                        break;
                    }
                    foundProtocol = (OCProtocolSymbol)symbol;
                }
                if (foundProtocol == null) continue;
                result2.add((OCProtocolSymbol)foundProtocol);
                if (!isTransitive) continue;
                queue.addAll(foundProtocol.getProtocolNames());
            }
            return result2;
        }

        @Nullable
        public OCType getAnswer() {
            if (this.myAnswer != null) {
                return this.myAnswer;
            }
            if (this.myInterface != null || this.myImplementation != null || this.myType.getProtocolNames().size() > 0) {
                OCReferenceType superType;
                OCType resolved;
                OCObjectType resolvedSuper = null;
                if ((this.myInterface != null || this.myImplementation != null) && (resolved = OCTypeResolveVisitor.this.visitReferenceType(superType = this.myInterface != null ? this.myInterface.getSuperType() : this.myImplementation.getSuperType())) instanceof OCObjectType) {
                    resolvedSuper = (OCObjectType)resolved;
                }
                return new OCObjectType(this.myInterface, this.myImplementation, this.getProtocols(true, true), this.getProtocols(false, false), this.myCategoryInterfaces, this.myCategoryImplementations, resolvedSuper, false, false, this.myType.isKindof());
            }
            return null;
        }
    }
}

