/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeEqualityVisitor
implements OCTypeVisitor<Boolean> {
    protected OCType myType;
    private final boolean myAssumeMagicTypesEquals;
    private final boolean myAssumeDifferentSubstitutionsEquals;
    private final boolean myAssumeNullSubstitutionsEquals;
    private final boolean myAssumeTypeParametersEquals;
    private final boolean myEvaluateExpressionSubstitutions;
    protected final boolean myDontCheckCV;
    @NotNull
    protected final OCResolveContext myContext;

    public OCTypeEqualityVisitor(OCType type, boolean magicTypesEquals, boolean differentSubstitutionsEquals, boolean typeParametersEquals, boolean constValueEquals, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/visitors/OCTypeEqualityVisitor", "<init>"));
        }
        this(type, magicTypesEquals, differentSubstitutionsEquals, false, typeParametersEquals, true, constValueEquals, context);
    }

    public OCTypeEqualityVisitor(OCType type, boolean magicTypesEquals, boolean differentSubstitutionsEquals, boolean nullSubstitutionsEquals, boolean typeParametersEquals, boolean evaluateExpressionSubstitutions, boolean dontCheckCV, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/visitors/OCTypeEqualityVisitor", "<init>"));
        }
        this.myType = type;
        this.myAssumeMagicTypesEquals = magicTypesEquals;
        this.myAssumeDifferentSubstitutionsEquals = differentSubstitutionsEquals;
        this.myAssumeNullSubstitutionsEquals = nullSubstitutionsEquals;
        this.myAssumeTypeParametersEquals = typeParametersEquals;
        this.myEvaluateExpressionSubstitutions = evaluateExpressionSubstitutions;
        this.myDontCheckCV = dontCheckCV;
        this.myContext = context;
    }

    public OCTypeEqualityVisitor(OCType type, boolean assumeMagicTypesEquals, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/visitors/OCTypeEqualityVisitor", "<init>"));
        }
        this(type, assumeMagicTypesEquals, false, false, false, context);
    }

    public boolean equal(OCType type) {
        return this.equal(type, !this.myDontCheckCV);
    }

    public boolean equal(OCType type, boolean checkCV) {
        if (this.myAssumeMagicTypesEquals && (this.myType instanceof OCMagicType || type instanceof OCMagicType)) {
            return true;
        }
        if (this.myAssumeTypeParametersEquals && (this.myType instanceof OCTypeParameterType || type instanceof OCTypeParameterType)) {
            return true;
        }
        if (checkCV && this.myType.isConst() != type.isConst()) {
            return false;
        }
        if (checkCV && this.myType.isVolatile() != type.isVolatile()) {
            return false;
        }
        return type.accept(this);
    }

    protected boolean equal(@NotNull OCType type1, @NotNull OCType type2, boolean checkConst) {
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "com/jetbrains/cidr/lang/types/visitors/OCTypeEqualityVisitor", "equal"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "com/jetbrains/cidr/lang/types/visitors/OCTypeEqualityVisitor", "equal"));
        }
        OCType save = this.myType;
        this.myType = type2;
        boolean equal = this.equal(type1, checkConst);
        this.myType = save;
        return equal;
    }

    @Override
    public Boolean visitEllipsisReferenceType(OCEllipsisType type) {
        return this.myType != null && type.getClass() == this.myType.getClass();
    }

    @Override
    public Boolean visitFunctionType(OCFunctionType type) {
        if (type == this.myType) {
            return true;
        }
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        OCFunctionType that = (OCFunctionType)this.myType;
        if (!this.isFunctionSignatureEqual(type)) {
            return false;
        }
        if (!this.equal(type.getReturnType(), that.getReturnType(), false)) {
            return false;
        }
        return true;
    }

    public boolean isFunctionSignatureEqual(OCType type) {
        if (!(type instanceof OCFunctionType)) {
            return false;
        }
        if (!(this.myType instanceof OCFunctionType)) {
            return false;
        }
        if (this.myType.isConst() != type.isConst()) {
            return false;
        }
        if (this.myType.isVolatile() != type.isVolatile()) {
            return false;
        }
        OCFunctionType thisFun = (OCFunctionType)type;
        OCFunctionType thatFun = (OCFunctionType)this.myType;
        List<? extends OCType> myArgumentTypes = thisFun.getParameterTypes();
        List<? extends OCType> thatArgumentTypes = thatFun.getParameterTypes();
        if (myArgumentTypes.size() != thatArgumentTypes.size()) {
            return false;
        }
        if (thisFun.isVararg() != thatFun.isVararg()) {
            return false;
        }
        for (int i = 0; i < myArgumentTypes.size(); ++i) {
            if (this.equal(myArgumentTypes.get(i), thatArgumentTypes.get(i), false)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitMagicType(OCMagicType type) {
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        return this.myType == type || ((OCMagicType)this.myType).getMagicName().equals(type.getMagicName());
    }

    @Override
    public Boolean visitTypeParameterType(OCTypeParameterType type) {
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        return this.myType == type || ((OCTypeParameterType)this.myType).getSymbol().equals(type.getSymbol()) && this.visitMagicType(type) != false;
    }

    @Override
    public Boolean visitAutoType(OCAutoType type) {
        if (type == this.myType) {
            return true;
        }
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        OCAutoType that = (OCAutoType)this.myType;
        if (!Comparing.equal((Object)type.getExpressionSymbol(), (Object)that.getExpressionSymbol())) {
            return false;
        }
        OCType incompleteType1 = type.getIncompleteType();
        OCType incompleteType2 = that.getIncompleteType();
        if (!(incompleteType1 == null && incompleteType2 == null || incompleteType1 != null && incompleteType1.equals((Object)incompleteType2, this.myContext))) {
            return false;
        }
        OCTypeSubstitution substitution1 = type.getSubstitution();
        OCTypeSubstitution substitution2 = that.getSubstitution();
        if (!(substitution1 == null && substitution2 == null || substitution1 != null && substitution1.equals(substitution2, this.myContext))) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitObjectType(OCObjectType type) {
        if (type == this.myType) {
            return true;
        }
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        OCObjectType that = (OCObjectType)this.myType;
        if (!Comparing.equal((Object)type.getInterface(), (Object)that.getInterface())) {
            return false;
        }
        if (!Comparing.equal((Object)type.getImplementation(), (Object)that.getImplementation())) {
            return false;
        }
        if (!type.getAllProtocols().equals(that.getAllProtocols())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitArrayType(OCArrayType type) {
        if (this.myType == type) {
            return true;
        }
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        OCArrayType that = (OCArrayType)this.myType;
        if (type.hasLength() && that.hasLength() && type.getLength() != that.getLength()) {
            return false;
        }
        if (type.getARCAttribute() != that.getARCAttribute()) {
            return false;
        }
        if (!this.equal(type.getRefType(), that.getRefType(), true)) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitPointerType(OCPointerType type) {
        if (this.myType == type) {
            return true;
        }
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        OCPointerType that = (OCPointerType)this.myType;
        if (type.getARCAttribute() != that.getARCAttribute()) {
            return false;
        }
        if (!this.equal(type.getRefType(), that.getRefType(), true)) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitBlockPointerType(OCBlockPointerType type) {
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        return this.visitPointerType(type);
    }

    @Override
    public Boolean visitCppReferenceType(OCCppReferenceType type) {
        if (this.myType == type) {
            return true;
        }
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        OCCppReferenceType that = (OCCppReferenceType)this.myType;
        if (!this.equal(type.getRefType(), that.getRefType(), true)) {
            return false;
        }
        if (type.isRvalueRef() != that.isRvalueRef()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitIdType(OCIdType type) {
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        return this.visitObjectType(type);
    }

    @Override
    public Boolean visitIntType(OCIntType type) {
        if (type == this.myType) {
            return true;
        }
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        OCIntType ocIntType = (OCIntType)this.myType;
        if (type.isSigned() != ocIntType.isSigned()) {
            return false;
        }
        if (!type.getCTypeId().equals((Object)ocIntType.getCTypeId())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitRealType(OCRealType type) {
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        return type.getCTypeId().equals((Object)((OCRealType)this.myType).getCTypeId()) && type.isComplex() == ((OCRealType)this.myType).isComplex();
    }

    @Override
    public Boolean visitReferenceType(OCReferenceType type) {
        if (type == this.myType) {
            return true;
        }
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        OCReferenceType that = (OCReferenceType)this.myType;
        if (!type.getProtocolNames().equals(that.getProtocolNames())) {
            return false;
        }
        if (!type.getReference().equals(that.getReference())) {
            return false;
        }
        if (!type.getSubstitution().equals(that.getSubstitution(), this.myContext)) {
            return false;
        }
        if (type.getARCAttribute() != that.getARCAttribute()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitStructType(OCStructType type) {
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        ProgressManager.checkCanceled();
        OCStructType myStructType = (OCStructType)this.myType;
        if (type.getTypedefName() != null && myStructType.getTypedefName() != null && !type.getTypedefName().equals(myStructType.getTypedefName())) {
            return false;
        }
        FactoryMap<OCStructSymbol, String> map = new FactoryMap<OCStructSymbol, String>(){

            @Nullable
            protected String create(OCStructSymbol symbol) {
                return new OCTypeNameVisitor(OCType.Presentation.SHORT, OCTypeEqualityVisitor.this.myContext).getName(symbol.getType());
            }
        };
        Function<OCStructSymbol, String> namer = new Function<OCStructSymbol, String>((FactoryMap)map){
            final /* synthetic */ FactoryMap val$map;
            {
                this.val$map = factoryMap;
            }

            public String fun(OCStructSymbol symbol) {
                return (String)this.val$map.get((Object)symbol);
            }
        };
        HashSet<String> names = new HashSet<String>(ContainerUtil.map(type.getStructs(), (Function)namer));
        names.retainAll(ContainerUtil.map(myStructType.getStructs(), (Function)namer));
        OCStructSymbol thatStruct = OCTypeEqualityVisitor.getTopmostStruct(type.getStructs(), names, namer, this.myContext);
        OCStructSymbol myStruct = OCTypeEqualityVisitor.getTopmostStruct(myStructType.getStructs(), names, namer, this.myContext);
        if (thatStruct == myStruct) {
            return true;
        }
        if (thatStruct.isUnnamed() && myStruct.isUnnamed()) {
            return thatStruct.equals(myStruct);
        }
        if (!thatStruct.resolvedNamesEqual(myStruct)) {
            return false;
        }
        if (this.myAssumeDifferentSubstitutionsEquals) {
            return true;
        }
        List<OCTypeArgument> thatStructArgs = thatStruct.getTemplateArguments(this.myContext);
        List<OCTypeArgument> myStructArgs = myStruct.getTemplateArguments(this.myContext);
        if (thatStructArgs.size() != myStructArgs.size()) {
            return false;
        }
        Iterator thatIterator = thatStructArgs.iterator();
        Iterator myIterator = myStructArgs.iterator();
        while (thatIterator.hasNext() && myIterator.hasNext()) {
            OCTypeArgument thatSubst = (OCTypeArgument)thatIterator.next();
            OCTypeArgument mySubst = (OCTypeArgument)myIterator.next();
            if (this.myAssumeNullSubstitutionsEquals && (thatSubst == null || mySubst == null)) continue;
            if (thatSubst instanceof OCTypeParameterType || mySubst instanceof OCTypeParameterType) {
                if (this.myAssumeTypeParametersEquals || mySubst instanceof OCType && thatSubst instanceof OCType && this.substitutionTypesEqual((OCType)thatSubst, (OCType)mySubst, this.myContext).booleanValue()) continue;
                return false;
            }
            if (thatSubst instanceof OCType && mySubst instanceof OCType) {
                if (this.substitutionTypesEqual((OCType)thatSubst, (OCType)mySubst, this.myContext).booleanValue()) continue;
                return false;
            }
            if (this.myAssumeMagicTypesEquals) continue;
            if (this.myEvaluateExpressionSubstitutions && thatSubst instanceof OCExpressionTypeArgument && mySubst instanceof OCExpressionTypeArgument) {
                Object myValue;
                if (thatSubst.equals(mySubst, this.myContext)) {
                    return true;
                }
                Object thatValue = OCExpressionEvaluator.evaluate(((OCExpressionTypeArgument)thatSubst).getSymbol(), this.myContext);
                if (Comparing.equal((Object)thatValue, (Object)(myValue = OCExpressionEvaluator.evaluate(((OCExpressionTypeArgument)mySubst).getSymbol(), this.myContext)))) continue;
                return false;
            }
            if (Comparing.equal((Object)thatSubst, (Object)mySubst)) continue;
            return false;
        }
        return true;
    }

    protected Boolean substitutionTypesEqual(OCType thatSust, OCType mySust, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/visitors/OCTypeEqualityVisitor", "substitutionTypesEqual"));
        }
        return new OCTypeEqualityVisitor(mySust, this.myAssumeMagicTypesEquals, false, this.myAssumeTypeParametersEquals, false, this.myContext).equal(thatSust);
    }

    private static OCStructSymbol getTopmostStruct(List<OCStructSymbol> structs, Set<String> names, Function<OCStructSymbol, String> namer, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/visitors/OCTypeEqualityVisitor", "getTopmostStruct"));
        }
        if (structs.size() == 1) {
            return structs.get(0);
        }
        for (OCStructSymbol struct : structs) {
            if (struct.isPredeclaration() || !names.contains(namer.fun((Object)struct))) continue;
            return struct;
        }
        int size = Integer.MAX_VALUE;
        OCStructSymbol result2 = null;
        for (OCStructSymbol symbol : structs) {
            OCQualifiedName name = symbol.getResolvedQualifiedName(context, false);
            if (name == null || name.flatten().size() >= size) continue;
            result2 = symbol;
            size = name.flatten().size();
        }
        return result2;
    }

    @Override
    public Boolean visitUnknownType(OCUnknownType type) {
        return this.myType != null && type.getClass() == this.myType.getClass();
    }

    @Override
    public Boolean visitVoidType(OCVoidType type) {
        return this.myType != null && type.getClass() == this.myType.getClass();
    }

    @Override
    public Boolean visitNull() {
        return false;
    }
}

