/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCTypeCompatibilityVisitor_OCIntType
extends OCTypeCompatibilityVisitor<OCIntType> {
    protected OCTypeCompatibilityVisitor_OCIntType(@NotNull OCIntType sourceType, OCExpression source, @Nullable PsiElement context, Set<OCType> processed, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        if (sourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceType", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor_OCIntType", "<init>"));
        }
        if (resolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveContext", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor_OCIntType", "<init>"));
        }
        super(sourceType, source, context, processed, allowImplicitConversions, assumeNullSubstitutionsEquals, resolveContext);
    }

    @Override
    public OCType.TypeCheckResult visitFunctionType(OCFunctionType type) {
        String message = "Taking pointer from integer without a cast";
        return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, "Taking pointer from integer without a cast", OCInspections.ImplicitPointerAndIntegerConversion.class, "ext_typecheck_convert_int_pointer", new IntentionAction[0]);
    }

    @Override
    public OCType.TypeCheckResult visitObjectType(OCObjectType type) {
        return this.visitType(type);
    }

    @Override
    public OCType.TypeCheckResult visitPointerType(OCPointerType type) {
        OCType.TypeCheckResult result2;
        OCType lTerminalType = type.getTerminalType();
        if (((OCIntType)this.mySourceType).isPointerCompatible(this.myContext, false) && !lTerminalType.isUnknown() && type.isPointerToPointerToObjectCompatible() ^ ((OCIntType)this.mySourceType).isPointerToPointerToObjectCompatible() && OCCompilerHelper.isArcEnabled(this.myContext.getContainingFile()) && (result2 = this.checkArcBridgeCast(type, false)) != null) {
            return result2;
        }
        return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, "Taking pointer from integer without a cast", OCInspections.ImplicitPointerAndIntegerConversion.class, "ext_typecheck_convert_int_pointer", new IntentionAction[0]);
    }

    @Override
    public OCType.TypeCheckResult visitStructType(final OCStructType type) {
        if (type.getKind() == OCSymbolKind.ENUM) {
            Object message;
            if (type.isUnnamed() && type.getTypedefName() == null) {
                if (!type.isEnumClass()) {
                    return OK_RESULT;
                }
                message = new Computable<String>(){

                    public String compute() {
                        return "Taking enum class type '" + type.getBestNameInContext(OCTypeCompatibilityVisitor_OCIntType.this.myContext) + "' from integer";
                    }
                };
            } else {
                message = new Computable<String>(){

                    public String compute() {
                        return "Taking enum type '" + type.getBestNameInContext(OCTypeCompatibilityVisitor_OCIntType.this.myContext) + "' from integer";
                    }
                };
            }
            return this.checkAssignToEnum(type, (Computable<String>)message);
        }
        return this.checkStructCompatibleCtor(type);
    }
}

