/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCUnknownExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeUnificationVisitor;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSimpleTypeSubstitution
extends OCTypeSubstitution {
    @NotNull
    private Map<OCTypeParameterSymbol, OCTypeArgument> mySubstitutions;

    public OCSimpleTypeSubstitution() {
    }

    OCSimpleTypeSubstitution(@NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutions) {
        if (substitutions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutions", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "<init>"));
        }
        this.mySubstitutions = substitutions;
    }

    @NotNull
    public Map<OCTypeParameterSymbol, OCTypeArgument> getSubstitutions() {
        Map<OCTypeParameterSymbol, OCTypeArgument> map = this.mySubstitutions;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "getSubstitutions"));
        }
        return map;
    }

    public static OCSimpleTypeSubstitution create(@NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutions) {
        if (substitutions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutions", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "create"));
        }
        return substitutions.isEmpty() ? ID : new OCSimpleTypeSubstitution((Map<OCTypeParameterSymbol, OCTypeArgument>)new HashMap(substitutions));
    }

    @Override
    public boolean hasSubstitutionForName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "hasSubstitutionForName"));
        }
        for (OCTypeParameterSymbol symbol : this.getTypeParameters()) {
            if (!name.equals(symbol.getName())) continue;
            return true;
        }
        return false;
    }

    public Set<OCTypeParameterSymbol> getTypeParameters() {
        return this.mySubstitutions.keySet();
    }

    @Override
    public Collection<OCTypeArgument> getSubstitutedTypes() {
        return this.mySubstitutions.values();
    }

    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "deepEqualStep"));
        }
        OCSimpleTypeSubstitution f = (OCSimpleTypeSubstitution)first;
        OCSimpleTypeSubstitution s = (OCSimpleTypeSubstitution)second;
        return c.equalMaps(f.mySubstitutions, s.mySubstitutions);
    }

    @Override
    protected boolean dependsOn(OCTypeSubstitution substitution, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "dependsOn"));
        }
        for (OCTypeArgument argument : this.mySubstitutions.values()) {
            if (!this.dependsOn(argument, context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public OCType substitute(@NotNull OCType type, final @NotNull OCResolveContext context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "substitute"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "substitute"));
        }
        if (this != ID) {
            return type.transformType(new OCTypeSubstitution.TypeSubstituteVisitor(this, context){

                @Override
                public OCType visitTypeParameterType(OCTypeParameterType type) {
                    OCTypeArgument arg = (OCTypeArgument)OCSimpleTypeSubstitution.this.mySubstitutions.get(type.getSymbol());
                    if (arg != null) {
                        if (arg instanceof OCType) {
                            OCType result2 = (OCType)arg;
                            if (arg instanceof OCReferenceType) {
                                result2 = OCTypeSubstitution.substituteReferenceType((OCReferenceType)arg, OCSimpleTypeSubstitution.this, context);
                            }
                            return result2.cloneWithAddedCVQualifiers(type.getCVQualifiers(), context.getProject());
                        }
                        return new OCMagicType(arg.getNameForPresentation(OCType.Presentation.FULL, null, true, 0));
                    }
                    return type;
                }
            });
        }
        return type;
    }

    /*
     * WARNING - void declaration
     */
    public static List<OCSymbol> resolveTemplateSpecialization(@NotNull List<OCSymbol> symbols, List<OCTypeArgument> arguments, final @Nullable OCSymbolWithQualifiedName context, final @NotNull OCResolveContext resolver) {
        OCSymbol substituted;
        Ref count;
        if (symbols == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbols", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "resolveTemplateSpecialization"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "resolveTemplateSpecialization"));
        }
        if (symbols.isEmpty()) {
            return symbols;
        }
        ArrayList<OCSymbol> predefinitions = new ArrayList<OCSymbol>();
        ArrayList<OCStructSymbol> nonSpecialized = new ArrayList<OCStructSymbol>();
        ArrayList<OCStructSymbol> specialized = new ArrayList<OCStructSymbol>();
        ArrayList<OCSymbol> result2 = new ArrayList<OCSymbol>();
        OCSimpleTypeSubstitution.divideSymbols(symbols, predefinitions, nonSpecialized, specialized);
        List resolvedArguments = ContainerUtil.map(arguments, (Function)new Function<OCTypeArgument, OCTypeArgument>(){

            public OCTypeArgument fun(OCTypeArgument argument) {
                return OCSimpleTypeSubstitution.resolveTypeArgument(resolver, context, Collections.<OCTypeParameterSymbol, OCTypeArgument>emptyMap(), argument);
            }
        });
        if (symbols.size() == 1) {
            OCSymbol symbol = symbols.get(0);
            Ref count2 = new Ref((Object)OCTypeUnificationVisitor.UNKNOWN);
            OCSymbol oCSymbol = OCSimpleTypeSubstitution.applyArgumentsToTemplateSymbol(symbol, specialized.isEmpty() ? symbol : null, resolvedArguments, resolver, context, (Ref<OCTypeUnificationVisitor.UnificationResult>)count2, predefinitions);
            if (specialized.isEmpty() || count2.get() != OCTypeUnificationVisitor.NOT_UNIFIED) {
                result2.add(oCSymbol);
            }
            return result2;
        }
        boolean dependentType = OCSimpleTypeSubstitution.isDependentType(resolvedArguments, resolver);
        if (dependentType) {
            resolver.setWasDependentType(true);
        }
        if (!specialized.isEmpty()) {
            OCSymbol bestSpecialization = null;
            OCTypeUnificationVisitor.UnificationResult unificationResult = OCTypeUnificationVisitor.NOT_UNIFIED;
            for (OCStructSymbol symbol : specialized) {
                void var11_15;
                Ref count3 = new Ref((Object)OCTypeUnificationVisitor.UNKNOWN);
                OCStructSymbol baseSymbol = null;
                if (nonSpecialized.size() == 1) {
                    baseSymbol = nonSpecialized.get(0);
                } else if (predefinitions.size() == 1 && predefinitions.get(0) instanceof OCStructSymbol) {
                    baseSymbol = (OCStructSymbol)predefinitions.get(0);
                }
                OCSymbol substituted3 = OCSimpleTypeSubstitution.applyArgumentsToTemplateSymbol(symbol, baseSymbol, resolvedArguments, resolver, context, (Ref<OCTypeUnificationVisitor.UnificationResult>)count3, predefinitions);
                if (!dependentType && ((OCTypeUnificationVisitor.UnificationResult)count3.get()).isBetter((OCTypeUnificationVisitor.UnificationResult)var11_15)) {
                    bestSpecialization = substituted3;
                    OCTypeUnificationVisitor.UnificationResult unificationResult2 = (OCTypeUnificationVisitor.UnificationResult)count3.get();
                    continue;
                }
                if (!dependentType || count3.get() == OCTypeUnificationVisitor.NOT_UNIFIED) continue;
                result2.add(substituted3);
            }
            if (!dependentType && bestSpecialization != null) {
                result2.add(bestSpecialization);
            }
        }
        if (result2.isEmpty() || dependentType) {
            for (OCStructSymbol oCStructSymbol : nonSpecialized) {
                count = new Ref((Object)OCTypeUnificationVisitor.UNKNOWN);
                substituted = OCSimpleTypeSubstitution.applyArgumentsToTemplateSymbol(oCStructSymbol, oCStructSymbol, resolvedArguments, resolver, context, (Ref<OCTypeUnificationVisitor.UnificationResult>)count, predefinitions);
                if (count.get() == OCTypeUnificationVisitor.NOT_UNIFIED) continue;
                if (dependentType) {
                    result2.add(0, substituted);
                    continue;
                }
                result2.add(substituted);
            }
        }
        if (result2.isEmpty()) {
            for (OCSymbol<OCElement> oCSymbol : predefinitions) {
                count = new Ref((Object)OCTypeUnificationVisitor.UNKNOWN);
                substituted = OCSimpleTypeSubstitution.applyArgumentsToTemplateSymbol(oCSymbol, oCSymbol, resolvedArguments, resolver, context, (Ref<OCTypeUnificationVisitor.UnificationResult>)count, predefinitions);
                if (count.get() == OCTypeUnificationVisitor.NOT_UNIFIED) continue;
                result2.add(substituted);
            }
        }
        return result2;
    }

    protected static void divideSymbols(@NotNull List<OCSymbol> symbols, ArrayList<OCSymbol> predefinitions, ArrayList<OCStructSymbol> nonSpecialized, ArrayList<OCStructSymbol> specialized) {
        if (symbols == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbols", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "divideSymbols"));
        }
        for (OCSymbol symbol : symbols) {
            if (symbol instanceof OCStructSymbol) {
                if (symbol.isPredeclaration()) {
                    predefinitions.add(symbol);
                    continue;
                }
                if (((OCStructSymbol)symbol).getTemplateSpecialization() != null) {
                    specialized.add((OCStructSymbol)symbol);
                    continue;
                }
                nonSpecialized.add((OCStructSymbol)symbol);
                continue;
            }
            predefinitions.add(symbol);
        }
    }

    private static boolean isDependentType(List<OCTypeArgument> arguments, @NotNull OCResolveContext resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "isDependentType"));
        }
        boolean dependentType = false;
        for (OCTypeArgument argument : arguments) {
            if (argument instanceof OCStructType) {
                if (((OCStructType)argument).getStructs().size() <= 1) continue;
                dependentType = true;
                break;
            }
            if (!(argument instanceof OCMagicType) && (!(argument instanceof OCExpressionTypeArgument) || OCExpressionEvaluator.evaluate(((OCExpressionTypeArgument)argument).getSymbol(), resolver) != null)) continue;
            dependentType = true;
            break;
        }
        return dependentType;
    }

    @Override
    public OCTypeArgument getSubstitutionFor(@NotNull OCTypeParameterSymbol param) {
        if (param == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "getSubstitutionFor"));
        }
        return this.mySubstitutions.get(param);
    }

    private static OCSymbol applyArgumentsToTemplateSymbol(OCSymbol symbol, @Nullable OCSymbol baseSymbol, List<OCTypeArgument> resolvedArguments, @NotNull OCResolveContext resolver, @Nullable OCSymbolWithQualifiedName context, @NotNull Ref<OCTypeUnificationVisitor.UnificationResult> specializationCount, List<OCSymbol> predefinitions) {
        List<OCTypeArgument> specialization;
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "applyArgumentsToTemplateSymbol"));
        }
        if (specializationCount == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specializationCount", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "applyArgumentsToTemplateSymbol"));
        }
        HashMap substitutionMap = new HashMap();
        List<OCTypeArgument> list = specialization = symbol instanceof OCStructSymbol ? ((OCStructSymbol)symbol).getTemplateSpecialization() : null;
        if (!(symbol instanceof OCSymbolWithQualifiedName && (specialization != null && specialization.size() >= resolvedArguments.size() || ((OCSymbolWithQualifiedName)symbol).isVariadicTemplate() || baseSymbol instanceof OCSymbolWithQualifiedName && ((OCSymbolWithQualifiedName)baseSymbol).getTemplateParameters().size() >= resolvedArguments.size()))) {
            OCSymbolKind kind = symbol.getKind();
            if (!(kind == OCSymbolKind.TEMPLATE_TYPE_PARAMETER || kind == OCSymbolKind.TEMPLATE_VALUE_PARAMETER || kind == OCSymbolKind.USING_SYMBOL_ALIAS || kind == OCSymbolKind.SYMBOL_USING_SYMBOL || kind == OCSymbolKind.INTERFACE && StringUtil.isNotEmpty((String)((OCInterfaceSymbol)symbol).getCategoryName()))) {
                specializationCount.set((Object)OCTypeUnificationVisitor.NOT_UNIFIED);
            }
            return symbol;
        }
        if (specialization != null) {
            for (int i = 0; i < specialization.size() && i < resolvedArguments.size(); ++i) {
                OCTypeArgument argument = resolvedArguments.get(i);
                OCTypeArgument specializationParam = specialization.get(i);
                if (OCSimpleTypeSubstitution.incompatibleArgument(specializationParam, argument, (Map<OCTypeParameterSymbol, OCTypeArgument>)substitutionMap, resolver)) {
                    specializationCount.set((Object)OCTypeUnificationVisitor.NOT_UNIFIED);
                    return symbol;
                }
                OCTypeArgument spec = OCSimpleTypeSubstitution.resolveTypeArgument(resolver, context, (Map<OCTypeParameterSymbol, OCTypeArgument>)substitutionMap, specializationParam);
                OCTypeUnificationVisitor.UnificationResult result2 = OCSimpleTypeSubstitution.unify(spec, argument, null, (Map<OCTypeParameterSymbol, OCTypeArgument>)substitutionMap, false, resolver);
                specializationCount.set((Object)((OCTypeUnificationVisitor.UnificationResult)specializationCount.get()).add(result2));
                if (!(spec instanceof OCMagicType)) continue;
                ((OCTypeUnificationVisitor.UnificationResult)specializationCount.get()).incNumOfNonSpecializedArgs();
            }
        }
        if (baseSymbol instanceof OCSymbolWithQualifiedName) {
            List<OCTypeParameterSymbol> parameters = ((OCSymbolWithQualifiedName)baseSymbol).getTemplateParameters();
            for (int i = 0; i < parameters.size() && (specialization == null || i < specialization.size()); ++i) {
                OCTypeArgument argument;
                OCTypeParameterSymbol parameterSymbol = parameters.get(i);
                Object defaultValue = parameterSymbol.getDefaultValue();
                OCTypeParameterType parameter = new OCTypeParameterType(parameterSymbol);
                if (i < resolvedArguments.size()) {
                    argument = OCSimpleTypeSubstitution.resolveTypeArgument(resolver, context, (Map<OCTypeParameterSymbol, OCTypeArgument>)substitutionMap, resolvedArguments.get(i));
                } else {
                    if (defaultValue == null) {
                        for (OCSymbol predefinition : predefinitions) {
                            List predefParameters;
                            List<Object> list2 = predefParameters = predefinition instanceof OCSymbolWithQualifiedName ? ((OCSymbolWithQualifiedName)predefinition).getTemplateParameters() : Collections.emptyList();
                            if (predefParameters.size() > i) {
                                defaultValue = ((OCTypeParameterSymbol)predefParameters.get(i)).getDefaultValue();
                            }
                            if (defaultValue == null) continue;
                            break;
                        }
                        if (defaultValue == null) continue;
                    }
                    argument = OCSimpleTypeSubstitution.resolveTypeArgument(resolver, context, (Map<OCTypeParameterSymbol, OCTypeArgument>)substitutionMap, defaultValue);
                    if (specialization != null) {
                        OCTypeArgument specializationParameter = OCSimpleTypeSubstitution.resolveTypeArgument(resolver, context, (Map<OCTypeParameterSymbol, OCTypeArgument>)substitutionMap, specialization.get(i));
                        OCTypeUnificationVisitor.UnificationResult result3 = OCSimpleTypeSubstitution.unify(specializationParameter, argument, null, (Map<OCTypeParameterSymbol, OCTypeArgument>)substitutionMap, false, resolver);
                        specializationCount.set((Object)((OCTypeUnificationVisitor.UnificationResult)specializationCount.get()).add(result3));
                        if (specializationParameter instanceof OCMagicType) {
                            ((OCTypeUnificationVisitor.UnificationResult)specializationCount.get()).incNumOfNonSpecializedArgs();
                        }
                    }
                }
                OCTypeUnificationVisitor.UnificationResult result4 = OCSimpleTypeSubstitution.unify(parameter, argument, null, (Map<OCTypeParameterSymbol, OCTypeArgument>)substitutionMap, false, resolver);
                specializationCount.set((Object)((OCTypeUnificationVisitor.UnificationResult)specializationCount.get()).add(result4));
            }
        }
        OCTypeSubstitution minimalSubstitution = resolver.getSubstitution().getMinimalDependentSubstitution(resolvedArguments, resolver);
        return OCSimpleTypeSubstitution.compose(OCSimpleTypeSubstitution.create((Map<OCTypeParameterSymbol, OCTypeArgument>)substitutionMap), minimalSubstitution, false, resolver).substitute(symbol, null, true, resolver);
    }

    private static boolean incompatibleArgument(@NotNull OCTypeArgument specializationParam, @NotNull OCTypeArgument argument, @NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap, @NotNull OCResolveContext resolver) {
        if (specializationParam == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specializationParam", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "incompatibleArgument"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "incompatibleArgument"));
        }
        if (substitutionMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutionMap", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "incompatibleArgument"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "incompatibleArgument"));
        }
        resolver = resolver.substitute(OCSimpleTypeSubstitution.create(substitutionMap));
        if (specializationParam instanceof OCReferenceType && argument instanceof OCStructType) {
            boolean isStruct;
            OCReferenceType specializationType = (OCReferenceType)specializationParam;
            OCStructType argumentType = (OCStructType)argument;
            List<OCSymbol> specializationSymbols = specializationType.getReference().resolveToSymbols(true, true, false, resolver);
            boolean bl = isStruct = ContainerUtil.findInstance(specializationSymbols, OCStructSymbol.class) != null;
            if (isStruct && !specializationSymbols.contains(argumentType.getSymbol())) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    protected static OCTypeArgument resolveTypeArgument(@NotNull OCResolveContext resolver, @Nullable OCSymbolWithQualifiedName context, Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap, @NotNull OCTypeArgument argument) {
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "resolveTypeArgument"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "resolveTypeArgument"));
        }
        resolver = resolver.substitute(OCSimpleTypeSubstitution.create(substitutionMap));
        if (argument instanceof OCType) {
            argument = ((OCType)argument).transformType(new OCTypeResolveVisitor(resolver));
        } else if (argument instanceof OCExpressionTypeArgument) {
            Object value;
            OCExpressionSymbol expressionSymbol = ((OCExpressionTypeArgument)argument).getSymbol();
            while (context != null) {
                for (OCTypeParameterSymbol parameter : context.getTemplateParameters()) {
                    OCTypeArgument substituted;
                    if (!(parameter instanceof OCTypeParameterValueSymbol) || !((OCTypeParameterValueSymbol)parameter).getName().equals(expressionSymbol.getName()) || (substituted = resolver.getSubstitution().getSubstitutionFor((OCTypeParameterValueSymbol)parameter)) == null) continue;
                    OCTypeArgument oCTypeArgument = substituted;
                    if (oCTypeArgument == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "resolveTypeArgument"));
                    }
                    return oCTypeArgument;
                }
                context = context.getParent();
            }
            if (!(expressionSymbol instanceof OCLiteralExpressionSymbol) && !(expressionSymbol instanceof OCUnknownExpressionSymbol) && (value = OCExpressionEvaluator.evaluate(expressionSymbol, resolver)) != null) {
                OCExpressionTypeArgument oCExpressionTypeArgument = new OCExpressionTypeArgument(new OCLiteralExpressionSymbol(null, null, 0L, value.toString(), value, null, null));
                if (oCExpressionTypeArgument == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "resolveTypeArgument"));
                }
                return oCExpressionTypeArgument;
            }
        }
        OCTypeArgument oCTypeArgument = argument;
        if (oCTypeArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "resolveTypeArgument"));
        }
        return oCTypeArgument;
    }

    public static OCTypeUnificationVisitor.UnificationResult unify(@NotNull OCTypeArgument parameter, @NotNull OCTypeArgument argument, @Nullable Object expression, @NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap, boolean functionParametersMode, @NotNull OCResolveContext context) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "unify"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "unify"));
        }
        if (substitutionMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutionMap", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "unify"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "unify"));
        }
        return new OCTypeUnificationVisitor(functionParametersMode, true, argument, expression, substitutionMap, context).unify(parameter, argument);
    }

    @Override
    public boolean equals(Object o, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "equals"));
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCSimpleTypeSubstitution that = (OCSimpleTypeSubstitution)o;
        if (this.mySubstitutions.size() != that.mySubstitutions.size()) {
            return false;
        }
        try {
            for (Map.Entry<OCTypeParameterSymbol, OCTypeArgument> e : this.mySubstitutions.entrySet()) {
                OCTypeParameterSymbol key = e.getKey();
                OCTypeArgument value = e.getValue();
                if (value == null) {
                    if (that.mySubstitutions.get(key) == null && that.mySubstitutions.containsKey(key)) continue;
                    return false;
                }
                OCTypeArgument argument = that.mySubstitutions.get(key);
                if (!(value instanceof OCType && argument instanceof OCType ? ((OCType)value).accept(new OCTypeEqualityVisitor((OCType)argument, false, false, false, false, false, false, context)) == false : !value.equals(argument, context))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    @NotNull
    String substList() {
        Map<OCTypeParameterSymbol, OCTypeArgument> substitutions = this.mySubstitutions;
        Function<Map.Entry<OCTypeParameterSymbol, OCTypeArgument>, String> converter = new Function<Map.Entry<OCTypeParameterSymbol, OCTypeArgument>, String>(){

            public String fun(Map.Entry<OCTypeParameterSymbol, OCTypeArgument> entry) {
                String valueString;
                String keyString = entry.getKey().toString();
                keyString = keyString.substring(keyString.indexOf(91));
                OCTypeArgument value = entry.getValue();
                if (value instanceof OCTypeParameterType) {
                    valueString = ((OCTypeParameterType)value).getSymbol().toString();
                    valueString = "<param>" + valueString.substring(valueString.indexOf(91));
                } else if (value instanceof OCExpressionTypeArgument) {
                    valueString = ((OCExpressionTypeArgument)value).getSymbol().toString();
                    valueString = "<value>" + valueString.substring(valueString.indexOf(91));
                } else {
                    valueString = value.toString();
                }
                return keyString + " -> " + valueString;
            }
        };
        String string = StringUtil.join((Collection)ContainerUtil.map(substitutions.entrySet(), (Function)converter), (String)", ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution", "substList"));
        }
        return string;
    }

    public String toString() {
        return "{" + this.substList() + "}";
    }

    public int hashCode() {
        return this.mySubstitutions.hashCode();
    }
}

