/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OCArgumentDepLookupAccumulator
implements OCTypeVisitor<Void> {
    private HashSet<OCSymbolWithQualifiedName> mySymbols = new HashSet();

    public HashSet<OCSymbolWithQualifiedName> getAccumulatedSymbols() {
        return this.mySymbols;
    }

    public void visitTypes(Collection<OCType> arguments) {
        for (OCType argument : arguments) {
            argument.accept(this);
        }
    }

    @Override
    @Nullable
    public Void visitEllipsisReferenceType(OCEllipsisType type) {
        return null;
    }

    @Override
    @Nullable
    public Void visitFunctionType(OCFunctionType type) {
        type.getReturnType().accept(this);
        for (OCType oCType : type.getParameterTypes()) {
            oCType.accept(this);
        }
        return null;
    }

    @Override
    @Nullable
    public Void visitMagicType(OCMagicType type) {
        return null;
    }

    @Override
    @Nullable
    public Void visitObjectType(OCObjectType type) {
        return null;
    }

    @Override
    @Nullable
    public Void visitArrayType(OCArrayType type) {
        return type.getRefType().accept(this);
    }

    @Override
    @Nullable
    public Void visitPointerType(OCPointerType type) {
        return type.getRefType().accept(this);
    }

    @Override
    @Nullable
    public Void visitBlockPointerType(OCBlockPointerType type) {
        return type.getRefType().accept(this);
    }

    @Override
    @Nullable
    public Void visitCppReferenceType(OCCppReferenceType type) {
        return type.getRefType().accept(this);
    }

    @Override
    @Nullable
    public Void visitIdType(OCIdType type) {
        return null;
    }

    @Override
    @Nullable
    public Void visitIntType(OCIntType type) {
        return null;
    }

    @Override
    @Nullable
    public Void visitRealType(OCRealType type) {
        return null;
    }

    @Override
    @Nullable
    public Void visitReferenceType(OCReferenceType type) {
        return null;
    }

    @Override
    @Nullable
    public Void visitStructType(OCStructType type) {
        for (OCStructSymbol struct : type.getStructs()) {
            this.mySymbols.add(struct.getParent());
            OCFile file2 = struct.getContainingOCFile();
            if (file2 != null) {
                struct.processBaseClasses(new OCResolveContext(file2), new OCStructSymbol.BaseClassProcessor(){

                    @Override
                    public boolean process(OCSymbol symbol, OCVisibility visibility) {
                        if (symbol instanceof OCStructSymbol) {
                            OCArgumentDepLookupAccumulator.this.mySymbols.add(((OCStructSymbol)symbol).getParent());
                        }
                        return true;
                    }
                });
            }
            for (OCTypeParameterSymbol param : struct.getTemplateParameters()) {
                OCTypeArgument subst = struct.getSubstitution().getSubstitutionFor(param);
                if (!(subst instanceof OCType)) continue;
                ((OCType)subst).accept(this);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Void visitUnknownType(OCUnknownType type) {
        return null;
    }

    @Override
    @Nullable
    public Void visitVoidType(OCVoidType type) {
        return null;
    }

    @Override
    @Nullable
    public Void visitTypeParameterType(OCTypeParameterType type) {
        return null;
    }

    @Override
    @Nullable
    public Void visitAutoType(OCAutoType type) {
        return null;
    }

    public static Collection<OCSymbol> doArgDepLookup(Collection<OCSymbol> symbols, List<OCType> types, List<OCExpression> args, final OCQualifiedName name, OCFile file2) {
        OCArgumentDepLookupAccumulator acc = new OCArgumentDepLookupAccumulator();
        acc.visitTypes(types);
        final CommonProcessors.CollectUniquesProcessor collector = new CommonProcessors.CollectUniquesProcessor();
        ContainerUtil.process(symbols, (Processor)collector);
        for (OCExpression arg : args) {
            OCReferenceElement ref = null;
            if ((arg = OCParenthesesUtils.diveIntoParentheses(arg)) instanceof OCUnaryExpression) {
                OCUnaryExpression unary = (OCUnaryExpression)arg;
                if (unary.isGetAddress() && unary.getOperand() instanceof OCReferenceExpression) {
                    OCReferenceExpression operand = (OCReferenceExpression)unary.getOperand();
                    ref = operand.getReferenceElement();
                }
            } else if (arg instanceof OCReferenceExpression) {
                ref = ((OCReferenceExpression)arg).getReferenceElement();
            } else if (arg instanceof OCReferenceElement) {
                ref = (OCReferenceElement)((Object)arg);
            }
            if (ref == null) continue;
            for (OCSymbol overload : ref.resolveToOverloadsSymbols()) {
                if (!(overload instanceof OCFunctionSymbol)) continue;
                overload.getResolvedType().accept(acc);
            }
        }
        final OCResolveContext context = new OCResolveContext(file2);
        final HashSet processed = new HashSet();
        for (OCSymbolWithQualifiedName parentSymbol : acc.getAccumulatedSymbols()) {
            if (parentSymbol == null) {
                OCStructType.processMembersOfNamespace(file2.getMembersContainer(false), name.getName(), false, false, (Processor<OCSymbol>)collector, context);
                continue;
            }
            if (!(parentSymbol instanceof OCNamespaceLikeSymbol) || name.getQualifier() != null) continue;
            parentSymbol.processSameSymbols(new Processor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    if (processed.add(symbol) && symbol instanceof OCNamespaceLikeSymbol) {
                        OCStructType.processMembersOfNamespace((OCNamespaceLikeSymbol)((Object)symbol), name.getName(), false, false, (Processor<OCSymbol>)collector, context);
                    }
                    return true;
                }
            }, file2);
        }
        return collector.getResults();
    }

    @Override
    public Void visitNull() {
        return null;
    }
}

