/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.symbols.BuilderDriverBase;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCVoidType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeBuilder {
    private final OCLanguageKind myFileKind;
    private final Project myProject;
    private OCType myCurrentType;
    private int longKeywords;
    private List<IElementType> myRefTokens;
    private List<IElementType> myFunctionRefTokens;
    private ArrayList<String> myProtocolList;
    private boolean myIsTypedef;
    private boolean myWasLT;
    private boolean myWasConst;
    private boolean myWasNonArrayExpression;
    private boolean myIsInsideBrackets;
    private boolean myPassByReference;
    private boolean myConst;
    private boolean myWasComplex;
    private OCQualifiedName myPointerQualifier;
    private int myParLevel;
    private BuilderDriverBase.DeclarationContext myLocalContext;
    private OCQualifiedName myNamespaceQualifier;
    private String myName;
    private List<OCTypeArgument> myTypeArguments;
    private int[] myArrayLengths;
    private int myLastIntLiteral;
    private ARCAttribute myARCAttribute;
    private boolean myWasAuto;
    private boolean myIsKindof;

    public OCTypeBuilder(OCLanguageKind fileKind, Project project, @NotNull BuilderDriverBase.DeclarationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/OCTypeBuilder", "<init>"));
        }
        this.longKeywords = 0;
        this.myRefTokens = new ArrayList<IElementType>();
        this.myFunctionRefTokens = new ArrayList<IElementType>();
        this.myProtocolList = null;
        this.myIsTypedef = false;
        this.myWasLT = false;
        this.myWasConst = false;
        this.myWasNonArrayExpression = false;
        this.myIsInsideBrackets = false;
        this.myPassByReference = false;
        this.myParLevel = 0;
        this.myArrayLengths = ArrayUtil.EMPTY_INT_ARRAY;
        this.myLastIntLiteral = -1;
        this.myWasAuto = false;
        this.myIsKindof = false;
        this.myFileKind = fileKind;
        this.myProject = project;
        this.myCurrentType = fileKind.isObjC() ? OCIdType.pointerToID(project) : OCIntType.INT;
        this.myLocalContext = context;
    }

    public void setLocalContext(@NotNull BuilderDriverBase.DeclarationContext localContext) {
        if (localContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localContext", "com/jetbrains/cidr/lang/types/OCTypeBuilder", "setLocalContext"));
        }
        this.myLocalContext = localContext;
    }

    public void setPointerQualifier(OCQualifiedName pointerQualifier) {
        this.myPointerQualifier = pointerQualifier;
    }

    public void learn(IElementType token) {
        this.learn(token, null);
    }

    public void learnNamespaceQualifier(OCQualifiedName qualifier) {
        this.myNamespaceQualifier = qualifier;
    }

    public void learn(IElementType token, @Nullable String tokenText) {
        List<IElementType> refTokens;
        List<IElementType> list = refTokens = this.isInsideParentheses() ? this.myFunctionRefTokens : this.myRefTokens;
        if (token == OCTokenTypes.MUL) {
            refTokens.add(OCTokenTypes.MUL);
            this.myConst = false;
        } else if (token == OCTokenTypes.XOR) {
            refTokens.add(OCTokenTypes.XOR);
            this.myConst = false;
        } else if (token == OCTokenTypes.AND) {
            refTokens.add(OCTokenTypes.AND);
            this.myConst = false;
        } else if (token == OCTokenTypes.ANDAND) {
            refTokens.add(OCTokenTypes.ANDAND);
            this.myConst = false;
        } else if (token == OCTokenTypes.CONST_KEYWORD) {
            refTokens.add(OCTokenTypes.CONST_KEYWORD);
            this.myConst = true;
            this.myWasConst = true;
        } else if (token == OCTokenTypes.VOLATILE_KEYWORD) {
            refTokens.add(OCTokenTypes.VOLATILE_KEYWORD);
        } else if (token == OCTokenTypes.LBRACKET) {
            this.myLastIntLiteral = -1;
            this.myIsInsideBrackets = true;
        } else if (token == OCTokenTypes.RBRACKET) {
            this.myArrayLengths = ArrayUtil.append((int[])this.myArrayLengths, (int)this.myLastIntLiteral);
            refTokens.add(OCTokenTypes.LBRACKET);
            if (this.myLastIntLiteral != -1) {
                this.myConst = true;
            }
            this.myIsInsideBrackets = false;
        } else if (token == OCTokenTypes.LPAR) {
            ++this.myParLevel;
        } else if (token == OCTokenTypes.RPAR) {
            --this.myParLevel;
        }
        if (this.isInsideParentheses()) {
            return;
        }
        if (token == OCTokenTypes.SIGNED_KEYWORD) {
            this.myCurrentType = OCIntType.SCHAR;
        }
        if (token == OCTokenTypes.UNSIGNED_KEYWORD) {
            if (this.myCurrentType == OCIntType.CHAR) {
                this.myCurrentType = OCIntType.UCHAR;
            } else if (this.myCurrentType == OCIntType.SHORT) {
                this.myCurrentType = OCIntType.USHORT;
            } else if (this.myCurrentType == OCIntType.INT || this.myCurrentType.isPointerToID() || this.myWasAuto) {
                this.myCurrentType = OCIntType.UINT;
            } else if (this.myCurrentType == OCIntType.LONG) {
                this.myCurrentType = OCIntType.ULONG;
            } else if (this.myCurrentType == OCIntType.LONGLONG) {
                this.myCurrentType = OCIntType.ULONGLONG;
            } else {
                this.error("unsigned is only applicable to integer types!");
            }
        } else if (token == OCTokenTypes.AUTO_KEYWORD) {
            this.myWasAuto = true;
            this.myCurrentType = new OCAutoType();
        } else if (token == OCTokenTypes.INT_KEYWORD && (this.myCurrentType.isPointerToID() || this.myCurrentType == OCIntType.SCHAR || this.myWasAuto)) {
            this.updateIntegerWidth(OCIntType.INT, OCIntType.UINT);
        } else if (token == OCTokenTypes.CHAR_KEYWORD) {
            if (this.myCurrentType != OCIntType.SCHAR) {
                this.updateIntegerWidth(OCIntType.CHAR, OCIntType.UCHAR);
            }
        } else if (token == OCTokenTypes.SHORT_KEYWORD) {
            this.updateIntegerWidth(OCIntType.SHORT, OCIntType.USHORT);
        } else if (token == OCTokenTypes.LONG_KEYWORD) {
            ++this.longKeywords;
            if (this.myCurrentType == OCRealType.DOUBLE) {
                this.myCurrentType = OCRealType.LONG_DOUBLE;
            } else if (this.myCurrentType == OCIntType.INT || this.myCurrentType == OCIntType.UINT || this.myCurrentType.isPointerToID() || this.myCurrentType == OCIntType.SCHAR || this.myWasAuto) {
                this.updateIntegerWidth(OCIntType.LONG, OCIntType.ULONG);
            } else if (this.longKeywords == 2) {
                this.updateIntegerWidth(OCIntType.LONGLONG, OCIntType.ULONGLONG);
            }
        } else if (token == OCTokenTypes.VOID_KEYWORD) {
            this.myCurrentType = OCVoidType.instance();
        } else if (token == OCTokenTypes._BOOL_KEYWORD) {
            this.myCurrentType = OCIntType.BOOL_NATIVE;
        } else if (token == OCTokenTypes.ELLIPSIS) {
            this.myName = null;
            this.myCurrentType = OCEllipsisType.instance();
        } else if (token == OCTokenTypes.FLOAT_KEYWORD) {
            this.myCurrentType = this.myWasComplex ? OCRealType.COMPLEX_FLOAT : OCRealType.FLOAT;
        } else if (token == OCTokenTypes.DOUBLE_KEYWORD) {
            this.myCurrentType = this.myWasComplex ? (this.longKeywords > 0 ? OCRealType.COMPLEX_LONG_DOUBLE : OCRealType.COMPLEX_DOUBLE) : (this.longKeywords > 0 ? OCRealType.LONG_DOUBLE : OCRealType.DOUBLE);
        } else if (token == OCTokenTypes._COMPLEX_KEYWORD) {
            if (this.myCurrentType instanceof OCRealType) {
                this.myCurrentType = ((OCRealType)this.myCurrentType).cloneWithComplexModifier();
            }
            this.myWasComplex = true;
        } else if (token == OCTokenTypes.LT) {
            this.myWasLT = true;
        } else if (token != OCTokenTypes.GT) {
            if (token == OCTokenTypes.BOOL_CPP_KEYWORD) {
                this.myCurrentType = OCIntType.BOOL_NATIVE;
            } else if (token == OCTokenTypes.WCHAR_T_CPP_KEYWORD) {
                this.myCurrentType = OCIntType.WCHAR;
            } else if (token == OCTokenTypes.CHAR16_T_CPP_KEYWORD) {
                this.myCurrentType = OCIntType.CHAR16;
            } else if (token == OCTokenTypes.CHAR32_T_CPP_KEYWORD) {
                this.myCurrentType = OCIntType.CHAR32;
            } else if (token == OCTokenTypes.INT128_T_CPP_KEYWORD) {
                this.myCurrentType = OCIntType.INT128;
            } else if (token == OCTokenTypes.UINT128_T_CPP_KEYWORD) {
                this.myCurrentType = OCIntType.UINT128;
            } else if (token == OCTokenTypes.IDENTIFIER || token == OCElementTypes.EMPTY_NAME) {
                if (token == OCElementTypes.EMPTY_NAME && this.myWasAuto) {
                    this.myCurrentType = new OCAutoType();
                    return;
                }
                if (!OCElementTypes.PARAMETER_TYPE_QUALIFIERS.contains((Object)tokenText)) {
                    if (this.myProtocolList != null && this.myWasLT) {
                        this.myProtocolList.add(tokenText);
                        this.myProtocolList.trimToSize();
                    } else {
                        if (token == OCElementTypes.EMPTY_NAME && this.myFileKind.isCpp()) {
                            this.myCurrentType = OCIntType.LONG;
                            return;
                        }
                        this.myProtocolList = new ArrayList();
                        this.myName = token == OCElementTypes.EMPTY_NAME ? "id" : tokenText;
                    }
                } else {
                    this.myPassByReference = true;
                }
            } else if (token == OCTokenTypes.TYPEDEF_KEYWORD) {
                this.myIsTypedef = true;
            } else if (OCElementTypes.EXPRESSIONS.contains(token)) {
                if (!this.myIsInsideBrackets) {
                    this.myWasNonArrayExpression = true;
                }
            } else if (token == OCTokenTypes.STRONG_KEYWORD) {
                this.myARCAttribute = ARCAttribute.STRONG;
            } else if (token == OCTokenTypes.WEAK_KEYWORD) {
                this.myARCAttribute = ARCAttribute.WEAK;
            } else if (token == OCTokenTypes.UNSAFE_UNRETAINED_KEYWORD) {
                this.myARCAttribute = ARCAttribute.UNSAFE_UNRETAINED;
            } else if (token == OCTokenTypes.AUTORELEASING_KEYWORD) {
                this.myARCAttribute = ARCAttribute.AUTO_RELEASING;
            } else if (token == OCTokenTypes.KINDOF_KEYWORD) {
                this.myIsKindof = true;
            }
        }
    }

    public void learn(int integer) {
        if (this.myIsInsideBrackets) {
            this.myLastIntLiteral = integer;
        }
    }

    private void updateIntegerWidth(OCIntType signed, OCIntType unsigned) {
        if (this.myCurrentType.isPointerToID() || this.myWasAuto) {
            this.myCurrentType = signed;
            return;
        }
        if (this.myCurrentType instanceof OCIntType) {
            this.myCurrentType = ((OCIntType)this.myCurrentType).isSigned() ? signed : unsigned;
        } else {
            this.error("Illegal combination of type specifiers");
        }
    }

    public void updateArrayLength(int length) {
        if (this.myArrayLengths.length >= 1 && this.myArrayLengths[0] == -1) {
            this.myArrayLengths[0] = length;
        }
    }

    private void error(String message) {
    }

    public OCType getResult() {
        return this.getResult(false);
    }

    public OCType getResult(boolean isFunctionReturnType) {
        if (this.myName != null) {
            OCQualifiedName qualifiedName = this.myTypeArguments == null ? OCQualifiedName.interned(this.myNamespaceQualifier, this.myName) : new OCQualifiedNameWithArguments(this.myNamespaceQualifier, this.myName, this.myTypeArguments);
            this.myCurrentType = this.createReferenceType(qualifiedName);
        }
        List refTokens = this.myRefTokens;
        if (!isFunctionReturnType) {
            refTokens = ContainerUtil.concat(this.myRefTokens, this.myFunctionRefTokens);
            if (!(this.myFunctionRefTokens.isEmpty() || this.myFunctionRefTokens.contains((Object)OCTokenTypes.CONST_KEYWORD) || this.myFunctionRefTokens.contains((Object)OCTokenTypes.RBRACKET))) {
                this.myConst = false;
            }
        }
        return this.getPointerType(this.myCurrentType, refTokens, this.myArrayLengths);
    }

    protected OCReferenceType createReferenceType(OCQualifiedName qualifiedName) {
        PsiElement localContext = this.myLocalContext.getLocalContext();
        ArrayList<String> protocolList = this.myProtocolList;
        if (protocolList == null) {
            protocolList = new ArrayList();
        }
        if (localContext != null) {
            OCReferenceTypeBuilder typeBuilder = new OCReferenceTypeBuilder(qualifiedName, localContext);
            typeBuilder.setProtocolNames(protocolList);
            typeBuilder.setARCAttribute(this.myARCAttribute);
            typeBuilder.setIsKindof(this.myIsKindof);
            return typeBuilder.build();
        }
        OCSymbolWithQualifiedName symbol = this.myLocalContext != null ? this.myLocalContext.getParentSymbol() : null;
        boolean isBaseClause = this.myLocalContext != null && this.myLocalContext.isBaseClause();
        boolean isInsideTemplateParams = this.myLocalContext != null && (this.myLocalContext.isInsideTemplateParams() || this.myLocalContext.isTemplateValueParameter());
        OCReferenceTypeBuilder typeBuilder = new OCReferenceTypeBuilder(qualifiedName, symbol, isBaseClause, isInsideTemplateParams);
        typeBuilder.setProtocolNames(protocolList);
        typeBuilder.setARCAttribute(this.myARCAttribute);
        typeBuilder.setIsKindof(this.myIsKindof);
        OCReferenceType type = typeBuilder.build();
        this.myLocalContext.addSymbolReference(type.getReference());
        return type;
    }

    public OCType createFunction(OCType result2, List<OCType> parameterTypes, List<String> parameterNames, boolean createPointers, boolean isConst, boolean isVolatile) {
        if (parameterTypes != null) {
            result2 = new OCFunctionType(result2, parameterTypes, parameterNames, isConst, isVolatile);
            return createPointers ? this.getPointerType(result2, this.myFunctionRefTokens, null) : result2;
        }
        return result2;
    }

    public void learnTypeArguments(List<OCTypeArgument> arguments) {
        this.myTypeArguments = arguments;
    }

    private OCType getPointerType(OCType type, List<IElementType> refTokens, @Nullable int[] arrayLengths) {
        int arrayLengthCounter;
        int i = 0;
        int n = arrayLengthCounter = arrayLengths != null ? arrayLengths.length - 1 : -1;
        while (i < refTokens.size()) {
            IElementType token;
            if ((token = refTokens.get(i++)) == OCTokenTypes.CONST_KEYWORD) {
                type = type.cloneWithCVQualifiers(new CVQualifiers(true, type.isVolatile()), this.myProject);
            } else if (token == OCTokenTypes.VOLATILE_KEYWORD) {
                type = type.cloneWithCVQualifiers(new CVQualifiers(type.isConst(), true), this.myProject);
            } else if (token == OCTokenTypes.LBRACKET) {
                type = arrayLengthCounter >= 0 ? OCArrayType.to(type, arrayLengths[arrayLengthCounter--], this.myARCAttribute) : OCArrayType.to(type, -1, this.myARCAttribute);
            } else if (token == OCTokenTypes.XOR) {
                type = OCBlockPointerType.blockPtr(type, this.myARCAttribute, false, false);
            } else if (token == OCTokenTypes.AND) {
                type = OCCppReferenceType.to(type);
            } else if (token == OCTokenTypes.ANDAND) {
                type = OCCppReferenceType.rvalue(type);
            } else if (token == OCTokenTypes.MUL) {
                type = this.myPointerQualifier != null ? OCPointerType.to(type, this.myARCAttribute, this.createReferenceType(this.myPointerQualifier)) : OCPointerType.to(type, this.myARCAttribute);
            }
            this.myARCAttribute = null;
        }
        return type;
    }

    public OCTypeBuilder copy() {
        OCTypeBuilder answer = new OCTypeBuilder(this.myFileKind, this.myProject, this.myLocalContext);
        answer.myCurrentType = this.myCurrentType;
        answer.myName = this.myName;
        answer.myProtocolList = this.myProtocolList;
        answer.myRefTokens = new ArrayList<IElementType>(this.myRefTokens);
        answer.myIsTypedef = this.myIsTypedef;
        answer.myLocalContext = this.myLocalContext;
        answer.myPointerQualifier = this.myPointerQualifier;
        answer.myConst = this.myConst;
        answer.myWasConst = this.myWasConst;
        answer.myWasAuto = this.myWasAuto;
        answer.myWasComplex = this.myWasComplex;
        answer.myArrayLengths = this.myArrayLengths;
        answer.myNamespaceQualifier = this.myNamespaceQualifier;
        answer.myTypeArguments = this.myTypeArguments;
        answer.myARCAttribute = this.myARCAttribute;
        answer.myIsKindof = this.myIsKindof;
        return answer;
    }

    public boolean isTypedef() {
        return this.myIsTypedef;
    }

    public boolean isPassByReference() {
        return this.myPassByReference;
    }

    public void learnBaseType(OCType type) {
        this.myCurrentType = type;
    }

    public int[] getArrayLengths() {
        return this.myArrayLengths;
    }

    public boolean isConst() {
        return this.myConst;
    }

    public boolean wasAuto() {
        return this.myWasAuto;
    }

    public boolean eraseWasConst() {
        boolean result2 = this.myWasConst;
        this.myWasConst = false;
        return result2;
    }

    public boolean wasNonArrayExpression() {
        return this.myWasNonArrayExpression;
    }

    public boolean isInsideParentheses() {
        return this.myParLevel > 0;
    }
}

