/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStructType
extends OCType {
    @NotNull
    private List<OCStructSymbol> myStruct;
    @Nullable
    private String myTypedefName;

    public OCStructType() {
    }

    public OCStructType(@NotNull OCStructSymbol struct) {
        if (struct == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "struct", "com/jetbrains/cidr/lang/types/OCStructType", "<init>"));
        }
        this(struct, null);
    }

    public OCStructType(@NotNull List<OCStructSymbol> struct) {
        if (struct == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "struct", "com/jetbrains/cidr/lang/types/OCStructType", "<init>"));
        }
        this.myStruct = struct;
        this.myTypedefName = null;
    }

    public OCStructType(@NotNull OCStructSymbol struct, @Nullable String typedefName) {
        if (struct == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "struct", "com/jetbrains/cidr/lang/types/OCStructType", "<init>"));
        }
        this.myStruct = Collections.singletonList(struct);
        this.myTypedefName = typedefName;
    }

    public OCStructType(@NotNull List<OCStructSymbol> structs, @Nullable String typedefName) {
        if (structs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structs", "com/jetbrains/cidr/lang/types/OCStructType", "<init>"));
        }
        this(structs, typedefName, false, false);
    }

    public OCStructType(@NotNull List<OCStructSymbol> structs, @Nullable String typedefName, boolean isConst, boolean isVolatile) {
        if (structs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structs", "com/jetbrains/cidr/lang/types/OCStructType", "<init>"));
        }
        super(isConst, isVolatile);
        this.myStruct = structs;
        this.myTypedefName = typedefName;
    }

    @NotNull
    public Collection<OCSymbol> collectMethods(@NotNull String methodName, OCResolveContext context) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/jetbrains/cidr/lang/types/OCStructType", "collectMethods"));
        }
        CommonProcessors.CollectProcessor<OCSymbol> collector = new CommonProcessors.CollectProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol instanceof OCFunctionSymbol;
            }
        };
        this.processMembers(methodName, (Processor<OCSymbol>)collector, context);
        Collection collection = collector.getResults();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCStructType", "collectMethods"));
        }
        return collection;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/types/OCStructType", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/types/OCStructType", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/types/OCStructType", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCStructType f = (OCStructType)first;
        OCStructType s = (OCStructType)second;
        if (!Comparing.equal((String)f.myTypedefName, (String)s.myTypedefName)) {
            return false;
        }
        return c.equalIterable(f.myStruct, s.myStruct);
    }

    @Override
    public int hashCode() {
        return this.baseHashCode() * 31 + this.myStruct.get(0).hashCode();
    }

    public List<OCStructSymbol> getStructs() {
        return this.myStruct;
    }

    @Nullable
    public String getTypedefName() {
        return this.myTypedefName;
    }

    @NotNull
    public OCStructSymbol getSymbol() {
        OCStructSymbol oCStructSymbol = this.myStruct.get(0);
        if (oCStructSymbol == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCStructType", "getSymbol"));
        }
        return oCStructSymbol;
    }

    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = this.myStruct.get(0).getKind();
        if (oCSymbolKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCStructType", "getKind"));
        }
        return oCSymbolKind;
    }

    public boolean isEnumClass() {
        return this.myStruct.get(0).isEnumClass();
    }

    public boolean isEnum() {
        return this.myStruct.get(0).isEnum();
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitStructType(this);
    }

    @Nullable
    public OCDeclaratorSymbol findField(String name) {
        for (OCStructSymbol struct : this.myStruct) {
            OCDeclaratorSymbol field = struct.findField(name);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    @NotNull
    public List<OCDeclaratorSymbol> getFields() {
        CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
        this.myStruct.get(0).processFields((Processor<OCDeclaratorSymbol>)collector);
        List results = (List)collector.getResults();
        Collections.sort(results, new Comparator<OCDeclaratorSymbol>(){

            @Override
            public int compare(OCDeclaratorSymbol o1, OCDeclaratorSymbol o2) {
                return OCSymbolOffsetUtil.compare(o1.getComplexOffset(), o2.getComplexOffset());
            }
        });
        List list = results;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCStructType", "getFields"));
        }
        return list;
    }

    public OCSymbol findConstructor(@NotNull List<OCExpression> argumentExprs, OCFile file2) {
        if (argumentExprs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentExprs", "com/jetbrains/cidr/lang/types/OCStructType", "findConstructor"));
        }
        return this.findConstructor(ContainerUtil.map(argumentExprs, (Function)new Function<OCExpression, OCType>(){

            public OCType fun(OCExpression expression) {
                return expression.getResolvedType();
            }
        }), argumentExprs, file2, true);
    }

    public OCSymbol findConstructor(@NotNull List<OCType> argumentTypes, @Nullable List<OCExpression> argumentExprs, OCFile file2, boolean allowImplicitConversions) {
        if (argumentTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypes", "com/jetbrains/cidr/lang/types/OCStructType", "findConstructor"));
        }
        final OCResolveContext context = new OCResolveContext(file2);
        final Collection<OCSymbol> symbols = this.collectMethods(this.getSymbol().getName(), context);
        this.getSymbol().processMembers((String)null, new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                if (symbol instanceof OCUsingSymbol) {
                    ((OCUsingSymbol)symbol).getSymbolReference().processPossibleSymbols(new Processor<OCSymbol>(){

                        public boolean process(OCSymbol symbol) {
                            if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor()) {
                                symbols.add(symbol);
                            }
                            return true;
                        }
                    }, context);
                }
                return true;
            }
        });
        return OCResolveOverloadsUtil.resolveOverloads(this, symbols, argumentTypes, argumentExprs, null, null, allowImplicitConversions, false, false, new OCResolveContext(file2));
    }

    public boolean isEmpty() {
        return this.isEmpty(new HashSet<OCStructSymbol>());
    }

    public boolean isEmpty(final HashSet<OCStructSymbol> processed) {
        final boolean[] result2 = new boolean[]{true};
        for (OCStructSymbol struct : this.myStruct) {
            if (processed.add(struct)) {
                if (struct.getKind() == OCSymbolKind.ENUM) {
                    return false;
                }
                struct.processFields(new Processor<OCDeclaratorSymbol>(){

                    public boolean process(OCDeclaratorSymbol symbol) {
                        OCType elementType = symbol.getResolvedType();
                        if (elementType instanceof OCArrayType) {
                            if (!((OCArrayType)elementType).isEmpty(symbol.getContainingOCFile(), processed)) {
                                result2[0] = false;
                            }
                        } else if (elementType instanceof OCStructType) {
                            if (!((OCStructType)elementType).isEmpty(processed)) {
                                result2[0] = false;
                            }
                        } else {
                            result2[0] = false;
                        }
                        return true;
                    }
                });
                processed.remove(struct);
                continue;
            }
            return false;
        }
        return result2[0];
    }

    public boolean processFields(@Nullable String fieldName, final Processor<? super OCDeclaratorSymbol> processor2, OCResolveContext context) {
        return this.processMembers(fieldName, new Processor<OCSymbol>(){

            public boolean process(OCSymbol ocSymbol) {
                if (ocSymbol instanceof OCDeclaratorSymbol) {
                    return processor2.process((Object)((OCDeclaratorSymbol)ocSymbol));
                }
                return true;
            }
        }, context);
    }

    public boolean isAbstract(OCResolveContext context) {
        return !this.processMembers(null, new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                return !(symbol instanceof OCFunctionSymbol) || !((OCFunctionSymbol)symbol).isPureVirtual();
            }
        }, context);
    }

    public boolean isUnnamed() {
        return this.myStruct.get(0).isUnnamed();
    }

    public boolean isPredeclaration() {
        for (OCStructSymbol struct : this.myStruct) {
            if (struct.isPredeclaration()) continue;
            return false;
        }
        return true;
    }

    public boolean isPOD(final boolean checkInnerStructs) {
        return !ContainerUtil.exists(this.myStruct, (Condition)new Condition<OCStructSymbol>(){

            public boolean value(OCStructSymbol symbol) {
                return !symbol.isPOD(checkInnerStructs);
            }
        });
    }

    public static boolean processMembersInBaseTypes(final @NotNull OCStructSymbol scope, final @Nullable String memberName, final boolean typesOnly, boolean goTransitive, final @NotNull Condition<OCSymbol> condition, final @NotNull Processor<OCSymbol> processor2, final @NotNull OCResolveContext context) {
        HashSet processedSet;
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/cidr/lang/types/OCStructType", "processMembersInBaseTypes"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/jetbrains/cidr/lang/types/OCStructType", "processMembersInBaseTypes"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/types/OCStructType", "processMembersInBaseTypes"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/OCStructType", "processMembersInBaseTypes"));
        }
        final Set<OCNamespaceLikeSymbol> processed = OCTypeUtils.newSymbolWithSubstitutionSet();
        final Stack<Pair> workset = new Stack<Pair>();
        final FilteringProcessor filteringProcessor = new FilteringProcessor(condition, processor2);
        if (!goTransitive && memberName == null) {
            processedSet = new HashSet();
            goTransitive = true;
        } else {
            processedSet = null;
        }
        processed.add(scope);
        workset.add(new Pair((Object)scope, processedSet));
        while (!workset.isEmpty()) {
            ProgressManager.checkCanceled();
            final Pair pair = (Pair)workset.pop();
            if (!(pair.getFirst() instanceof OCStructSymbol)) continue;
            OCStructSymbol structSymbol = (OCStructSymbol)pair.getFirst();
            final boolean finalGoTransitive = goTransitive;
            structSymbol.processBaseClasses(context.useFor(scope), new OCStructSymbol.BaseClassProcessor(){

                @Override
                public boolean process(OCSymbol symbol, OCVisibility visibility) {
                    if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor() && symbol.getName().equals(memberName) && !filteringProcessor.process((Object)symbol)) {
                        return false;
                    }
                    HashSet<String> alreadyProcessed = pair.getSecond() != null ? new HashSet<String>((Collection)pair.getSecond()) : null;
                    InnerProcessor resolver = new InnerProcessor(memberName, typesOnly, finalGoTransitive, alreadyProcessed, scope.getSubstitution(), processed, workset, (Processor<OCSymbol>)processor2, (Condition<OCSymbol>)condition, context);
                    return resolver.process(symbol);
                }
            });
        }
        return true;
    }

    public static boolean processMembersOfNamespace(@NotNull OCNamespaceLikeSymbol namespace, @Nullable String memberName, boolean lookInsideUsings, boolean typesOnly, Processor<OCSymbol> processor2, @NotNull OCResolveContext context) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/jetbrains/cidr/lang/types/OCStructType", "processMembersOfNamespace"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/OCStructType", "processMembersOfNamespace"));
        }
        class SomethingProcessedDetector
        implements Processor<OCSymbol> {
            private final Processor<OCSymbol> myProcessor;
            private boolean mySomethingProcessed = false;
            private boolean myNamespaceProcessed = false;

            SomethingProcessedDetector(Processor<OCSymbol> processor2) {
                this.myProcessor = processor2;
            }

            public boolean process(OCSymbol symbol) {
                this.mySomethingProcessed = true;
                if (symbol.getKind() == OCSymbolKind.NAMESPACE) {
                    this.myNamespaceProcessed = true;
                }
                return this.myProcessor.process((Object)symbol);
            }
        }
        SomethingProcessedDetector detector = new SomethingProcessedDetector(processor2);
        FilteringProcessor filter = new FilteringProcessor(OCSymbolWithQualifiedName.WITHOUT_QUALIFIER, (Processor)detector);
        if (!namespace.processMembers(memberName, filter)) {
            return false;
        }
        Set<OCNamespaceLikeSymbol> processed = OCTypeUtils.newSymbolWithSubstitutionSet();
        Stack<Pair<OCNamespaceLikeSymbol, Set<String>>> workset = new Stack<Pair<OCNamespaceLikeSymbol, Set<String>>>();
        processed.add(namespace);
        workset.add(new Pair((Object)namespace, null));
        Collection<OCNamespaceSymbol> inlineNamespaces = namespace.getInlineNamespaces();
        if (lookInsideUsings && inlineNamespaces != null && (!detector.myNamespaceProcessed || memberName == null)) {
            for (OCNamespaceSymbol inlineNamespace : inlineNamespaces) {
                OCStructType.processMembersOfNamespace(inlineNamespace, memberName, true, typesOnly, processor2, context);
            }
        }
        if (!(!lookInsideUsings || namespace.getNamespaceUsings() == null && inlineNamespaces == null || detector.myNamespaceProcessed && memberName != null)) {
            while (!workset.isEmpty()) {
                Pair pair = (Pair)workset.pop();
                Collection<OCUsingSymbol> namespaceUsings = ((OCNamespaceLikeSymbol)pair.getFirst()).getNamespaceUsings();
                if (namespaceUsings == null) continue;
                for (OCUsingSymbol using : namespaceUsings) {
                    OCNamespaceLikeSymbol container;
                    PsiFile file2 = context.getFile();
                    int index = Integer.MAX_VALUE;
                    OCNamespaceLikeSymbol oCNamespaceLikeSymbol = container = file2 instanceof OCFile ? ((OCFile)file2).getMembersContainer(false) : null;
                    if (container instanceof OCNamespaceLikeSymbol.UsingNamespaceProvider && ((index = ((OCNamespaceLikeSymbol.UsingNamespaceProvider)container).getUsingNamespaceIndex(using)) >= context.getCurrentUsingIndex() || context.isOriginallyProcessNonImported() && index == -1)) continue;
                    InnerProcessor resolver = new InnerProcessor(memberName, typesOnly, true, null, OCTypeSubstitution.ID, processed, workset, processor2, (Condition<OCSymbol>)Conditions.alwaysTrue(), context);
                    context.startResolvingNamespaceUsing(index);
                    List<OCSymbol> list = context.resolveToSymbols(using.getSymbolReference(), false, typesOnly);
                    if (list.isEmpty() && context.isOriginallyProcessNonImported() && !context.isProcessNonImported()) {
                        context.setProcessNonImported(true);
                        list = context.resolveToSymbols(using.getSymbolReference(), false, typesOnly);
                        context.setProcessNonImported(false);
                    }
                    boolean wasVisibleFromUsing = false;
                    OCSymbolWithQualifiedName lastParent = null;
                    for (OCSymbol symbol : list) {
                        PsiElement contextElement = context.getElement();
                        if (!(contextElement instanceof OCFile) && !OCResolveUtil.isEarlierInCode(symbol, contextElement)) continue;
                        if (symbol instanceof OCSymbolWithQualifiedName) {
                            OCSymbolWithQualifiedName parent = ((OCSymbolWithQualifiedName)symbol).getParent();
                            if (wasVisibleFromUsing && !OCSymbolWithQualifiedName.isSameSymbol(parent, lastParent, context)) break;
                            lastParent = parent;
                            if (OCResolveUtil.isEarlierInCode(symbol, using)) {
                                wasVisibleFromUsing = true;
                            }
                        }
                        if (resolver.process(symbol)) continue;
                        context.stopResolvingNamespaceUsing();
                        return false;
                    }
                    context.stopResolvingNamespaceUsing();
                }
            }
        }
        if (namespace instanceof OCStructSymbol) {
            OCStructSymbol struct = (OCStructSymbol)namespace;
            if (!typesOnly && struct.getKind() == OCSymbolKind.STRUCT) {
                OCStructType ownType;
                OCCppReferenceType constRefToOwnType;
                OCFile file3 = struct.getContainingOCFile();
                if ("operator=".equals(memberName) && struct.processMembers(memberName, (Processor<OCSymbol>)new CommonProcessors.FindFirstProcessor<OCSymbol>(constRefToOwnType = OCCppReferenceType.to((ownType = new OCStructType(struct)).cloneWithConstModifier(struct.getProject())), file3){
                    final /* synthetic */ OCCppReferenceType val$constRefToOwnType;
                    final /* synthetic */ OCFile val$file;
                    {
                        this.val$constRefToOwnType = oCCppReferenceType;
                        this.val$file = oCFile;
                    }

                    protected boolean accept(OCSymbol symbol) {
                        if (!(symbol instanceof OCFunctionSymbol)) {
                            return false;
                        }
                        List<? extends OCType> args = ((OCFunctionSymbol)symbol).getType().getParameterTypes();
                        return args.size() == 1 && args.get(0).equalsAfterResolving(this.val$constRefToOwnType, this.val$file);
                    }
                })) {
                    OCFunctionType functionType = new OCFunctionType(OCCppReferenceType.to(ownType), ContainerUtil.list((Object[])new OCCppReferenceType[]{constRefToOwnType}));
                    int attributes = OCFunctionSymbol.Attributes.create(false, false, false, false, true, false, false, false, false, false, false, false, false);
                    processor2.process((Object)new OCFunctionSymbol(struct.getProject(), struct.getContainingFile(), struct.getComplexOffset(), struct, OCQualifiedName.with(memberName), Collections.<OCTypeParameterSymbol>emptyList(), attributes, Collections.<String>emptyList(), functionType, Collections.<OCDeclaratorSymbol>emptyList(), OCSymbolKind.FUNCTION_DECLARATION, OCVisibility.PUBLIC));
                }
            }
            if (!detector.mySomethingProcessed || memberName == null) {
                OCStructType.processMembersInBaseTypes(struct, memberName, typesOnly, true, (Condition<OCSymbol>)Conditions.alwaysTrue(), processor2, context);
            }
        }
        return true;
    }

    public boolean processMembers(@Nullable String memberName, Processor<OCSymbol> processor2, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/OCStructType", "processMembers"));
        }
        for (OCStructSymbol struct : this.myStruct) {
            if (OCStructType.processMembersOfNamespace(struct, memberName, true, false, processor2, context)) continue;
            return false;
        }
        return true;
    }

    public boolean processMembers(@Nullable String memberName, boolean lookInsideUsings, boolean onlyTypes, Processor<OCSymbol> processor2, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/OCStructType", "processMembers"));
        }
        for (OCStructSymbol struct : this.myStruct) {
            if (OCStructType.processMembersOfNamespace(struct, memberName, lookInsideUsings, onlyTypes, processor2, context)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubstructOf(final OCStructSymbol struct, OCStructSymbol substruct, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/OCStructType", "isSubstructOf"));
        }
        return Comparing.equal((Object)struct, (Object)substruct) || !substruct.processAllBaseClasses(context, new OCStructSymbol.BaseClassProcessor(){

            @Override
            public boolean process(OCSymbol symbol, OCVisibility visibility) {
                return !symbol.equals(struct);
            }
        }, true);
    }

    @Override
    public boolean isMagicInside(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/OCStructType", "isMagicInside"));
        }
        return this.isMagicInside(context, true);
    }

    @Override
    public boolean isSubclassOfMagic(PsiElement context) {
        if (context == null) {
            context = this.myStruct.get(0).getContainingOCFile();
        }
        return this.isMagicInside(new OCResolveContext(context), false);
    }

    public boolean isMagicInside(@NotNull OCResolveContext context, boolean checkTemplateArgs) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/OCStructType", "isMagicInside"));
        }
        for (OCStructSymbol struct : this.myStruct) {
            if (checkTemplateArgs && OCResolveUtil.hasNonResolvedTemplateParameters(struct)) {
                return true;
            }
            if (struct.getBaseCppClasses(context).isEmpty() && this.myStruct.size() <= 1) {
                return false;
            }
            OCSymbolWithQualifiedName current = struct;
            boolean hasTemplateInParent = false;
            while (current instanceof OCStructSymbol) {
                OCStructSymbol currentStruct = current;
                if (!currentStruct.getTemplateParameters().isEmpty()) {
                    hasTemplateInParent = true;
                    break;
                }
                current = currentStruct.getResolvedOwner();
            }
            if (!hasTemplateInParent && this.myStruct.size() <= 1) {
                return false;
            }
            if (struct.processAllBaseClasses(context, new OCStructSymbol.BaseClassProcessor(){

                @Override
                public boolean process(OCSymbol symbol, OCVisibility visibility) {
                    return !(symbol instanceof OCTypeParameterSymbol);
                }
            }, true)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isScalar() {
        return this.getKind() == OCSymbolKind.ENUM;
    }

    @Override
    public boolean isCppStructType() {
        return this.getKind() == OCSymbolKind.STRUCT && this.getSymbol().getContainingOCFile().isCpp();
    }

    @Override
    public boolean isNumberCompatible(PsiElement context) {
        return super.isNumberCompatible(context) || this.getKind() == OCSymbolKind.ENUM && !this.isEnumClass();
    }

    @Override
    public boolean isIntegerCompatible(PsiElement context, boolean checkCppConvertible) {
        return super.isIntegerCompatible(context, checkCppConvertible) || this.getKind() == OCSymbolKind.ENUM && !this.isEnumClass();
    }

    @Override
    public String getDefaultValue(PsiElement context) {
        if (this.getKind() == OCSymbolKind.ENUM) {
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            this.myStruct.get(0).processFields((Processor<OCDeclaratorSymbol>)finder);
            if (finder.isFound()) {
                return ((OCDeclaratorSymbol)finder.getFoundValue()).getName();
            }
        } else if (this.getKind() == OCSymbolKind.STRUCT) {
            OCStructSymbol symbol = this.getSymbol();
            if (this.isCppStructType()) {
                CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
                OCCommonProcessors.OrderedProcessor orderedProcessor = new OCCommonProcessors.OrderedProcessor(finder, (Condition<T>[])new Condition[]{new Condition<OCFunctionSymbol>(){

                    public boolean value(OCFunctionSymbol symbol) {
                        return symbol.canBeCalledWithoutArguments() && symbol.getVisibility() == OCVisibility.PUBLIC;
                    }
                }, new Condition<OCFunctionSymbol>(){

                    public boolean value(OCFunctionSymbol symbol) {
                        return symbol.getVisibility() == OCVisibility.PUBLIC;
                    }
                }, Conditions.alwaysTrue()});
                symbol.processConstructors(orderedProcessor);
                orderedProcessor.finish();
                OCQualifiedName qualifiedName = symbol.getResolvedQualifiedName();
                qualifiedName = qualifiedName != null ? qualifiedName : symbol.getQualifiedName();
                StringBuilder builder = new StringBuilder(qualifiedName.getNameWithParent());
                builder.append("(");
                if (finder.isFound()) {
                    boolean isFirst = true;
                    for (OCDeclaratorSymbol parameter : ((OCFunctionSymbol)finder.getFoundValue()).getParameterSymbols()) {
                        OCType type;
                        if (!isFirst) {
                            builder.append(",");
                        }
                        if ((type = parameter.getResolvedType()).isCppStructType()) {
                            String name;
                            if (type instanceof OCCppReferenceType) {
                                type = ((OCCppReferenceType)type).getRefType();
                            }
                            if (type instanceof OCStructType) {
                                qualifiedName = ((OCStructType)type).getSymbol().getResolvedQualifiedName();
                                qualifiedName = qualifiedName != null ? qualifiedName : symbol.getQualifiedName();
                                name = qualifiedName.getNameWithParent();
                            } else {
                                name = type.getName();
                            }
                            builder.append(name).append("()");
                        } else {
                            builder.append(type.getDefaultValue(context));
                        }
                        isFirst = false;
                    }
                }
                builder.append(")");
                return builder.toString();
            }
        }
        return "result";
    }

    @Override
    @Nullable
    public String getFormatString() {
        return this.getKind() == OCSymbolKind.ENUM ? "%d" : super.getFormatString();
    }

    @Override
    public int getSizeInBytes(final @Nullable PsiFile file2, final @Nullable OCInclusionContext context) {
        final Ref size = new Ref((Object)0);
        this.getSymbol().processFields(new Processor<OCDeclaratorSymbol>(){

            public boolean process(OCDeclaratorSymbol symbol) {
                if (symbol.getKind() == OCSymbolKind.STRUCT_FIELD && !symbol.isStatic()) {
                    size.set((Object)((Integer)size.get() + symbol.getType().resolve(file2).getSizeInBytes(file2, context)));
                }
                return true;
            }
        });
        return (Integer)size.get();
    }

    @Override
    @NotNull
    protected OCType doGetLeastCommonType(OCType type, PsiElement context) {
        if (type == null) {
            OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
            if (oCUnknownType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCStructType", "doGetLeastCommonType"));
            }
            return oCUnknownType;
        }
        if (this.equals((Object)type, context)) {
            OCStructType oCStructType = this;
            if (oCStructType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCStructType", "doGetLeastCommonType"));
            }
            return oCStructType;
        }
        if (type instanceof OCMagicType) {
            OCStructType oCStructType = this;
            if (oCStructType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCStructType", "doGetLeastCommonType"));
            }
            return oCStructType;
        }
        if (this.getKind() == OCSymbolKind.ENUM && type.isPointerCompatible(context)) {
            OCIntType oCIntType = OCIntType.INT;
            if (oCIntType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCStructType", "doGetLeastCommonType"));
            }
            return oCIntType;
        }
        if (this.getKind() == OCSymbolKind.ENUM && type instanceof OCStructType && ((OCStructType)type).getKind() == OCSymbolKind.ENUM) {
            OCIntType oCIntType = OCIntType.INT;
            if (oCIntType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCStructType", "doGetLeastCommonType"));
            }
            return oCIntType;
        }
        OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
        if (oCUnknownType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCStructType", "doGetLeastCommonType"));
        }
        return oCUnknownType;
    }

    @Override
    public boolean isInstanceable() {
        return true;
    }

    @Override
    public boolean isUnresolved(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/OCStructType", "isUnresolved"));
        }
        for (OCTypeArgument argument : this.getSymbol().getTemplateArguments(context)) {
            if (!(argument instanceof OCType) || !((OCType)argument).isUnresolved(context)) continue;
            return true;
        }
        return false;
    }

    private static class InnerProcessor
    implements Processor<OCSymbol> {
        private String myMemberName;
        private final boolean myTypesOnly;
        private final boolean myGoTransitive;
        private final Set<String> myAlreadyProcessed;
        private final OCTypeSubstitution mySubstitution;
        private Set<OCNamespaceLikeSymbol> myProcessed;
        private Stack<Pair<OCNamespaceLikeSymbol, Set<String>>> myWorkset;
        private Processor<OCSymbol> myProcessor;
        private Processor<OCSymbol> myFilteringProcessor;
        private final Condition<OCSymbol> myCondition;
        @NotNull
        private final OCResolveContext myContext;

        public InnerProcessor(String memberName, boolean typesOnly, boolean goTransitive, Set<String> alreadyProcessed, OCTypeSubstitution substitution, Set<OCNamespaceLikeSymbol> processed, Stack<Pair<OCNamespaceLikeSymbol, Set<String>>> workset, Processor<OCSymbol> processor2, Condition<OCSymbol> condition, @NotNull OCResolveContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/OCStructType$InnerProcessor", "<init>"));
            }
            this.myMemberName = memberName;
            this.myTypesOnly = typesOnly;
            this.myGoTransitive = goTransitive;
            this.myAlreadyProcessed = alreadyProcessed;
            this.mySubstitution = substitution;
            this.myProcessed = processed;
            this.myWorkset = workset;
            this.myProcessor = processor2;
            this.myFilteringProcessor = new FilteringProcessor(condition, processor2);
            this.myCondition = condition;
            this.myContext = context;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean process(OCSymbol symbol) {
            if (symbol instanceof OCNamespaceSymbol && !this.myProcessed.contains(symbol)) {
                Ref processed;
                FilteringProcessor filter;
                OCNamespaceSymbol struct;
                this.myProcessed.add((OCNamespaceLikeSymbol)((Object)symbol));
                if (symbol instanceof OCStructSymbol && this.mySubstitution != OCTypeSubstitution.ID) {
                    symbol = new OCStructSymbol((OCStructSymbol)symbol, this.mySubstitution, false, this.myContext);
                }
                if (!(struct = (OCNamespaceSymbol)symbol).processMembers(this.myMemberName, (Processor<OCSymbol>)(filter = new FilteringProcessor(OCSymbolWithQualifiedName.WITHOUT_QUALIFIER, (Processor)new Processor<OCSymbol>(processed = new Ref((Object)false)){
                    final /* synthetic */ Ref val$processed;
                    {
                        this.val$processed = ref;
                    }

                    public boolean process(OCSymbol symbol) {
                        String signature;
                        String string = signature = symbol instanceof OCFunctionSymbol ? ((OCFunctionSymbol)symbol).getSignatureWithoutParamNames() : symbol.getName();
                        if (InnerProcessor.this.myAlreadyProcessed != null && InnerProcessor.this.myAlreadyProcessed.contains(signature)) {
                            return true;
                        }
                        if (InnerProcessor.this.myCondition.value((Object)symbol)) {
                            this.val$processed.set((Object)true);
                            if (InnerProcessor.this.myAlreadyProcessed != null) {
                                InnerProcessor.this.myAlreadyProcessed.add(signature);
                            }
                            if (!InnerProcessor.this.myProcessor.process((Object)symbol)) {
                                return false;
                            }
                        }
                        return true;
                    }
                })))) {
                    return false;
                }
                if (((Boolean)processed.get()).booleanValue() && !this.myGoTransitive) return true;
                this.myWorkset.push((Pair<OCNamespaceLikeSymbol, Set<String>>)new Pair((Object)struct, this.myAlreadyProcessed));
                return true;
            }
            if (symbol instanceof OCDeclaratorSymbol && symbol.getKind().isTypedefOrAlias()) {
                OCType type = symbol.getType();
                if (type instanceof OCMagicType) {
                    if (this.myFilteringProcessor.process((Object)new OCTypeParameterTypeSymbol(null, null, 0L, this.myMemberName, null, Collections.<String>emptyList(), null, false))) return this.myFilteringProcessor.process((Object)new OCDeclaratorSymbol(null, null, 0, null, this.myMemberName, Collections.<String>emptyList(), new OCMagicType(this.myMemberName), OCSymbolKind.TEMPLATE_VALUE_PARAMETER));
                    return false;
                }
                if (type instanceof OCStructType) {
                    if (this.mySubstitution == OCTypeSubstitution.ID) {
                        return ContainerUtil.process(((OCStructType)type).getStructs(), (Processor)this);
                    }
                    for (OCStructSymbol struct : ((OCStructType)type).getStructs()) {
                        if (this.process(new OCStructSymbol(struct, this.mySubstitution, false, this.myContext))) continue;
                        return false;
                    }
                    return true;
                } else {
                    if (!(type instanceof OCReferenceType)) return true;
                    return ContainerUtil.process(this.myContext.substitute(((OCReferenceType)type).getSubstitution()).resolveToSymbols(((OCReferenceType)type).getReference(), true, true), (Processor)this);
                }
            }
            if (symbol instanceof OCTypeParameterSymbol) {
                if (this.myFilteringProcessor.process((Object)new OCTypeParameterTypeSymbol(null, null, 0L, this.myMemberName, null, Collections.<String>emptyList(), null, false))) return this.myFilteringProcessor.process((Object)new OCDeclaratorSymbol(null, null, 0, null, this.myMemberName, Collections.<String>emptyList(), new OCMagicType(this.myMemberName), OCSymbolKind.TEMPLATE_VALUE_PARAMETER));
                return false;
            }
            if (symbol instanceof OCUsingSymbol) {
                return ContainerUtil.process(this.myContext.resolveToSymbols(((OCUsingSymbol)symbol).getSymbolReference(), true, this.myTypesOnly), (Processor)this);
            }
            if (!(symbol instanceof OCNamespaceAliasSymbol)) return true;
            return ContainerUtil.process(this.myContext.resolveToSymbols(((OCNamespaceAliasSymbol)symbol).getNamespaceReference(), true, this.myTypesOnly), (Processor)this);
        }
    }
}

