/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCLocalTypes;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCReferenceTypeBuilder {
    private boolean myConst;
    private boolean myVolatile;
    @NotNull
    private final OCSymbolReference myReference;
    @NotNull
    private List<String> myProtocolNames;
    @NotNull
    private OCTypeSubstitution mySubstitution;
    @Nullable
    private ARCAttribute myARCAttribute;
    private boolean myFunctionParameterType;
    private boolean myIsKindof;

    public OCReferenceTypeBuilder(String name) {
        this(OCQualifiedName.interned(name));
    }

    public OCReferenceTypeBuilder(@NotNull OCQualifiedName name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "<init>"));
        }
        this(name, null, false, false);
    }

    public OCReferenceTypeBuilder(@NotNull OCQualifiedName name, @Nullable OCSymbolWithQualifiedName globalContext, boolean isBaseClause, boolean isInsideTemplateParams) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "<init>"));
        }
        this(OCReferenceTypeBuilder.makeGlobalReference(name, globalContext, isBaseClause, isInsideTemplateParams));
    }

    public OCReferenceTypeBuilder(@NotNull OCQualifiedName name, @Nullable PsiElement localContext) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "<init>"));
        }
        this(OCReferenceTypeBuilder.tryMakeLocalReference(name, localContext));
    }

    public OCReferenceTypeBuilder(@NotNull OCSymbolReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "<init>"));
        }
        this.myConst = false;
        this.myVolatile = false;
        this.myProtocolNames = Collections.emptyList();
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myARCAttribute = null;
        this.myFunctionParameterType = false;
        this.myIsKindof = false;
        this.myReference = reference;
    }

    @NotNull
    private static OCSymbolReference makeGlobalReference(@NotNull OCQualifiedName name, @Nullable OCSymbolWithQualifiedName globalContext, boolean isBaseClause, boolean isInsideTemplateParams) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "makeGlobalReference"));
        }
        if (isBaseClause) {
            OCSymbolReference oCSymbolReference = OCSymbolReference.getBaseClauseReference(name, globalContext);
            if (oCSymbolReference == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "makeGlobalReference"));
            }
            return oCSymbolReference;
        }
        if (isInsideTemplateParams) {
            OCSymbolReference oCSymbolReference = OCSymbolReference.getTemplateParamsReference(name, globalContext);
            if (oCSymbolReference == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "makeGlobalReference"));
            }
            return oCSymbolReference;
        }
        OCSymbolReference oCSymbolReference = OCSymbolReference.getGlobalReference(name, globalContext);
        if (oCSymbolReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "makeGlobalReference"));
        }
        return oCSymbolReference;
    }

    @NotNull
    private static OCSymbolReference tryMakeLocalReference(@NotNull OCQualifiedName name, @Nullable PsiElement localContext) {
        OCFile file2;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "tryMakeLocalReference"));
        }
        Boolean local = false;
        if (localContext != null && ((local = OCLocalTypes.canBeLocalType(file2 = (OCFile)localContext.getContainingFile(), name.getName())) == null || !local.booleanValue() && OCLocalTypes.hasLocalUsingStatement(file2))) {
            OCCallable callable = (OCCallable)PsiTreeUtil.getContextOfType((PsiElement)localContext, (Class[])new Class[]{OCCallable.class});
            local = callable != null && (local == null || PsiTreeUtil.findChildOfType((PsiElement)callable, OCCppUsingStatement.class) != null);
        }
        if (local.booleanValue()) {
            OCSymbolReference oCSymbolReference = OCSymbolReference.getLocalReference(name, localContext);
            if (oCSymbolReference == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "tryMakeLocalReference"));
            }
            return oCSymbolReference;
        }
        OCSymbolWithQualifiedName global = OCSymbolReferenceResolver.getGlobalContextFromLocal(localContext);
        OCSymbolReference oCSymbolReference = OCSymbolReference.getGlobalReference(name, global);
        if (oCSymbolReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "tryMakeLocalReference"));
        }
        return oCSymbolReference;
    }

    @NotNull
    public OCReferenceTypeBuilder setSingleProtocolName(@NotNull String protocolName) {
        if (protocolName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocolName", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "setSingleProtocolName"));
        }
        OCReferenceTypeBuilder oCReferenceTypeBuilder = this.setProtocolNames(Collections.singletonList(protocolName));
        if (oCReferenceTypeBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "setSingleProtocolName"));
        }
        return oCReferenceTypeBuilder;
    }

    @NotNull
    public OCReferenceTypeBuilder setProtocolNames(@NotNull List<String> protocolNames) {
        if (protocolNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocolNames", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "setProtocolNames"));
        }
        this.myProtocolNames = protocolNames;
        OCReferenceTypeBuilder oCReferenceTypeBuilder = this;
        if (oCReferenceTypeBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "setProtocolNames"));
        }
        return oCReferenceTypeBuilder;
    }

    @NotNull
    public OCReferenceTypeBuilder setSubstitution(@NotNull OCTypeSubstitution substitution) {
        if (substitution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitution", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "setSubstitution"));
        }
        this.mySubstitution = substitution;
        OCReferenceTypeBuilder oCReferenceTypeBuilder = this;
        if (oCReferenceTypeBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "setSubstitution"));
        }
        return oCReferenceTypeBuilder;
    }

    @NotNull
    public OCReferenceTypeBuilder setARCAttribute(@Nullable ARCAttribute arcAttribute) {
        this.myARCAttribute = arcAttribute;
        OCReferenceTypeBuilder oCReferenceTypeBuilder = this;
        if (oCReferenceTypeBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "setARCAttribute"));
        }
        return oCReferenceTypeBuilder;
    }

    @NotNull
    public OCReferenceTypeBuilder setProtocolSubstitutionARCFromType(@NotNull OCReferenceType fromType) {
        if (fromType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromType", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "setProtocolSubstitutionARCFromType"));
        }
        this.setProtocolNames(fromType.getProtocolNames());
        this.setSubstitution(fromType.getSubstitution());
        this.setARCAttribute(fromType.getARCAttribute());
        OCReferenceTypeBuilder oCReferenceTypeBuilder = this;
        if (oCReferenceTypeBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "setProtocolSubstitutionARCFromType"));
        }
        return oCReferenceTypeBuilder;
    }

    @NotNull
    public OCReferenceTypeBuilder setConstVolatile(boolean isConst, boolean isVolatile) {
        this.myConst = isConst;
        this.myVolatile = isVolatile;
        OCReferenceTypeBuilder oCReferenceTypeBuilder = this;
        if (oCReferenceTypeBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "setConstVolatile"));
        }
        return oCReferenceTypeBuilder;
    }

    @NotNull
    public OCReferenceTypeBuilder setConstVolatile(@NotNull OCType fromType) {
        if (fromType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromType", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "setConstVolatile"));
        }
        OCReferenceTypeBuilder oCReferenceTypeBuilder = this.setConstVolatile(fromType.isConst(), fromType.isVolatile());
        if (oCReferenceTypeBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "setConstVolatile"));
        }
        return oCReferenceTypeBuilder;
    }

    @NotNull
    public OCReferenceTypeBuilder setFunctionParameterType(boolean functionParameterType) {
        this.myFunctionParameterType = functionParameterType;
        OCReferenceTypeBuilder oCReferenceTypeBuilder = this;
        if (oCReferenceTypeBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "setFunctionParameterType"));
        }
        return oCReferenceTypeBuilder;
    }

    public void setIsKindof(boolean isKindof) {
        this.myIsKindof = isKindof;
    }

    @NotNull
    public OCReferenceType build() {
        OCReferenceType oCReferenceType = new OCReferenceType(this.myConst, this.myVolatile, this.myReference, this.myProtocolNames, this.mySubstitution, this.myARCAttribute, this.myFunctionParameterType, this.myIsKindof);
        if (oCReferenceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCReferenceTypeBuilder", "build"));
        }
        return oCReferenceType;
    }
}

