/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeMapper;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCNumber;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCIntType
extends OCNumericType {
    public static final OCIntType BOOL = new OCIntType(true, OCTypeMapper.CTypeId.SIGNED_CHAR, "signed char", "%d");
    public static final OCIntType BOOLEAN = new OCIntType(false, OCTypeMapper.CTypeId.CHAR, "unsigned char", "%d");
    public static final OCIntType BOOL_NATIVE = new OCIntType(true, OCTypeMapper.CTypeId.BOOL, "bool", "%d");
    public static final OCIntType CHAR = new OCIntType(true, OCTypeMapper.CTypeId.CHAR, "char", "%c");
    public static final OCIntType CHAR_CONST = new OCIntType(true, OCTypeMapper.CTypeId.CHAR, "char", "%c", true, false);
    public static final OCIntType SCHAR = new OCIntType(true, OCTypeMapper.CTypeId.SIGNED_CHAR, "signed char", "%c");
    public static final OCIntType UCHAR = new OCIntType(false, OCTypeMapper.CTypeId.CHAR, "unsigned char", "%c");
    public static final OCIntType WCHAR = new OCIntType(true, OCTypeMapper.CTypeId.WCHAR_T, "wchar_t", "%lc");
    public static final OCIntType WCHAR_CONST = new OCIntType(true, OCTypeMapper.CTypeId.WCHAR_T, "wchar_t", "%lc", true, false);
    public static final OCIntType CHAR16 = new OCIntType(false, OCTypeMapper.CTypeId.CHAR16_T, "char16_t", "%lc");
    public static final OCIntType CHAR16_CONST = new OCIntType(false, OCTypeMapper.CTypeId.CHAR16_T, "char16_t", "%lc", true, false);
    public static final OCIntType CHAR32 = new OCIntType(false, OCTypeMapper.CTypeId.CHAR32_T, "char32_t", "%lc");
    public static final OCIntType CHAR32_CONST = new OCIntType(false, OCTypeMapper.CTypeId.CHAR32_T, "char32_t", "%lc", true, false);
    public static final OCIntType SHORT = new OCIntType(true, OCTypeMapper.CTypeId.SHORT, "short", "%hi");
    public static final OCIntType USHORT = new OCIntType(false, OCTypeMapper.CTypeId.SHORT, "unsigned short", "%hu");
    public static final OCIntType INT = new OCIntType(true, OCTypeMapper.CTypeId.INT, "int", "%i");
    public static final OCIntType UINT = new OCIntType(false, OCTypeMapper.CTypeId.INT, "unsigned int", "%u");
    public static final OCIntType LONG = new OCIntType(true, OCTypeMapper.CTypeId.LONG, "long", "%li");
    public static final OCIntType ULONG = new OCIntType(false, OCTypeMapper.CTypeId.LONG, "unsigned long", "%lu");
    public static final OCIntType LONGLONG = new OCIntType(true, OCTypeMapper.CTypeId.LONG_LONG, "long long int", "%lli");
    public static final OCIntType ULONGLONG = new OCIntType(false, OCTypeMapper.CTypeId.LONG_LONG, "unsigned long long int", "%llu");
    public static final OCIntType INT128 = new OCIntType(true, OCTypeMapper.CTypeId.INT128_T, "__int128_t", "%ji");
    public static final OCIntType UINT128 = new OCIntType(false, OCTypeMapper.CTypeId.INT128_T, "__uint128_t", "%ju");
    private boolean myIsSigned;
    private String myText;
    private String myFormatString;

    public static boolean isBool(OCType type, @Nullable PsiElement context) {
        return BOOL.equalsWithAliasName(type, context) || BOOLEAN.equalsWithAliasName(type, context) || BOOL_NATIVE.equalsWithAliasName(type, context);
    }

    public static OCIntType getAppropriateBool(@Nullable OCElement context) {
        if (context != null && !context.getContainingOCFile().getKind().isObjC()) {
            return BOOL_NATIVE;
        }
        return BOOL;
    }

    @Override
    public int getRank(@NotNull PsiElement element) {
        int byteCount;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/types/OCIntType", "getRank"));
        }
        return (byteCount << 3) + ((byteCount = this.getSizeInBytes(element.getContainingFile(), null)) > 1 && this.isSigned() ? 0 : 1);
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/types/OCIntType", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/types/OCIntType", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/types/OCIntType", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCIntType f = (OCIntType)first;
        OCIntType s = (OCIntType)second;
        if (f.myIsSigned != s.myIsSigned) {
            return false;
        }
        if (!Comparing.equal((String)f.myFormatString, (String)s.myFormatString)) {
            return false;
        }
        if (!Comparing.equal((String)f.myText, (String)s.myText)) {
            return false;
        }
        return f.myTypeId.equals((Object)s.myTypeId);
    }

    public OCIntType() {
    }

    private OCIntType(boolean isSigned, OCTypeMapper.CTypeId w, String text, String formatString) {
        this(isSigned, w, text, formatString, false, false);
    }

    private OCIntType(boolean isSigned, OCTypeMapper.CTypeId w, String text, String formatString, boolean isConst, boolean isVolatile) {
        super(isConst, isVolatile);
        this.myIsSigned = isSigned;
        this.myTypeId = w;
        this.myText = text;
        this.myFormatString = formatString;
    }

    public OCIntType cloneType(boolean isConst, boolean isVolatile) {
        return new OCIntType(this.isSigned(), this.getCTypeId(), this.getText(), this.getFormatString(), isConst, isVolatile);
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitIntType(this);
    }

    @Override
    public boolean isSigned() {
        return this.myIsSigned;
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public boolean isChar() {
        return OCTypeMapper.CTypeId.CHAR.equals((Object)this.myTypeId);
    }

    public String getText() {
        return this.myText;
    }

    @Override
    public boolean isIntegerCompatible(PsiElement context, boolean checkCppConvertible) {
        return true;
    }

    @Override
    @NotNull
    public String getFormatString() {
        String string = this.myFormatString;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCIntType", "getFormatString"));
        }
        return string;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + (this.myIsSigned ? 1 : 0);
    }

    @NotNull
    public static OCIntType literalType(@NotNull String text, @NotNull PsiElement element) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/types/OCIntType", "literalType"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/types/OCIntType", "literalType"));
        }
        if ("TRUE".equals(text = text.toUpperCase(Locale.ROOT)) || "FALSE".equals(text)) {
            OCIntType oCIntType = BOOL;
            if (oCIntType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCIntType", "literalType"));
            }
            return oCIntType;
        }
        OCIntType oCIntType = (OCIntType)OCElementUtil.parseInteger((String)text, (PsiElement)element, null).first;
        if (oCIntType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCIntType", "literalType"));
        }
        return oCIntType;
    }

    public boolean canRepresent(@NotNull OCNumber value, @NotNull PsiElement element) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/lang/types/OCIntType", "canRepresent"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/types/OCIntType", "canRepresent"));
        }
        if (value.isSigned() && value.signum() == -1 && !this.myIsSigned) {
            return false;
        }
        int valueBitLength = value.bitLength();
        int typeBitLength = this.getBits(element, null) - (this.myIsSigned ? 1 : 0);
        return valueBitLength <= typeBitLength;
    }

    @Override
    public String getDefaultValue(PsiElement context) {
        return this.getValue(false);
    }

    public String getValue(Boolean value) {
        if (Comparing.equal((String)this.myAliasName, (String)"BOOL")) {
            return value != false ? "YES" : "NO";
        }
        if (Comparing.equal((String)this.myAliasName, (String)"Boolean") || Comparing.equal((String)this.myAliasName, (String)"bool")) {
            return value != false ? "true" : "false";
        }
        return value != false ? "1" : "0";
    }

    @NotNull
    public OCIntType promoteToSigned() {
        if (this.myIsSigned) {
            OCIntType oCIntType = this;
            if (oCIntType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCIntType", "promoteToSigned"));
            }
            return oCIntType;
        }
        if (this.myTypeId.ordinal() <= OCTypeMapper.CTypeId.INT.ordinal()) {
            OCIntType oCIntType = INT;
            if (oCIntType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCIntType", "promoteToSigned"));
            }
            return oCIntType;
        }
        if (this.equals((Object)ULONG, new OCResolveContext())) {
            OCIntType oCIntType = LONG;
            if (oCIntType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCIntType", "promoteToSigned"));
            }
            return oCIntType;
        }
        OCIntType oCIntType = LONGLONG;
        if (oCIntType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCIntType", "promoteToSigned"));
        }
        return oCIntType;
    }

    static {
        BOOL.attachAliasName("BOOL");
        BOOLEAN.attachAliasName("Boolean");
        BOOL_NATIVE.attachAliasName("bool");
    }
}

