/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionType
extends OCType {
    private OCType myReturnType;
    private List<? extends OCType> myParameterTypes;
    private List<String> myParameterNames;

    public OCFunctionType() {
    }

    public OCFunctionType(@NotNull OCType returnType, @NotNull List<? extends OCType> parameterTypes) {
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "com/jetbrains/cidr/lang/types/OCFunctionType", "<init>"));
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterTypes", "com/jetbrains/cidr/lang/types/OCFunctionType", "<init>"));
        }
        this(returnType, parameterTypes, null, false, false);
    }

    public OCFunctionType(@NotNull OCType returnType, @NotNull List<? extends OCType> parameterTypes, @Nullable List<String> parameterNames) {
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "com/jetbrains/cidr/lang/types/OCFunctionType", "<init>"));
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterTypes", "com/jetbrains/cidr/lang/types/OCFunctionType", "<init>"));
        }
        this(returnType, parameterTypes, parameterNames, false, false);
    }

    public OCFunctionType(@NotNull OCType returnType, @NotNull List<? extends OCType> parameterTypes, @Nullable List<String> parameterNames, boolean isConst, boolean isVolatile) {
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "com/jetbrains/cidr/lang/types/OCFunctionType", "<init>"));
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterTypes", "com/jetbrains/cidr/lang/types/OCFunctionType", "<init>"));
        }
        super(isConst, isVolatile);
        this.myReturnType = returnType;
        this.myParameterTypes = parameterTypes;
        this.myParameterNames = parameterNames;
        assert (this.myParameterNames == null || this.myParameterNames.size() == this.myParameterTypes.size());
    }

    public static OCType convertArrayParameterType(OCType type) {
        if (type instanceof OCArrayType) {
            OCArrayType array = (OCArrayType)type;
            OCPointerType pointer = OCPointerType.to(array.getRefType(), array.getARCAttribute(), array.getClassQualifier(), false, array.isVolatile());
            pointer.setLengthInBrackets(array.getLength());
            type = pointer;
        }
        return type;
    }

    @NotNull
    public OCType getReturnType() {
        OCType oCType = this.myReturnType;
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCFunctionType", "getReturnType"));
        }
        return oCType;
    }

    @NotNull
    public List<? extends OCType> getParameterTypes(boolean includeVoid) {
        List<OCType> list = !includeVoid && this.hasNoParameters() ? Collections.emptyList() : this.myParameterTypes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCFunctionType", "getParameterTypes"));
        }
        return list;
    }

    @NotNull
    public List<? extends OCType> getParameterTypes() {
        List<? extends OCType> list = this.getParameterTypes(false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCFunctionType", "getParameterTypes"));
        }
        return list;
    }

    @Nullable
    public List<String> getParameterNames(boolean includeVoid) {
        return !includeVoid && this.hasNoParameters() ? Collections.emptyList() : this.myParameterNames;
    }

    @Nullable
    public List<String> getParameterNames() {
        return this.getParameterNames(false);
    }

    public boolean isVararg() {
        return this.myParameterTypes.size() > 0 && this.myParameterTypes.get(this.myParameterTypes.size() - 1).getTerminalType() instanceof OCEllipsisType;
    }

    public boolean hasNoParameters() {
        if (this.myParameterTypes.isEmpty()) {
            return true;
        }
        if (this.myParameterTypes.size() == 1) {
            return this.myParameterTypes.get(0) instanceof OCVoidType && (this.myParameterNames == null || "<unnamed>".equals(this.myParameterNames.get(0)));
        }
        return false;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitFunctionType(this);
    }

    @Override
    public int hashCode() {
        int result2 = this.baseHashCode();
        result2 = 31 * result2 + this.myReturnType.hashCode();
        result2 = 31 * result2 + this.myParameterTypes.hashCode();
        return result2;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/types/OCFunctionType", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/types/OCFunctionType", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/types/OCFunctionType", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCFunctionType f = (OCFunctionType)first;
        OCFunctionType s = (OCFunctionType)second;
        if (!Comparing.equal(f.myParameterNames, s.myParameterNames)) {
            return false;
        }
        if (!c.equalIterable(f.myParameterTypes, s.myParameterTypes)) {
            return false;
        }
        return c.equalObjects(f.myReturnType, s.myReturnType);
    }

    @Override
    @NotNull
    protected OCType doGetLeastCommonType(OCType type, PsiElement context) {
        if (type == null) {
            OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
            if (oCUnknownType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCFunctionType", "doGetLeastCommonType"));
            }
            return oCUnknownType;
        }
        if (type instanceof OCMagicType) {
            OCType oCType = type;
            if (oCType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCFunctionType", "doGetLeastCommonType"));
            }
            return oCType;
        }
        if (type.isNumberCompatible(context)) {
            OCType oCType = OCIntType.INT.getLeastCommonType(type, context);
            if (oCType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCFunctionType", "doGetLeastCommonType"));
            }
            return oCType;
        }
        if (type.isPointerCompatible(context)) {
            if (this.equals((Object)type, context)) {
                OCFunctionType oCFunctionType = this;
                if (oCFunctionType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCFunctionType", "doGetLeastCommonType"));
                }
                return oCFunctionType;
            }
            OCPointerType oCPointerType = OCPointerType.to(OCVoidType.instance());
            if (oCPointerType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCFunctionType", "doGetLeastCommonType"));
            }
            return oCPointerType;
        }
        OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
        if (oCUnknownType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCFunctionType", "doGetLeastCommonType"));
        }
        return oCUnknownType;
    }

    @Override
    public boolean isPointerCompatible(PsiElement context, boolean checkCppConvertible) {
        return true;
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isUnresolved(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/OCFunctionType", "isUnresolved"));
        }
        if (this.myReturnType.isUnresolved(context) || this.myReturnType instanceof OCFunctionType || this.myReturnType instanceof OCArrayType) {
            return true;
        }
        for (OCType oCType : this.myParameterTypes) {
            if (!oCType.isUnresolved(context) && !(oCType instanceof OCVoidType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getFormatString() {
        return "%p";
    }

    @Override
    public int getSizeInBytes(@Nullable PsiFile file2, @Nullable OCInclusionContext context) {
        return OCIntType.INT.getSizeInBytes(file2, context);
    }
}

