/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCppReferenceType
extends OCType {
    private OCType myRefType;
    private boolean myRvalueRef;

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/types/OCCppReferenceType", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/types/OCCppReferenceType", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/types/OCCppReferenceType", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCCppReferenceType f = (OCCppReferenceType)first;
        OCCppReferenceType s = (OCCppReferenceType)second;
        if (f.myRvalueRef != s.myRvalueRef) {
            return false;
        }
        return c.equalObjects(f.myRefType, s.myRefType);
    }

    public OCCppReferenceType() {
    }

    public static OCCppReferenceType to(@NotNull OCType ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/jetbrains/cidr/lang/types/OCCppReferenceType", "to"));
        }
        return OCCppReferenceType.to(ref, false, false, false);
    }

    public static OCCppReferenceType rvalue(@NotNull OCType ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/jetbrains/cidr/lang/types/OCCppReferenceType", "rvalue"));
        }
        return OCCppReferenceType.to(ref, true, false, false);
    }

    public static OCCppReferenceType to(@NotNull OCType ref, boolean isRvalueRef, boolean isConst, boolean isVolatile) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/jetbrains/cidr/lang/types/OCCppReferenceType", "to"));
        }
        if (ref instanceof OCCppReferenceType) {
            if (isRvalueRef) {
                isConst = ref.isConst();
                isVolatile = ref.isVolatile();
                isRvalueRef = ((OCCppReferenceType)ref).isRvalueRef();
            } else {
                isVolatile = false;
                isConst = false;
                isRvalueRef = false;
            }
            ref = ((OCCppReferenceType)ref).getRefType();
        }
        return new OCCppReferenceType(ref, isRvalueRef, isConst, isVolatile);
    }

    private OCCppReferenceType(OCType ref, boolean isRvalueRef, boolean isConst, boolean isVolatile) {
        super(isConst, isVolatile);
        this.myRefType = ref;
        this.myRvalueRef = isRvalueRef;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitCppReferenceType(this);
    }

    public boolean isReferenceToConst() {
        return this.myRefType.isConst();
    }

    public boolean isRvalueRef() {
        return this.myRvalueRef;
    }

    @NotNull
    public OCType getRefType() {
        OCType oCType = this.myRefType;
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCCppReferenceType", "getRefType"));
        }
        return oCType;
    }

    @NotNull
    public OCType getRefType(PsiElement context) {
        OCType oCType = this.myRefType.isBetterAliasName(this, this.myAliasName, this.myRefType.getAliasName(), context) ? this.myRefType.cloneWithAliasName(this.myAliasName) : this.myRefType;
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCCppReferenceType", "getRefType"));
        }
        return oCType;
    }

    @Override
    @NotNull
    public OCType getTerminalType() {
        OCType oCType = this.myRefType.getTerminalType();
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCCppReferenceType", "getTerminalType"));
        }
        return oCType;
    }

    @Override
    public int pointersDepth() {
        return this.myRefType.pointersDepth();
    }

    @Override
    public boolean isMagicInside(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/OCCppReferenceType", "isMagicInside"));
        }
        return this.myRefType.isMagicInside(context);
    }

    @Override
    public boolean isSubclassOfMagic(PsiElement context) {
        return this.myRefType.isSubclassOfMagic(context);
    }

    @Override
    public boolean isUnknown() {
        return this.myRefType.isUnknown();
    }

    @Override
    public boolean isUnresolved(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/OCCppReferenceType", "isUnresolved"));
        }
        return this.myRefType.isUnresolved(context);
    }

    @Override
    @NotNull
    public OCType getGuessedUnmagicType() {
        OCCppReferenceType oCCppReferenceType = OCCppReferenceType.to(this.myRefType.getGuessedUnmagicType());
        if (oCCppReferenceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCCppReferenceType", "getGuessedUnmagicType"));
        }
        return oCCppReferenceType;
    }

    @Override
    public int hashCode() {
        return this.baseHashCode() * 31 + this.myRefType.hashCode();
    }

    @Override
    public boolean isPointerCompatible(PsiElement context, boolean checkCppConvertible) {
        return true;
    }

    @Override
    @NotNull
    protected OCType doGetLeastCommonType(OCType type, PsiElement context) {
        if (type == null) {
            OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
            if (oCUnknownType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCCppReferenceType", "doGetLeastCommonType"));
            }
            return oCUnknownType;
        }
        if (this.equals((Object)type, context)) {
            OCCppReferenceType oCCppReferenceType = this;
            if (oCCppReferenceType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCCppReferenceType", "doGetLeastCommonType"));
            }
            return oCCppReferenceType;
        }
        if (type instanceof OCMagicType) {
            OCType oCType = type;
            if (oCType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCCppReferenceType", "doGetLeastCommonType"));
            }
            return oCType;
        }
        OCCppReferenceType oCCppReferenceType = OCCppReferenceType.to(this.myRefType.getLeastCommonType(type, context));
        if (oCCppReferenceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCCppReferenceType", "doGetLeastCommonType"));
        }
        return oCCppReferenceType;
    }

    @Override
    public boolean isScalar() {
        return this.myRefType.isScalar();
    }

    @Override
    public boolean isCppStructType() {
        return this.myRefType.isCppStructType();
    }

    @Override
    public boolean isInstanceable() {
        return true;
    }

    @Override
    public boolean isIntegerCompatible(PsiElement context, boolean checkCppConvertible) {
        return this.myRefType.isIntegerCompatible(context, checkCppConvertible);
    }

    @Override
    public boolean isPointerToObject() {
        return this.myRefType.isPointerToObject();
    }

    @Override
    public boolean isPointerToCppStructType() {
        return this.myRefType.isPointerToCppStructType();
    }

    @Override
    public boolean isPointerToID() {
        return this.myRefType.isPointerToID();
    }

    @Override
    public boolean isPointerToChar() {
        return this.myRefType.isPointerToChar();
    }

    @Override
    public boolean isCString() {
        return this.myRefType.isCString();
    }

    @Override
    public boolean isPointerToObjectCompatible() {
        return this.myRefType.isPointerToObject() || this.myRefType.isClassType() || this.myRefType instanceof OCBlockPointerType;
    }

    @Override
    public boolean isPointerToPointerToObjectCompatible() {
        return this.myRefType.isPointerToObjectCompatible() || this.myRefType instanceof OCPointerType && ((OCPointerType)this.myRefType).getRefType().isPointerToPointerToObjectCompatible();
    }

    @Override
    public boolean isPointer() {
        return this.myRefType.isPointer();
    }

    @Override
    public boolean isClassType() {
        return this.myRefType.isClassType();
    }

    @Override
    public String getDefaultValue(PsiElement context) {
        return "<#initializer#>";
    }

    @Override
    public int getSizeInBytes(@Nullable PsiFile file2, @Nullable OCInclusionContext context) {
        return this.myRefType.getSizeInBytes(file2, context);
    }

    @Override
    public String getFormatString() {
        return this.myRefType.getFormatString();
    }
}

