/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.toolchains;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CidrCompilerSwitches {
    @NotNull
    private final List<String> myCommandLineArgs;
    @NotNull
    private final List<String> myFileArgs;

    CidrCompilerSwitches(@NotNull List<String> commandLineArgs, @NotNull List<String> fileArgs) {
        if (commandLineArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLineArgs", "com/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches", "<init>"));
        }
        if (fileArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileArgs", "com/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches", "<init>"));
        }
        this.myCommandLineArgs = Collections.unmodifiableList(commandLineArgs);
        this.myFileArgs = Collections.unmodifiableList(fileArgs);
    }

    @NotNull
    public List<String> getCommandLineArgs() {
        List<String> list = this.myCommandLineArgs;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches", "getCommandLineArgs"));
        }
        return list;
    }

    @NotNull
    public List<String> getFileArgs() {
        List<String> list = this.myFileArgs;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches", "getFileArgs"));
        }
        return list;
    }

    @NotNull
    public String getCommandLineString() {
        String string = StringUtil.join(this.myCommandLineArgs, (String)" ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches", "getCommandLineString"));
        }
        return string;
    }

    public String toString() {
        return this.getCommandLineString();
    }
}

