/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.NotNullFunction;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.psi.impl.OCTemplateParameterListImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLocalTypes
extends OCRecursiveVisitor {
    private Set<String> myLocalNames = new HashSet<String>();
    private int myLocalScopeDepth;
    private boolean myHasLocalUsing;
    private static NotNullLazyKey<OCLocalTypes, AnnotationSession> CACHE = NotNullLazyKey.create((String)"LOCAL_TYPES_DURING_ANNOTATION", (NotNullFunction)new NotNullFunction<AnnotationSession, OCLocalTypes>(){

        @NotNull
        public OCLocalTypes fun(AnnotationSession dom) {
            PsiFile file2 = dom.getFile();
            OCLocalTypes localTypes = new OCLocalTypes();
            file2.accept((PsiElementVisitor)localTypes);
            OCLocalTypes oCLocalTypes = localTypes;
            if (oCLocalTypes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/symtable/OCLocalTypes$1", "fun"));
            }
            return oCLocalTypes;
        }
    });

    private OCLocalTypes() {
    }

    @Override
    public void visitStructLike(OCStructLike struct) {
        super.visitStructLike(struct);
        if (this.myLocalScopeDepth > 0 && struct.isDeclaration()) {
            this.myLocalNames.add(struct.getKind().getNameLowercase() + " " + struct.getName());
            if (!OCCodeInsightUtil.isInPlainOldC(struct)) {
                this.myLocalNames.add(struct.getName());
            }
        }
    }

    @Override
    public void visitDeclaration(OCDeclaration declaration) {
        super.visitDeclaration(declaration);
        if (this.myLocalScopeDepth > 0 && declaration.isTypedef()) {
            OCDeclarator declarator;
            Iterator<OCDeclarator> iterator = declaration.getDeclarators().iterator();
            OCDeclarator oCDeclarator = declarator = iterator.hasNext() ? iterator.next() : null;
            if (declarator != null) {
                this.myLocalNames.add(declarator.getName());
            }
        }
    }

    private void processCallable(OCCallable callable) {
        ++this.myLocalScopeDepth;
        this.visitElement(callable);
        --this.myLocalScopeDepth;
    }

    @Override
    public void visitUsingStatement(OCCppUsingStatement usingStatement) {
        if (this.myLocalScopeDepth > 0) {
            this.myHasLocalUsing = true;
        }
    }

    @Override
    public void visitMethod(OCMethod method) {
        this.processCallable(method);
    }

    @Override
    public void visitFunctionDefinition(OCFunctionDefinition functionDefinition) {
        this.processCallable(functionDefinition);
    }

    @Override
    public void visitTemplateParameterList(OCTemplateParameterListImpl list) {
        for (OCTypeParameterDeclaration declarator : list.getTypeParameterDeclarations()) {
            this.myLocalNames.add(declarator.getName());
        }
    }

    @Override
    public void visitBlockExpression(OCBlockExpression blockExpression) {
        this.processCallable(blockExpression);
    }

    @Override
    public void visitLambdaExpression(OCLambdaExpression lambdaExpression) {
        this.processCallable(lambdaExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Boolean canBeLocalType(OCFile file2, String typeName) {
        Object object = file2.getAnnotationSessionLock();
        synchronized (object) {
            AnnotationSession annotationSession = file2.getCurrentAnnotationSession();
            if (annotationSession != null) {
                return ((OCLocalTypes)((Object)OCLocalTypes.CACHE.getValue((UserDataHolder)annotationSession))).myLocalNames.contains(typeName);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasLocalUsingStatement(OCFile file2) {
        Object object = file2.getAnnotationSessionLock();
        synchronized (object) {
            AnnotationSession annotationSession = file2.getCurrentAnnotationSession();
            if (annotationSession != null) {
                return ((OCLocalTypes)((Object)OCLocalTypes.CACHE.getValue((UserDataHolder)annotationSession))).myHasLocalUsing;
            }
        }
        return true;
    }
}

