/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.AbstractGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.util.OCMostlySingularMultiUniqueMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGlobalProjectSymbolsCache
extends AbstractGlobalProjectSymbolsCache<OCSymbol, OCSymbols> {
    protected OCGlobalProjectSymbolsCache(Project project) {
        super(OCGlobalProjectSymbolsCache.class, project);
    }

    @Override
    protected OCSymbols buildGlobalSymbols(Project project) {
        OCSymbols answer = new OCSymbols();
        if (FileSymbolTablesCache.areSymbolsLoaded(project)) {
            Stack<VirtualFile> workset = new Stack<VirtualFile>();
            HashSet<VirtualFile> processed = new HashSet<VirtualFile>();
            final FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project);
            workset.addAll((Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<VirtualFile>>(){

                public Collection<VirtualFile> compute() {
                    return cache.getFilesToBuildTablesFor(true, false);
                }
            }));
            while (!workset.isEmpty()) {
                VirtualFile vfile = (VirtualFile)workset.pop();
                if (!processed.add(vfile)) continue;
                for (FileSymbolTable table : cache.allTablesForFile(vfile)) {
                    for (OCSymbol content : table.getContents()) {
                        VirtualFile targetFile;
                        if (content instanceof OCIncludeSymbol && (targetFile = ((OCIncludeSymbol)content).getTargetFile()) != null && !processed.contains(targetFile)) {
                            workset.add(targetFile);
                        }
                        answer.process(content);
                    }
                }
            }
        }
        return answer;
    }

    @NotNull
    public static OCGlobalProjectSymbolsCache getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/symbols/symtable/OCGlobalProjectSymbolsCache", "getInstance"));
        }
        OCGlobalProjectSymbolsCache oCGlobalProjectSymbolsCache = (OCGlobalProjectSymbolsCache)((Object)project.getComponent(OCGlobalProjectSymbolsCache.class));
        if (oCGlobalProjectSymbolsCache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/symtable/OCGlobalProjectSymbolsCache", "getInstance"));
        }
        return oCGlobalProjectSymbolsCache;
    }

    public static OCSymbol findNearestTopLevelSymbol(Project project, @Nullable String name, @Nullable Condition<OCSymbol> condition, @Nullable VirtualFile contextFile) {
        return OCGlobalProjectSymbolsCache.findNearestTopLevelSymbol(OCGlobalProjectSymbolsCache.class, project, name, condition, contextFile);
    }

    public static boolean processTopLevelSymbols(@NotNull Project project, @NotNull Processor<OCSymbol> processor2, @Nullable String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/symbols/symtable/OCGlobalProjectSymbolsCache", "processTopLevelSymbols"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/symbols/symtable/OCGlobalProjectSymbolsCache", "processTopLevelSymbols"));
        }
        return OCGlobalProjectSymbolsCache.processTopLevelSymbols(OCGlobalProjectSymbolsCache.class, project, processor2, name);
    }

    public static boolean processTopLevelAndMemberSymbols(@NotNull Project project, @NotNull Processor<OCSymbol> processor2, @Nullable String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/symbols/symtable/OCGlobalProjectSymbolsCache", "processTopLevelAndMemberSymbols"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/symbols/symtable/OCGlobalProjectSymbolsCache", "processTopLevelAndMemberSymbols"));
        }
        return OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(OCGlobalProjectSymbolsCache.class, project, processor2, name);
    }

    public static boolean processByQualifiedName(@NotNull Project project, @NotNull Processor<OCSymbol> processor2, @NotNull String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/symbols/symtable/OCGlobalProjectSymbolsCache", "processByQualifiedName"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/symbols/symtable/OCGlobalProjectSymbolsCache", "processByQualifiedName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/symbols/symtable/OCGlobalProjectSymbolsCache", "processByQualifiedName"));
        }
        return OCGlobalProjectSymbolsCache.processByQualifiedName(OCGlobalProjectSymbolsCache.class, project, processor2, name);
    }

    public static boolean processAliasNamesForType(@NotNull Project project, @NotNull String name, @NotNull Processor<String> processor2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/symbols/symtable/OCGlobalProjectSymbolsCache", "processAliasNamesForType"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/symbols/symtable/OCGlobalProjectSymbolsCache", "processAliasNamesForType"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/symbols/symtable/OCGlobalProjectSymbolsCache", "processAliasNamesForType"));
        }
        return OCGlobalProjectSymbolsCache.processAliasNamesForType(OCGlobalProjectSymbolsCache.class, project, name, processor2);
    }

    public static boolean processTopLevelAndMemberSymbols(@NotNull Project project, @NotNull Processor<OCSymbol> processor2, @Nullable String name, boolean topLevelOnly) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/symbols/symtable/OCGlobalProjectSymbolsCache", "processTopLevelAndMemberSymbols"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/symbols/symtable/OCGlobalProjectSymbolsCache", "processTopLevelAndMemberSymbols"));
        }
        return OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(OCGlobalProjectSymbolsCache.class, project, processor2, name, topLevelOnly);
    }

    public static Set<String> getAllSymbolNames(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/symbols/symtable/OCGlobalProjectSymbolsCache", "getAllSymbolNames"));
        }
        return OCGlobalProjectSymbolsCache.getAllSymbolNames(OCGlobalProjectSymbolsCache.class, project);
    }

    public static boolean processSymbolsByCategory(@NotNull Project project, @NotNull Processor<OCSymbol> processor2, String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/symbols/symtable/OCGlobalProjectSymbolsCache", "processSymbolsByCategory"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/symbols/symtable/OCGlobalProjectSymbolsCache", "processSymbolsByCategory"));
        }
        FileSymbolTablesCache.getInstance(project).ensurePendingFilesProcessed();
        return ((OCSymbols)OCGlobalProjectSymbolsCache.getInstance(project).getGlobalSymbols()).processSymbolsByCategory(processor2, name);
    }

    public static OCMostlySingularMultiUniqueMap<String, OCClassSymbol> getAllCategories(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/symbols/symtable/OCGlobalProjectSymbolsCache", "getAllCategories"));
        }
        return ((OCSymbols)OCGlobalProjectSymbolsCache.getInstance(project).getGlobalSymbols()).getAllNamesWithCategories();
    }

    protected static class OCSymbols
    implements AbstractGlobalProjectSymbolsCache.Symbols<OCSymbol> {
        private final OCMostlySingularMultiUniqueMap<String, OCClassSymbol> myCategoryToClass;
        private final OCMostlySingularMultiUniqueMap<String, OCSymbol> myTopLevelSymbols;
        private final OCMostlySingularMultiUniqueMap<String, OCSymbol> myMemberSymbols;
        private final OCMostlySingularMultiUniqueMap<String, OCSymbol> myCppMemberSymbols;
        private final OCMostlySingularMultiUniqueMap<String, String> myTypeAliases;

        private OCSymbols() {
            TObjectHashingStrategy<OCSymbol> strategy = new TObjectHashingStrategy<OCSymbol>(){

                public int computeHashCode(OCSymbol object) {
                    return System.identityHashCode(object);
                }

                public boolean equals(OCSymbol o1, OCSymbol o2) {
                    return o1 == o2;
                }
            };
            this.myCategoryToClass = new OCMostlySingularMultiUniqueMap(strategy);
            this.myTopLevelSymbols = new OCMostlySingularMultiUniqueMap(strategy);
            this.myMemberSymbols = new OCMostlySingularMultiUniqueMap(strategy);
            this.myCppMemberSymbols = new OCMostlySingularMultiUniqueMap(strategy);
            this.myTypeAliases = new OCMostlySingularMultiUniqueMap();
        }

        public boolean process(OCSymbol symbol) {
            ProgressManager.checkCanceled();
            if (symbol instanceof OCIncludeSymbol) {
                return true;
            }
            String name = symbol.getName();
            if (OCSymbolWithQualifiedName.WITHOUT_QUALIFIER.value((Object)symbol)) {
                this.myTopLevelSymbols.add(name, symbol);
            } else {
                this.myCppMemberSymbols.add(name, symbol);
            }
            if (symbol instanceof OCClassSymbol) {
                OCClassSymbol classSymbol = (OCClassSymbol)symbol;
                if (classSymbol.getCategoryName() != null) {
                    this.myCategoryToClass.add(classSymbol.getCategoryName(), classSymbol);
                }
                classSymbol.processMembers(OCMemberSymbol.class, new Processor<OCMemberSymbol>(){

                    public boolean process(OCMemberSymbol ocMemberSymbol) {
                        ProgressManager.checkCanceled();
                        OCSymbols.this.myMemberSymbols.add(ocMemberSymbol.getName(), ocMemberSymbol);
                        return true;
                    }
                });
            } else if (symbol instanceof OCNamespaceSymbol) {
                OCNamespaceSymbol namespaceSymbol = (OCNamespaceSymbol)symbol;
                namespaceSymbol.processMembers((String)null, new Processor<OCSymbol>(){

                    public boolean process(OCSymbol ocSymbol) {
                        ProgressManager.checkCanceled();
                        OCSymbols.this.myCppMemberSymbols.add(ocSymbol.getName(), ocSymbol);
                        if (ocSymbol instanceof OCNamespaceSymbol) {
                            ((OCNamespaceSymbol)ocSymbol).processMembers((String)null, this);
                        }
                        return true;
                    }
                });
            } else if (symbol.getKind().isTypedefOrAlias()) {
                String refName = symbol.getType().getName();
                this.myTypeAliases.add(refName, symbol.getName());
            }
            return true;
        }

        @Override
        public boolean processAliasNamesForType(@NotNull String name, @NotNull Processor<String> processor2) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/symbols/symtable/OCGlobalProjectSymbolsCache$OCSymbols", "processAliasNamesForType"));
            }
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/symbols/symtable/OCGlobalProjectSymbolsCache$OCSymbols", "processAliasNamesForType"));
            }
            return this.myTypeAliases.processForKey(name, processor2);
        }

        @Override
        public boolean processTopLevel(Processor<? super OCSymbol> processor2, String name) {
            return OCResolveUtil.processMap(processor2, name, this.myTopLevelSymbols);
        }

        @Override
        public boolean processAllSymbols(Processor<? super OCSymbol> processor2, String name) {
            return OCResolveUtil.processMap(processor2, name, this.myTopLevelSymbols) && OCResolveUtil.processMap(processor2, name, this.myMemberSymbols) && OCResolveUtil.processMap(processor2, name, this.myCppMemberSymbols);
        }

        @Override
        public boolean isEmpty() {
            return this.myMemberSymbols.isEmpty();
        }

        public boolean processSymbolsByCategory(Processor<OCSymbol> processor2, String name) {
            return OCResolveUtil.processMap(processor2, name, this.myCategoryToClass);
        }

        public OCMostlySingularMultiUniqueMap<String, OCClassSymbol> getAllNamesWithCategories() {
            return this.myCategoryToClass;
        }
    }
}

