/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceElementImpl;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceExpressionImpl;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.expression.OCCallExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCReferenceExpressionSymbol
extends OCExpressionSymbol {
    private OCSymbolReference myReference;
    private OCExpressionSymbol myParent;

    public OCReferenceExpressionSymbol() {
    }

    public OCReferenceExpressionSymbol(@Nullable Project project, @Nullable VirtualFile file2, long offset, @Nullable String name, OCSymbolReference reference) {
        super(project, file2, offset, name);
        this.myReference = reference;
    }

    public void setParent(OCExpressionSymbol parent) {
        this.myParent = parent;
    }

    public OCSymbolReference getReference() {
        return this.myReference;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/symbols/expression/OCReferenceExpressionSymbol", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/symbols/expression/OCReferenceExpressionSymbol", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/symbols/expression/OCReferenceExpressionSymbol", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCReferenceExpressionSymbol firstSymbol = (OCReferenceExpressionSymbol)first;
        OCReferenceExpressionSymbol secondSymbol = (OCReferenceExpressionSymbol)second;
        if (!c.equalObjects(firstSymbol.myReference, secondSymbol.myReference)) {
            return false;
        }
        return c.equalObjects(firstSymbol.myParent, secondSymbol.myParent);
    }

    @Nullable
    public OCSymbol resolveToSymbol(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/expression/OCReferenceExpressionSymbol", "resolveToSymbol"));
        }
        List<OCSymbol> symbols = context.resolveToSymbols(this.myReference);
        PsiFile file2 = context.getFile();
        if (this.myParent instanceof OCCallExpressionSymbol && file2 != null && ((OCFile)file2).isCpp()) {
            return ((OCCallExpressionSymbol)this.myParent).resolveOverloads(symbols, context);
        }
        return OCReferenceElementImpl.findPredeclaration(symbols);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/jetbrains/cidr/lang/symbols/expression/OCReferenceExpressionSymbol", "evaluate"));
        }
        return evaluator.evalReference(this);
    }

    @Override
    @Nullable
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/expression/OCReferenceExpressionSymbol", "getResolvedType"));
        }
        OCSymbol symbol = this.resolveToSymbol(context);
        return symbol != null ? OCReferenceExpressionImpl.getReferenceExpressionType(symbol).resolve(context) : null;
    }
}

