/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.psi.impl.OCLiteralExpressionImpl;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLiteralExpressionSymbol
extends OCExpressionSymbol {
    @NotNull
    private Object myValue;
    private IElementType myTokenType;
    private String myText;

    public OCLiteralExpressionSymbol() {
    }

    /*
     * WARNING - void declaration
     */
    public OCLiteralExpressionSymbol(@Nullable Project project, @Nullable VirtualFile file2, long offset, @Nullable String name, @NotNull Object value, IElementType tokenType, String string) {
        void text;
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/lang/symbols/expression/OCLiteralExpressionSymbol", "<init>"));
        }
        super(project, file2, offset, name);
        this.myValue = value;
        this.myTokenType = tokenType;
        this.myText = text;
    }

    @NotNull
    public Object getValue() {
        Object object = this.myValue;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/expression/OCLiteralExpressionSymbol", "getValue"));
        }
        return object;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/symbols/expression/OCLiteralExpressionSymbol", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/symbols/expression/OCLiteralExpressionSymbol", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/symbols/expression/OCLiteralExpressionSymbol", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCLiteralExpressionSymbol firstSymbol = (OCLiteralExpressionSymbol)first;
        OCLiteralExpressionSymbol secondSymbol = (OCLiteralExpressionSymbol)second;
        if (!c.equalObjects(firstSymbol.myValue, secondSymbol.myValue)) {
            return false;
        }
        if (!Comparing.equal((String)firstSymbol.myText, (String)secondSymbol.myText)) {
            return false;
        }
        return firstSymbol.myTokenType == secondSymbol.myTokenType;
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/jetbrains/cidr/lang/symbols/expression/OCLiteralExpressionSymbol", "evaluate"));
        }
        if (this.myValue instanceof Boolean) {
            return evaluator.evalBool((Boolean)this.myValue);
        }
        if (this.myValue instanceof Number) {
            return evaluator.evalInteger((Number)this.myValue);
        }
        return null;
    }

    @Override
    @Nullable
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/expression/OCLiteralExpressionSymbol", "getResolvedType"));
        }
        PsiFile file2 = context.getFile();
        return file2 != null ? OCLiteralExpressionImpl.getLiteralType(this.myTokenType, this.myText, file2) : null;
    }
}

