/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.psi.impl.OCBinaryExpressionImpl;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCBinaryExpressionSymbol
extends OCExpressionSymbol {
    private OCElementType myOperator;
    private OCExpressionSymbol myLeftOperand;
    private OCExpressionSymbol myRightOperand;

    public OCBinaryExpressionSymbol() {
    }

    /*
     * WARNING - void declaration
     */
    public OCBinaryExpressionSymbol(@Nullable Project project, @Nullable VirtualFile file2, long offset, @Nullable String name, @NotNull OCElementType operator, @NotNull OCExpressionSymbol operand, @NotNull OCExpressionSymbol oCExpressionSymbol) {
        void operand1;
        if (operator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operator", "com/jetbrains/cidr/lang/symbols/expression/OCBinaryExpressionSymbol", "<init>"));
        }
        if (operand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/jetbrains/cidr/lang/symbols/expression/OCBinaryExpressionSymbol", "<init>"));
        }
        if (oCExpressionSymbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand1", "com/jetbrains/cidr/lang/symbols/expression/OCBinaryExpressionSymbol", "<init>"));
        }
        super(project, file2, offset, name);
        this.myOperator = operator;
        this.myLeftOperand = operand;
        this.myRightOperand = operand1;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/symbols/expression/OCBinaryExpressionSymbol", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/symbols/expression/OCBinaryExpressionSymbol", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/symbols/expression/OCBinaryExpressionSymbol", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCBinaryExpressionSymbol firstSymbol = (OCBinaryExpressionSymbol)first;
        OCBinaryExpressionSymbol secondSymbol = (OCBinaryExpressionSymbol)second;
        if (firstSymbol.myOperator != secondSymbol.myOperator) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.myLeftOperand, secondSymbol.myLeftOperand)) {
            return false;
        }
        return c.equalObjects(firstSymbol.myRightOperand, secondSymbol.myRightOperand);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/jetbrains/cidr/lang/symbols/expression/OCBinaryExpressionSymbol", "evaluate"));
        }
        return evaluator.evalBinary(this.myOperator, this.myLeftOperand.evaluate(evaluator), this.myRightOperand.evaluate(evaluator));
    }

    @Override
    @Nullable
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/expression/OCBinaryExpressionSymbol", "getResolvedType"));
        }
        OCType leftType = this.myLeftOperand.getResolvedType(context);
        OCType rightType = this.myRightOperand.getResolvedType(context);
        return leftType != null && rightType != null ? OCBinaryExpressionImpl.getBinaryExprType(this.myOperator, leftType, rightType, (PsiElement)context.getFile()) : null;
    }
}

