/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCGenericParameterSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCSymbolWithQualifiedName<T extends PsiElement>
extends OCSymbolImpl<T>
implements OCSymbolWithParent<T, OCSymbolWithQualifiedName<T>> {
    @NotNull
    private OCQualifiedName myQualifiedName;
    @Nullable
    protected OCSymbolWithQualifiedName myParent;
    @Nullable
    protected OCVisibility myVisibility;
    public static final Condition<OCSymbol> WITHOUT_QUALIFIER = new Condition<OCSymbol>(){

        public boolean value(OCSymbol symbol) {
            return !(symbol instanceof OCSymbolWithQualifiedName) || ((OCSymbolWithQualifiedName)symbol).getQualifier() == null;
        }
    };

    public OCSymbolWithQualifiedName() {
    }

    /*
     * WARNING - void declaration
     */
    public OCSymbolWithQualifiedName(@Nullable Project project, @Nullable VirtualFile file2, long offset, @Nullable OCSymbolWithQualifiedName parent, @NotNull OCQualifiedName qualifiedName, @NotNull List<String> attributes, @Nullable OCVisibility oCVisibility) {
        void visibility;
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/jetbrains/cidr/lang/symbols/cpp/OCSymbolWithQualifiedName", "<init>"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/jetbrains/cidr/lang/symbols/cpp/OCSymbolWithQualifiedName", "<init>"));
        }
        super(project, file2, offset, qualifiedName.getName(), attributes);
        this.myParent = parent;
        this.myQualifiedName = qualifiedName;
        this.myVisibility = visibility;
    }

    @Nullable
    public OCQualifiedName getQualifier() {
        return this.myQualifiedName.getQualifier();
    }

    @NotNull
    public OCQualifiedName getQualifiedName() {
        OCQualifiedName oCQualifiedName = this.myQualifiedName;
        if (oCQualifiedName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCSymbolWithQualifiedName", "getQualifiedName"));
        }
        return oCQualifiedName;
    }

    @Override
    @NotNull
    public String getNameWithParent() {
        if (this.myQualifiedName.getQualifier() != null) {
            String string = this.myQualifiedName.getCanonicalName(true);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCSymbolWithQualifiedName", "getNameWithParent"));
            }
            return string;
        }
        if (this.myParent != null) {
            String string = this.myParent.getName() + "::" + this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCSymbolWithQualifiedName", "getNameWithParent"));
            }
            return string;
        }
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCSymbolWithQualifiedName", "getNameWithParent"));
        }
        return string;
    }

    @Nullable
    public OCVisibility getVisibility() {
        return this.myVisibility;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/symbols/cpp/OCSymbolWithQualifiedName", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/symbols/cpp/OCSymbolWithQualifiedName", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/symbols/cpp/OCSymbolWithQualifiedName", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCSymbolWithQualifiedName f = (OCSymbolWithQualifiedName)first;
        OCSymbolWithQualifiedName s = (OCSymbolWithQualifiedName)second;
        if (f.myVisibility != s.myVisibility) {
            return false;
        }
        if (!c.equalObjects(f.myQualifiedName, s.myQualifiedName)) {
            return false;
        }
        return c.equalObjects(f.myParent, s.myParent);
    }

    public boolean resolvedNamesEqual(OCSymbolWithQualifiedName symbol) {
        if (this.equals(symbol)) {
            return true;
        }
        OCQualifiedName qualifiedName = symbol.getQualifiedName();
        if (!Comparing.equal((String)this.myQualifiedName.getName(), (String)qualifiedName.getName())) {
            return false;
        }
        if (this.isPredeclaration() || symbol.isPredeclaration()) {
            return true;
        }
        if (symbol instanceof OCStructSymbol && ((OCStructSymbol)symbol).getTemplateSpecialization() != null || this instanceof OCStructSymbol && ((OCStructSymbol)this).getTemplateSpecialization() != null) {
            return Comparing.equal((Object)this.getResolvedQualifiedNameWithoutInlineNamespaces(), (Object)symbol.getResolvedQualifiedNameWithoutInlineNamespaces());
        }
        return Comparing.equal((Object)this.getResolvedQualifiedName(false), (Object)symbol.getResolvedQualifiedName(false));
    }

    @Nullable
    public OCQualifiedName getResolvedQualifiedNameWithoutInlineNamespaces() {
        return this.getResolvedQualifiedName(true, new OCResolveContext(this.getContainingOCFile()), true, false, true, true, true);
    }

    @Nullable
    public OCQualifiedName getResolvedQualifiedName() {
        return this.getResolvedQualifiedName(new OCResolveContext(this.getContainingOCFile()));
    }

    @Nullable
    public OCQualifiedName getResolvedQualifiedName(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/cpp/OCSymbolWithQualifiedName", "getResolvedQualifiedName"));
        }
        return this.getResolvedQualifiedName(false, context, true, true, true, true, true);
    }

    @Nullable
    public OCQualifiedName getResolvedQualifiedName(boolean appendArguments) {
        return this.getResolvedQualifiedName(false, appendArguments);
    }

    @Nullable
    public OCQualifiedName getResolvedQualifiedName(boolean withoutInlineNamespaces, boolean appendArguments) {
        return this.getResolvedQualifiedName(withoutInlineNamespaces, new OCResolveContext(this.getContainingOCFile()), true, appendArguments, true, true, true);
    }

    @Nullable
    public OCQualifiedName getResolvedQualifiedName(@NotNull OCResolveContext context, boolean appendArguments) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/cpp/OCSymbolWithQualifiedName", "getResolvedQualifiedName"));
        }
        return this.getResolvedQualifiedName(false, context, true, appendArguments, true, true, true);
    }

    @Nullable
    public OCQualifiedName getResolvedQualifiedName(boolean withoutInlineNamespaces, @NotNull OCResolveContext context, boolean processTypesOnly, boolean appendArguments, boolean resolveArguments, boolean removeDefaultArguments, boolean treatNonMemberOperators) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/cpp/OCSymbolWithQualifiedName", "getResolvedQualifiedName"));
        }
        OCQualifiedName result2 = null;
        if (this.myQualifiedName == OCQualifiedName.GLOBAL) {
            result2 = this.myQualifiedName;
        } else {
            OCStructSymbol operatorParent = treatNonMemberOperators ? context.getNonMemberOperatorParent(this) : null;
            OCQualifiedName qualifier = this.myQualifiedName.getQualifier();
            if (qualifier != null && operatorParent == null) {
                OCSymbolReference reference = OCSymbolReference.getGlobalReference(qualifier, this.getParent(), (OCSymbolReference.SymbolFilter)OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE_LIKE);
                List<OCSymbol> possibleSymbols = context.resolveToSymbols(reference, true, processTypesOnly);
                for (OCSymbol possibleSymbol : possibleSymbols) {
                    if (!(possibleSymbol instanceof OCNamespaceSymbol)) continue;
                    OCQualifiedName resolvedQualifier = ((OCNamespaceSymbol)possibleSymbol).getResolvedQualifiedName(withoutInlineNamespaces, context, processTypesOnly, appendArguments, true, removeDefaultArguments, treatNonMemberOperators);
                    result2 = OCQualifiedName.with(resolvedQualifier, this.myName);
                    break;
                }
            } else {
                OCSymbolWithQualifiedName parent;
                OCSymbolWithQualifiedName oCSymbolWithQualifiedName = parent = operatorParent != null ? operatorParent : this.myParent;
                while (withoutInlineNamespaces && parent instanceof OCNamespaceSymbol && ((OCNamespaceSymbol)parent).isInlineNamespace() || parent instanceof OCStructSymbol && parent.isTransparentUnion()) {
                    parent = parent.myParent;
                }
                result2 = parent == null ? OCQualifiedName.with(OCQualifiedName.GLOBAL, this.myQualifiedName.getName()) : OCQualifiedName.with(parent.getResolvedQualifiedName(withoutInlineNamespaces, context, processTypesOnly, appendArguments, true, removeDefaultArguments, treatNonMemberOperators), this.myName);
            }
        }
        if (appendArguments) {
            List<OCTypeArgument> arguments = OCTypeNameVisitor.getTypeArguments(OCType.Presentation.BEST, this, resolveArguments, false, removeDefaultArguments, context);
            if (result2 != null && !arguments.isEmpty()) {
                return new OCQualifiedNameWithArguments(result2, arguments);
            }
        }
        return result2;
    }

    public void setQualifier(OCQualifiedName qualifier) {
        this.myQualifiedName = this.myQualifiedName.changeQualifier(qualifier);
    }

    public boolean isLocalInFile() {
        if ((this instanceof OCDeclaratorSymbol || this instanceof OCFunctionSymbol) && this.isStatic() && this.myFile != null && OCFileImpl.isSourceCodeFile(this.myFile.getName())) {
            OCSymbolKind kind = this.getResolvedKind();
            return kind.isGlobalVariable() || kind.isFunction() && this.myParent == null;
        }
        return false;
    }

    public boolean isConst() {
        return false;
    }

    public boolean isStatic() {
        return false;
    }

    public abstract boolean isTemplateSymbol();

    @NotNull
    public abstract List<OCTypeParameterSymbol> getTemplateParameters();

    public boolean isVariadicTemplate() {
        List<OCTypeParameterSymbol> templateParameters = this.getTemplateParameters();
        if (templateParameters.isEmpty()) {
            return false;
        }
        OCTypeParameterSymbol lastParameter = templateParameters.get(templateParameters.size() - 1);
        return !(lastParameter instanceof OCGenericParameterSymbol) && (lastParameter instanceof OCTypeParameterTypeSymbol ? ((OCTypeParameterTypeSymbol)lastParameter).isVariadic() : ((OCTypeParameterValueSymbol)lastParameter).getType() instanceof OCEllipsisType);
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        return OCIcons.getVisibilityIcon(this.getVisibility(), super.getBaseIcon());
    }

    public static boolean isFriend(OCSymbol symbol) {
        return symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isFriendFunction() || symbol instanceof OCStructSymbol && ((OCStructSymbol)symbol).isFriendClass();
    }

    @Nullable
    public OCSymbolWithQualifiedName getResolvedOwner() {
        return this.getResolvedOwner(new OCResolveContext(this.getContainingOCFile()), true);
    }

    @Nullable
    public OCSymbolWithQualifiedName getResolvedOwner(@NotNull OCResolveContext context, boolean checkNonMemberOperators) {
        OCStructSymbol operatorParent;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/cpp/OCSymbolWithQualifiedName", "getResolvedOwner"));
        }
        if (checkNonMemberOperators && (operatorParent = context.getNonMemberOperatorParent(this)) != null) {
            return operatorParent;
        }
        OCQualifiedName qualifier = this.myQualifiedName.getQualifier();
        if (qualifier != null) {
            OCFile file2 = this.getContainingOCFile();
            OCSymbolReference reference = OCSymbolReference.getGlobalReference(qualifier, this.getParent(), (OCSymbolReference.SymbolFilter)OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE_LIKE);
            List<OCSymbol> possibleSymbols = reference.resolveToSymbols(true, true, true, context);
            for (OCSymbol possibleSymbol : possibleSymbols) {
                OCNamespaceSymbol namespace;
                if (!(possibleSymbol instanceof OCNamespaceSymbol) || (namespace = (OCNamespaceSymbol)possibleSymbol).isPredeclaration()) continue;
                CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
                namespace.processMembers(this.myName, (Processor<OCSymbol>)processor2);
                if (!processor2.isFound()) continue;
                return namespace;
            }
            return null;
        }
        return this.myParent;
    }

    @Override
    @Nullable
    public OCSymbolWithQualifiedName getParent() {
        return this.myParent;
    }

    @Override
    @Nullable
    public OCSymbol getDefinitionSymbol() {
        if (this.isPredeclaration()) {
            CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
            this.processSameSymbols((Processor<OCSymbol>)new FilteringProcessor(OCSymbol.NON_PREDIFINITION_CONDITION, (Processor)processor2));
            return (OCSymbol)processor2.getFoundValue();
        }
        return this;
    }

    @Override
    public String getKindUppercase() {
        return this.getResolvedKind().getNameUppercase();
    }

    public OCSymbolKind getResolvedKind() {
        OCSymbolKind actualKind = this.getKind();
        if (actualKind.isGlobalVariable() && this.getQualifier() != null) {
            OCFile file2 = this.getContainingOCFile();
            OCSymbolReference reference = OCSymbolReference.getGlobalReference(this.getQualifier(), this.getParent(), (OCSymbolReference.SymbolFilter)OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE_LIKE);
            List<OCSymbol> possibleSymbols = reference.resolveToSymbols(true, true, file2);
            for (OCSymbol possibleSymbol : possibleSymbols) {
                if (!possibleSymbol.getKind().isStructLike()) continue;
                actualKind = OCSymbolKind.STRUCT_FIELD;
                break;
            }
        }
        return actualKind;
    }

    @Override
    public boolean processSameSymbols(Processor<OCSymbol> processor2) {
        return this.processSameSymbols(processor2, null);
    }

    public boolean processSameSymbols(final Processor<OCSymbol> processor2, @Nullable PsiFile file2) {
        final Class<?> myClass = this.getClass();
        if (!processor2.process((Object)this)) {
            return false;
        }
        if (!this.isGlobal()) {
            return true;
        }
        Processor<OCSymbol> _processor = new Processor<OCSymbol>(){
            private OCQualifiedName myResolvedName;
            private OCType myResolvedType;

            public boolean process(OCSymbol symbol) {
                if (symbol.equals(OCSymbolWithQualifiedName.this)) {
                    return true;
                }
                if (!symbol.getClass().equals(myClass)) {
                    return true;
                }
                if (!(symbol instanceof OCSymbolWithQualifiedName)) {
                    return true;
                }
                if (this.myResolvedName == null) {
                    this.myResolvedName = OCSymbolWithQualifiedName.this.getResolvedQualifiedName(false);
                    if (this.myResolvedName == null) {
                        return false;
                    }
                }
                if (this.myResolvedType == null) {
                    this.myResolvedType = OCSymbolWithQualifiedName.this.getType().resolve(OCSymbolWithQualifiedName.this.getContainingOCFile());
                }
                if (!OCSymbolWithQualifiedName.this.isSameSymbol((OCSymbolWithQualifiedName)symbol, this.myResolvedName, this.myResolvedType, new OCResolveContext(OCSymbolWithQualifiedName.this.getContainingOCFile()))) {
                    return true;
                }
                return processor2.process((Object)symbol);
            }
        };
        if (file2 != null) {
            OCQualifiedName name = this.getResolvedQualifiedName();
            if (name != null) {
                OCSymbolReference ref = OCSymbolReference.getGlobalReference(name);
                return ref.processPossibleSymbols(new Processor<OCSymbol>(){

                    public boolean process(OCSymbol symbol) {
                        return symbol.equals(OCSymbolWithQualifiedName.this) || processor2.process((Object)symbol);
                    }
                }, file2);
            }
            return true;
        }
        if (this.myProject != null) {
            final VirtualFile containingFile = this.getContainingFile();
            OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = new OCCommonProcessors.OrderedProcessor<OCSymbol>(_processor, new Condition<OCSymbol>(){

                public boolean value(OCSymbol symbol) {
                    return containingFile != null && containingFile.equals(symbol.getContainingFile());
                }
            }, Conditions.alwaysTrue());
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(this.myProject, orderedProcessor, this.myName);
            return orderedProcessor.finish();
        }
        return true;
    }

    @Override
    public boolean processAssociatedSymbols(final Processor<OCSymbol> processor2) {
        OCSymbol definitionSymbol;
        if (this.isPredeclaration() && (definitionSymbol = this.getDefinitionSymbol()) != null && !processor2.process((Object)definitionSymbol)) {
            return false;
        }
        final VirtualFile containingFile = this.getContainingFile();
        OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = new OCCommonProcessors.OrderedProcessor<OCSymbol>(new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                return symbol == OCSymbolWithQualifiedName.this || processor2.process((Object)symbol);
            }
        }, new Condition<OCSymbol>(){

            public boolean value(OCSymbol symbol) {
                VirtualFile curContainingFile = symbol.getContainingFile();
                return containingFile != null && curContainingFile != null && containingFile.getNameWithoutExtension().equals(curContainingFile.getNameWithoutExtension());
            }
        }, Conditions.alwaysTrue());
        this.processPredeclarations(orderedProcessor);
        return orderedProcessor.finish();
    }

    @Override
    public boolean isSameSymbol(@Nullable OCSymbol symbol) {
        return this.isSameSymbol(symbol, new OCResolveContext(this.getContainingOCFile()));
    }

    public boolean isSameSymbol(@Nullable OCSymbol symbol, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/cpp/OCSymbolWithQualifiedName", "isSameSymbol"));
        }
        if (symbol instanceof OCSymbolWithQualifiedName) {
            return this.isSameSymbol((OCSymbolWithQualifiedName)symbol, this.getResolvedQualifiedName(false, context, true, false, true, true, true), this.getType().resolve(context), context);
        }
        return false;
    }

    public static boolean isSameSymbol(@Nullable OCSymbolWithQualifiedName symbol1, @Nullable OCSymbolWithQualifiedName symbol2, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/cpp/OCSymbolWithQualifiedName", "isSameSymbol"));
        }
        return symbol1 == null && symbol2 == null || symbol1 != null && symbol2 != null && symbol1.isSameSymbol(symbol2, context);
    }

    private boolean isSameSymbol(OCSymbolWithQualifiedName symbol, @Nullable OCQualifiedName resolvedName, OCType resolvedType, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/cpp/OCSymbolWithQualifiedName", "isSameSymbol"));
        }
        if (this.isLocalInFile() && symbol.isLocalInFile() && !Comparing.equal((Object)this.getContainingFile(), (Object)symbol.getContainingFile())) {
            return false;
        }
        if (resolvedName == null) {
            return false;
        }
        if (OCSymbolWithQualifiedName.isFriend(this) || OCSymbolWithQualifiedName.isFriend(symbol) ? !this.getName().equals(symbol.getName()) : !resolvedName.equals(symbol.getResolvedQualifiedName(false, new OCResolveContext(symbol.getContainingOCFile()), true, false, true, true, true))) {
            return false;
        }
        if (symbol instanceof OCFunctionSymbol) {
            if (((OCFunctionSymbol)symbol).isFriendFunction() && symbol.isPredeclaration() && ((OCFunctionSymbol)symbol).isCppOperator()) {
                return false;
            }
            if (!(this instanceof OCFunctionSymbol)) {
                return false;
            }
            if (((OCFunctionSymbol)symbol).getParameterSymbols().size() != ((OCFunctionSymbol)this).getParameterSymbols().size()) {
                return ((OCFunctionSymbol)symbol).getType().hasNoParameters() && ((OCFunctionSymbol)this).getType().hasNoParameters();
            }
            OCType symbolType = symbol.getResolvedType();
            OCTypeEqualityAfterResolvingVisitor typeEqualityVisitor = new OCTypeEqualityAfterResolvingVisitor(symbolType, true, context);
            if (resolvedType instanceof OCFunctionType && symbolType instanceof OCFunctionType) {
                return typeEqualityVisitor.isFunctionSignatureEqual(resolvedType);
            }
            return resolvedType.accept(typeEqualityVisitor);
        }
        return true;
    }

    @Override
    @Nullable
    public String getLocationString() {
        OCQualifiedName qualifier;
        OCQualifiedName name;
        if (this.isGlobal() && (name = this.getResolvedQualifiedName(false, new OCResolveContext(this.getContainingOCFile()), true, false, true, true, false)) != null && (qualifier = name.getQualifier()) != null) {
            String result2;
            if (qualifier.getSuperQualifier() == OCQualifiedName.GLOBAL.getName()) {
                qualifier = qualifier.dropSuperQualifier();
            }
            if (!(result2 = qualifier.getCanonicalName(true)).isEmpty()) {
                return result2;
            }
        }
        return this.myFile == null ? null : this.myFile.getName();
    }

    @Override
    public OCSymbol getAssociatedSymbol() {
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        this.processAssociatedSymbols((Processor<OCSymbol>)finder);
        return (OCSymbol)finder.getFoundValue();
    }
}

