/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.visitors.OCTypeResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStructSymbol
extends OCNamespaceSymbol
implements OCSymbolWithSubstitution {
    private OCSymbolKind mySymbolKind;
    @NotNull
    private Collection<Pair<OCType, OCVisibility>> myBaseCppClasses;
    @NotNull
    private List<OCTypeParameterSymbol> myTemplateParameters;
    @Nullable
    private List<OCTypeArgument> myTemplateSpecialization;
    @NotNull
    private OCTypeSubstitution mySubstitution;
    @Nullable
    private TextRange myScope;
    private int myClassAttributes;

    public OCStructSymbol() {
        this.mySubstitution = OCTypeSubstitution.ID;
    }

    /*
     * WARNING - void declaration
     */
    public OCStructSymbol(Project project, VirtualFile file2, long offset, @Nullable OCSymbolWithQualifiedName parent, @NotNull OCQualifiedName name, @NotNull List<String> attributes, @NotNull OCSymbolKind kind, @NotNull List<Pair<OCType, OCVisibility>> baseClasses, @NotNull List<OCTypeParameterSymbol> templateParameters, @Nullable List<OCTypeArgument> templateSpecialization, @Nullable List<OCSymbol> membersList, @Nullable MostlySingularMultiMap<String, OCSymbol> members, @Nullable TextRange scope, @Nullable OCVisibility visibility, boolean isFriend, boolean isEnumClass, boolean bl) {
        void isFinal;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "<init>"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "<init>"));
        }
        if (baseClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClasses", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "<init>"));
        }
        if (templateParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateParameters", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "<init>"));
        }
        this(project, file2, offset, parent, name, attributes, kind, baseClasses, templateParameters, templateSpecialization, membersList, members, scope, visibility);
        if (isFriend) {
            this.myClassAttributes |= 1;
        }
        if (isEnumClass) {
            this.myClassAttributes |= 2;
        }
        if (isFinal != false) {
            this.myClassAttributes |= 4;
        }
    }

    /*
     * WARNING - void declaration
     */
    public OCStructSymbol(Project project, VirtualFile file2, long offset, @Nullable OCSymbolWithQualifiedName parent, @NotNull OCQualifiedName name, @NotNull List<String> attributes, @NotNull OCSymbolKind kind, @NotNull List<Pair<OCType, OCVisibility>> baseClasses, @NotNull List<OCTypeParameterSymbol> templateParameters, @Nullable List<OCTypeArgument> templateSpecialization, @Nullable List<OCSymbol> membersList, @Nullable MostlySingularMultiMap<String, OCSymbol> members, TextRange scope, @Nullable OCVisibility oCVisibility) {
        void visibility;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "<init>"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "<init>"));
        }
        if (baseClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClasses", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "<init>"));
        }
        if (templateParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateParameters", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "<init>"));
        }
        super(project, file2, offset, parent, name, attributes, membersList, members, null, false, (OCVisibility)visibility);
        this.mySubstitution = OCTypeSubstitution.ID;
        assert (kind == OCSymbolKind.STRUCT || kind == OCSymbolKind.UNION || kind == OCSymbolKind.ENUM);
        this.mySymbolKind = kind;
        this.myBaseCppClasses = baseClasses;
        this.myTemplateParameters = templateParameters;
        this.myTemplateSpecialization = templateSpecialization;
        this.myScope = scope;
    }

    public OCStructSymbol(OCStructSymbol origin, OCTypeSubstitution substitution, boolean overwriteSubstitution, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "<init>"));
        }
        this(origin, substitution, origin.getParent(), overwriteSubstitution, context);
    }

    public OCStructSymbol(OCStructSymbol origin, OCTypeSubstitution substitution, OCSymbolWithQualifiedName parent, boolean overwriteSubstitution, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "<init>"));
        }
        super(origin.myProject, origin.myFile, origin.myComplexOffset, parent, origin.getQualifiedName(), origin.getAttributes(), origin.getMembersList(), origin.getMembers(), null, false, origin.myVisibility);
        this.mySubstitution = OCTypeSubstitution.ID;
        this.mySymbolKind = origin.getKind();
        this.myBaseCppClasses = origin.myBaseCppClasses;
        this.myTemplateParameters = origin.myTemplateParameters;
        this.myTemplateSpecialization = origin.myTemplateSpecialization;
        this.mySubstitution = OCTypeSubstitution.compose(origin.mySubstitution, substitution, overwriteSubstitution, context);
        this.myScope = origin.getScope();
        this.myClassAttributes = origin.myClassAttributes;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCStructSymbol f = (OCStructSymbol)first;
        OCStructSymbol s = (OCStructSymbol)second;
        if (f.myClassAttributes != s.myClassAttributes) {
            return false;
        }
        if (!Comparing.equal((Object)f.myScope, (Object)s.myScope)) {
            return false;
        }
        if (!Comparing.equal((Object)((Object)f.mySymbolKind), (Object)((Object)s.mySymbolKind))) {
            return false;
        }
        if (!c.equalIterable(f.myBaseCppClasses, s.myBaseCppClasses)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        if (!c.equalIterable(f.myTemplateParameters, s.myTemplateParameters)) {
            return false;
        }
        return c.equalIterable(f.myTemplateSpecialization, s.myTemplateSpecialization);
    }

    @Override
    public void updateOffset(int start, int end, int lengthShift) {
        super.updateOffset(start, end, lengthShift);
        for (OCTypeParameterSymbol parameter : this.myTemplateParameters) {
            ((OCSymbol)((Object)parameter)).updateOffset(start, end, lengthShift);
        }
    }

    @Override
    public void compact() {
        super.compact();
        for (OCTypeParameterSymbol parameter : this.myTemplateParameters) {
            ((OCSymbol)((Object)parameter)).compact();
        }
    }

    public boolean isFriendClass() {
        return (this.myClassAttributes & 1) != 0;
    }

    public boolean isFinal() {
        return (this.myClassAttributes & 4) != 0;
    }

    public boolean isEnumClass() {
        return (this.myClassAttributes & 2) != 0;
    }

    public boolean isEnum() {
        return this.getKind() == OCSymbolKind.ENUM;
    }

    @Override
    public boolean isTemplateSymbol() {
        return this.myTemplateParameters.size() != 0 || this.myTemplateSpecialization != null;
    }

    public boolean isInnerClass() {
        for (OCSymbolWithQualifiedName parent = this.myParent; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof OCStructSymbol)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<OCTypeParameterSymbol> getTemplateParameters() {
        List<OCTypeParameterSymbol> list = this.myTemplateParameters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "getTemplateParameters"));
        }
        return list;
    }

    @Nullable
    public List<OCTypeArgument> getTemplateSpecialization() {
        return this.myTemplateSpecialization;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        OCTypeSubstitution oCTypeSubstitution = this.mySubstitution;
        if (oCTypeSubstitution == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "getSubstitution"));
        }
        return oCTypeSubstitution;
    }

    @Override
    public boolean isGlobal() {
        return this.myScope == null;
    }

    @Override
    public boolean isPredeclaration() {
        return this.getMembers() == null;
    }

    @Override
    public String getKindUppercase() {
        OCFile file2 = this.getContainingOCFile();
        OCSymbolKind kind = this.getKind();
        if (kind == OCSymbolKind.STRUCT && file2 != null && file2.isCpp()) {
            return "Class";
        }
        return super.getKindUppercase();
    }

    @Override
    public boolean processMembers(@Nullable String memberName, final @NotNull Processor<OCSymbol> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "processMembers"));
        }
        Processor<OCSymbol> inner = this.mySubstitution != OCTypeSubstitution.ID ? new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                return processor2.process((Object)OCStructSymbol.this.mySubstitution.substitute(symbol, OCStructSymbol.this, false, new OCResolveContext()));
            }
        } : processor2;
        return super.processMembers(memberName, inner);
    }

    public boolean processConversionOperators(final @NotNull Processor<OCFunctionSymbol> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "processConversionOperators"));
        }
        return this.processMembers((String)null, new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConversionOperator()) {
                    return processor2.process((Object)((OCFunctionSymbol)symbol));
                }
                return true;
            }
        });
    }

    public boolean processOperators(final @NotNull Processor<OCFunctionSymbol> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "processOperators"));
        }
        return this.processMembers((String)null, new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppOperator()) {
                    return processor2.process((Object)((OCFunctionSymbol)symbol));
                }
                return true;
            }
        });
    }

    public boolean processFields(@NotNull Processor<OCDeclaratorSymbol> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "processFields"));
        }
        return this.processMembers((String)null, new OCCommonProcessors.TypeFilteredProcessor(processor2, OCDeclaratorSymbol.class));
    }

    public boolean processFunctions(@Nullable String name, @NotNull Processor<OCFunctionSymbol> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "processFunctions"));
        }
        return this.processMembers(name, new OCCommonProcessors.TypeFilteredProcessor(processor2, OCFunctionSymbol.class));
    }

    @Nullable
    public OCDeclaratorSymbol findField(String name) {
        MostlySingularMultiMap<String, OCSymbol> members = this.getMembers();
        if (members == null) {
            return null;
        }
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol instanceof OCDeclaratorSymbol;
            }
        };
        members.processForKey((Object)name, (Processor)finder);
        return (OCDeclaratorSymbol)finder.getFoundValue();
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = this.mySymbolKind;
        if (oCSymbolKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "getKind"));
        }
        return oCSymbolKind;
    }

    @Override
    @NotNull
    public OCStructType getType() {
        OCStructType oCStructType = new OCStructType(this);
        if (oCStructType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "getType"));
        }
        return oCStructType;
    }

    @Override
    @Nullable
    public TextRange getScope() {
        return this.myScope;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.getType().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "getPresentableName"));
        }
        return string;
    }

    @Override
    public Icon computeFullIcon(@Nullable OCElement symbolElement) {
        Icon result2 = super.computeFullIcon(symbolElement);
        if (result2 != null && OCTestFrameworks.isTestClass(this)) {
            result2 = OCIcons.getTestIcon(result2);
        }
        return result2;
    }

    public boolean processAllMembersWithName(String name, final Processor<OCSymbol> processor2) {
        if (!this.isGlobal()) {
            return this.processMembers(name, new Processor<OCSymbol>(){

                public boolean process(OCSymbol constructor) {
                    return processor2.process((Object)constructor);
                }
            });
        }
        final OCSymbol definition = this.getDefinitionSymbol();
        Processor<OCSymbol> _processor = new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                if (!symbol.getClass().equals(OCFunctionSymbol.class)) {
                    return true;
                }
                OCSymbolWithQualifiedName resolvedQualifiedName = ((OCSymbolWithQualifiedName)symbol).getResolvedOwner();
                if (resolvedQualifiedName == null || !resolvedQualifiedName.equals(definition)) {
                    return true;
                }
                return processor2.process((Object)symbol);
            }
        };
        return OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(this.myProject, _processor, name);
    }

    public boolean processConstructors(Processor<? super OCFunctionSymbol> processor2) {
        return this.processConstructors(processor2, false, false, null);
    }

    public boolean processConstructors(Processor<? super OCFunctionSymbol> processor2, boolean includeUsingBaseConstructors, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "processConstructors"));
        }
        return this.processConstructors(processor2, false, includeUsingBaseConstructors, context);
    }

    public boolean processConstructors(Processor<? super OCFunctionSymbol> processor2, boolean includeOutOfClassDefinitions) {
        return this.processConstructors(processor2, includeOutOfClassDefinitions, false, null);
    }

    private boolean processConstructors(final Processor<? super OCFunctionSymbol> processor2, boolean includeOutOfClassDefinitions, boolean includeUsingBaseConstructors, @Nullable OCResolveContext context) {
        Processor<OCSymbol> memberProcessor = new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor()) {
                    return processor2.process((Object)((OCFunctionSymbol)symbol));
                }
                return true;
            }
        };
        if (includeUsingBaseConstructors && context != null && !this.processMembers((String)null, new Processor<OCSymbol>((Processor)memberProcessor, context){
            final /* synthetic */ Processor val$memberProcessor;
            final /* synthetic */ OCResolveContext val$context;
            {
                this.val$memberProcessor = processor2;
                this.val$context = oCResolveContext;
            }

            public boolean process(OCSymbol symbol) {
                return !(symbol instanceof OCUsingSymbol) || ((OCUsingSymbol)symbol).getSymbolReference().processPossibleSymbols((Processor<OCSymbol>)this.val$memberProcessor, this.val$context);
            }
        })) {
            return false;
        }
        if (includeOutOfClassDefinitions) {
            return this.processAllMembersWithName(this.myName, memberProcessor);
        }
        return this.processMembers(this.myName, memberProcessor);
    }

    public boolean processDestructors(final Processor<OCFunctionSymbol> processor2, boolean includeOutOfClassDefinitions) {
        Processor<OCSymbol> memberProcessor = new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppDestructor()) {
                    return processor2.process((Object)((OCFunctionSymbol)symbol));
                }
                return true;
            }
        };
        if (includeOutOfClassDefinitions) {
            return this.processAllMembersWithName("~" + this.myName, memberProcessor);
        }
        return this.processMembers("~" + this.myName, memberProcessor);
    }

    public boolean hasDefaultConstructor() {
        class MyProcessor
        implements Processor<OCFunctionSymbol> {
            boolean wasConstructor;
            boolean wasDefaultConstructor;

            MyProcessor() {
            }

            public boolean process(OCFunctionSymbol symbol) {
                this.wasConstructor = true;
                this.wasDefaultConstructor |= symbol.canBeCalledWithoutArguments();
                return true;
            }

            public boolean hasDefaultConstructor() {
                return !this.wasConstructor || this.wasDefaultConstructor;
            }
        }
        MyProcessor processor2 = new MyProcessor();
        this.processConstructors(processor2);
        return processor2.hasDefaultConstructor();
    }

    public boolean hasDeclaredConstructor() {
        return !this.processConstructors((Processor<? super OCFunctionSymbol>)new CommonProcessors.FindFirstProcessor());
    }

    @Nullable
    public OCFunctionSymbol getDefaultConstructor() {
        CommonProcessors.FindFirstProcessor<OCFunctionSymbol> finder = new CommonProcessors.FindFirstProcessor<OCFunctionSymbol>(){

            protected boolean accept(OCFunctionSymbol symbol) {
                return symbol.canBeCalledWithoutArguments();
            }
        };
        this.processConstructors((Processor<? super OCFunctionSymbol>)finder);
        return (OCFunctionSymbol)finder.getFoundValue();
    }

    public boolean isPOD(boolean checkInnerStructs) {
        if (this.mySymbolKind != OCSymbolKind.STRUCT && this.mySymbolKind != OCSymbolKind.ENUM) {
            return false;
        }
        if (!this.myBaseCppClasses.isEmpty()) {
            return false;
        }
        return OCStructSymbol.isPOD(this, new HashSet<OCSymbol>(), checkInnerStructs, this.getContainingOCFile());
    }

    public boolean isPOD() {
        return this.isPOD(true);
    }

    private static boolean isPOD(OCStructSymbol symbol, final Set<OCSymbol> processed, final boolean checkInnerStructs, final OCFile file2) {
        final boolean[] pod = new boolean[]{true};
        symbol.processMembers((String)null, new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                if (!processed.add(symbol)) {
                    return true;
                }
                if (symbol instanceof OCStructSymbol) {
                    if (checkInnerStructs && !OCStructSymbol.isPOD((OCStructSymbol)symbol, processed, true, file2)) {
                        pod[0] = false;
                        return false;
                    }
                } else if (symbol instanceof OCDeclaratorSymbol) {
                    OCVisibility vis = ((OCDeclaratorSymbol)symbol).getVisibility();
                    if (vis != null && vis != OCVisibility.NULL && vis != OCVisibility.PUBLIC) {
                        pod[0] = false;
                        return false;
                    }
                    OCType type = symbol.getType().resolve(file2);
                    if (checkInnerStructs && type instanceof OCStructType && symbol.getKind() != OCSymbolKind.TYPEDEF && ContainerUtil.exists(((OCStructType)type).getStructs(), (Condition)new Condition<OCStructSymbol>(){

                        public boolean value(OCStructSymbol symbol) {
                            return !OCStructSymbol.isPOD(symbol, processed, true, file2);
                        }
                    })) {
                        pod[0] = false;
                        return false;
                    }
                }
                return true;
            }
        });
        return pod[0];
    }

    public boolean hasMemberFunctions() {
        return !this.processFunctions(null, (Processor<OCFunctionSymbol>)new CommonProcessors.FindFirstProcessor());
    }

    @NotNull
    public Collection<OCType> getBaseCppClasses(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "getBaseCppClasses"));
        }
        Collection<OCType> collection = this.getBaseCppClasses(new OCResolveContext(context));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "getBaseCppClasses"));
        }
        return collection;
    }

    @NotNull
    public Collection<OCType> getBaseCppClasses(final @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "getBaseCppClasses"));
        }
        List list = ContainerUtil.map(this.myBaseCppClasses, (Function)new Function<Pair<OCType, OCVisibility>, OCType>(){

            public OCType fun(Pair<OCType, OCVisibility> pair) {
                return OCStructSymbol.this.mySubstitution.substitute((OCType)pair.first, context);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "getBaseCppClasses"));
        }
        return list;
    }

    public boolean processBaseClasses(@NotNull OCResolveContext context, BaseClassProcessor processor2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "processBaseClasses"));
        }
        for (Pair<OCType, OCVisibility> pair : this.myBaseCppClasses) {
            OCType type = this.mySubstitution.substitute((OCType)pair.first, context);
            OCType resolved = type.accept(new OCTypeResolveVisitor(context));
            if (resolved instanceof OCStructType) {
                for (OCStructSymbol oCStructSymbol : ((OCStructType)resolved).getStructs()) {
                    if (processor2.process(oCStructSymbol, (OCVisibility)((Object)pair.second))) continue;
                    return false;
                }
                continue;
            }
            if (!(type instanceof OCReferenceType)) continue;
            for (OCSymbol<OCElement> oCSymbol : context.resolveToSymbols(((OCReferenceType)type).getReference(), true, true)) {
                if (processor2.process(oCSymbol, (OCVisibility)((Object)pair.second))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean processAllBaseClasses(BaseClassProcessor processor2) {
        OCFile file2 = this.getContainingOCFile();
        return file2 == null || this.processAllBaseClasses(new OCResolveContext(file2), processor2, true);
    }

    public boolean processAllBaseClasses(@NotNull OCResolveContext context, final BaseClassProcessor processor2, final boolean skipFirstVisibility) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "processAllBaseClasses"));
        }
        Set<OCNamespaceLikeSymbol> processed = OCTypeUtils.newSymbolWithSubstitutionSet();
        final Stack<OCStructSymbol> structsWorkset = new Stack<OCStructSymbol>();
        final Stack visibilityWorkset = new Stack();
        structsWorkset.add(this);
        visibilityWorkset.add(null);
        while (!structsWorkset.isEmpty()) {
            OCStructSymbol symbol = (OCStructSymbol)structsWorkset.pop();
            final OCVisibility visibility = (OCVisibility)((Object)visibilityWorkset.pop());
            if (processed.contains(symbol)) continue;
            processed.add(symbol);
            if (symbol.processBaseClasses(context, new BaseClassProcessor(){

                @Override
                public boolean process(OCSymbol baseSymbol, OCVisibility baseVisibility) {
                    baseVisibility = visibility == null ? (skipFirstVisibility ? OCVisibility.PUBLIC : baseVisibility) : OCVisibility.max(visibility, baseVisibility);
                    if (!processor2.process(baseSymbol, baseVisibility)) {
                        return false;
                    }
                    if (baseSymbol instanceof OCStructSymbol) {
                        structsWorkset.push((OCStructSymbol)baseSymbol);
                        visibilityWorkset.push(baseVisibility);
                    }
                    return true;
                }
            })) continue;
            return false;
        }
        return true;
    }

    public boolean isAncestor(OCStructSymbol struct) {
        return this.resolvedNamesEqual(struct) || !struct.processAllBaseClasses(new BaseClassProcessor(){

            @Override
            public boolean process(OCSymbol symbol, OCVisibility visibility) {
                return !(symbol instanceof OCStructSymbol) || !OCStructSymbol.this.resolvedNamesEqual((OCSymbolWithQualifiedName)symbol);
            }
        });
    }

    public List<OCTypeArgument> getTemplateArguments(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol", "getTemplateArguments"));
        }
        ArrayList<OCTypeArgument> result2 = new ArrayList<OCTypeArgument>();
        List<OCTypeArgument> specialization = this.getTemplateSpecialization();
        if (specialization != null) {
            for (OCTypeArgument spec : specialization) {
                if (spec instanceof OCType) {
                    OCType substitution = this.getSubstitution().substitute(((OCType)spec).transformType(new OCTypeResolveVisitor(context, false)), context);
                    if (substitution instanceof OCStructType && ((OCStructType)substitution).getSymbol().equals(this)) continue;
                    result2.add(substitution);
                    continue;
                }
                result2.add(spec);
            }
        } else {
            for (OCTypeParameterSymbol param : this.getTemplateParameters()) {
                result2.add(this.getSubstitution().getSubstitutionFor(param));
            }
        }
        return result2;
    }

    public static interface BaseClassProcessor {
        public boolean process(OCSymbol var1, OCVisibility var2);
    }

    public static class Attributes {
        public static final int IS_FRIEND = 1;
        public static final int IS_ENUM_CLASS = 2;
        public static final int IS_FINAL = 4;
        public static final int DEFAULT = 0;

        private Attributes() {
        }
    }
}

