/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNamespaceSymbol
extends OCSymbolWithQualifiedName<OCElement>
implements OCNamespaceLikeSymbol {
    @Nullable
    private MostlySingularMultiMap<String, OCSymbol> myMembers;
    @Nullable
    private List<OCSymbol> myMembersList;
    private List<OCUsingSymbol> myNamespaceUsings;
    private Collection<OCNamespaceSymbol> myInlineNamespaces;
    private boolean myInlineNamespace;

    public OCNamespaceSymbol() {
    }

    /*
     * WARNING - void declaration
     */
    public OCNamespaceSymbol(@Nullable Project project, @Nullable VirtualFile virtualFile, long startOffset, @Nullable OCSymbolWithQualifiedName parent, @NotNull OCQualifiedName name, @NotNull List<String> attributes, @Nullable List<OCSymbol> membersList, @Nullable MostlySingularMultiMap<String, OCSymbol> membersMap, @Nullable List<OCUsingSymbol> namespaceUsings, boolean bl) {
        void inlineNamespace;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/symbols/cpp/OCNamespaceSymbol", "<init>"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/jetbrains/cidr/lang/symbols/cpp/OCNamespaceSymbol", "<init>"));
        }
        super(project, virtualFile, startOffset, parent, name, attributes, null);
        this.myMembersList = ContainerUtil.trimToSize(membersList);
        this.myMembers = membersMap;
        this.myNamespaceUsings = namespaceUsings;
        this.myInlineNamespace = inlineNamespace;
    }

    /*
     * WARNING - void declaration
     */
    protected OCNamespaceSymbol(@Nullable Project project, @Nullable VirtualFile virtualFile, long startOffset, @Nullable OCSymbolWithQualifiedName parent, @NotNull OCQualifiedName name, @NotNull List<String> attributes, @Nullable List<OCSymbol> membersList, @Nullable MostlySingularMultiMap<String, OCSymbol> members, @Nullable List<OCUsingSymbol> namespaceUsings, boolean inlineNamespace, OCVisibility oCVisibility) {
        void visibility;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/symbols/cpp/OCNamespaceSymbol", "<init>"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/jetbrains/cidr/lang/symbols/cpp/OCNamespaceSymbol", "<init>"));
        }
        super(project, virtualFile, startOffset, parent, name, attributes, (OCVisibility)visibility);
        this.myMembersList = membersList;
        this.myMembers = members;
        this.myNamespaceUsings = namespaceUsings;
        this.myInlineNamespace = inlineNamespace;
    }

    public static OCNamespaceSymbol createGlobalNamespaceSymbol(PsiFile file2) {
        return new OCNamespaceSymbol(file2.getProject(), file2.getVirtualFile(), 0L, null, OCQualifiedName.GLOBAL, Collections.<String>emptyList(), null, null, null, false);
    }

    public boolean isGlobalNamespace() {
        return this.myComplexOffset == 0L && this.myMembers == null;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = OCSymbolKind.NAMESPACE;
        if (oCSymbolKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCNamespaceSymbol", "getKind"));
        }
        return oCSymbolKind;
    }

    @Override
    public boolean isDefinition() {
        return false;
    }

    @Nullable
    public MostlySingularMultiMap<String, OCSymbol> getMembers() {
        return this.myMembers;
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public boolean isTopLevel() {
        return true;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/symbols/cpp/OCNamespaceSymbol", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/symbols/cpp/OCNamespaceSymbol", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/symbols/cpp/OCNamespaceSymbol", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCNamespaceSymbol f = (OCNamespaceSymbol)first;
        OCNamespaceSymbol s = (OCNamespaceSymbol)second;
        if (!c.equalIterable(f.myNamespaceUsings, s.myNamespaceUsings)) {
            return false;
        }
        return c.equalMultiMaps(f.myMembers, s.myMembers);
    }

    @Override
    public void updateOffset(final int start, final int end, final int lengthShift) {
        super.updateOffset(start, end, lengthShift);
        if (this.myMembers != null) {
            this.myMembers.processAllValues((Processor)new Processor<OCSymbol>(){

                public boolean process(OCSymbol member) {
                    member.updateOffset(start, end, lengthShift);
                    return true;
                }
            });
        }
    }

    @Override
    public void compact() {
        super.compact();
        if (this.myMembers != null) {
            this.myMembers.processAllValues((Processor)new Processor<OCSymbol>(){

                public boolean process(OCSymbol member) {
                    member.compact();
                    return true;
                }
            });
        }
    }

    @Nullable
    public List<OCSymbol> getMembersList() {
        return this.myMembersList;
    }

    @Override
    public boolean processMembers(@Nullable String memberName, @NotNull Processor<OCSymbol> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/symbols/cpp/OCNamespaceSymbol", "processMembers"));
        }
        if (this.myMembers == null) {
            return true;
        }
        if (memberName != null) {
            return this.myMembers.processForKey((Object)memberName, processor2);
        }
        return this.myMembers.processAllValues(processor2);
    }

    public boolean processMembers(@NotNull Processor<OCSymbol> processor2, int afterOffset, int beforeOffset) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/symbols/cpp/OCNamespaceSymbol", "processMembers"));
        }
        return this.myMembersList == null || OCResolveUtil.processSymbolsFromList(processor2, this.myMembersList, afterOffset, beforeOffset);
    }

    @Nullable
    public List<OCUsingSymbol> getNamespaceUsings() {
        return this.myNamespaceUsings;
    }

    @Override
    @Nullable
    public Collection<OCNamespaceSymbol> getInlineNamespaces() {
        return this.myInlineNamespaces;
    }

    public Processor<OCSymbol> getBuilder() {
        return new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                if (symbol.getKind() == OCSymbolKind.NAMESPACE_USING_SYMBOL) {
                    if (OCNamespaceSymbol.this.myNamespaceUsings == null) {
                        OCNamespaceSymbol.this.myNamespaceUsings = new ArrayList();
                    }
                    OCNamespaceSymbol.this.myNamespaceUsings.add((OCUsingSymbol)symbol);
                } else {
                    if (OCNamespaceSymbol.this.myMembers == null) {
                        OCNamespaceSymbol.this.myMembers = new MostlySingularMultiMap();
                        OCNamespaceSymbol.this.myMembersList = new ArrayList();
                    }
                    if (symbol != OCNamespaceSymbol.this) {
                        if (symbol instanceof OCNamespaceSymbol && ((OCNamespaceSymbol)symbol).isInlineNamespace()) {
                            if (OCNamespaceSymbol.this.myInlineNamespaces == null) {
                                OCNamespaceSymbol.this.myInlineNamespaces = new ArrayList();
                            }
                            OCNamespaceSymbol.this.myInlineNamespaces.add((OCNamespaceSymbol)symbol);
                        }
                        OCNamespaceSymbol.this.myMembers.add((Object)symbol.getName(), (Object)symbol);
                        OCNamespaceSymbol.this.myMembersList.add(symbol);
                    }
                }
                return true;
            }
        };
    }

    public boolean isInlineNamespace() {
        return this.myInlineNamespace;
    }

    @Override
    public boolean isTemplateSymbol() {
        return false;
    }

    @Override
    @NotNull
    public List<OCTypeParameterSymbol> getTemplateParameters() {
        List<OCTypeParameterSymbol> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCNamespaceSymbol", "getTemplateParameters"));
        }
        return list;
    }

    public int getLastElementOffset() {
        OCSymbol symbol;
        OCSymbol oCSymbol = symbol = this.myMembersList != null ? (OCSymbol)ContainerUtil.getLastItem(this.myMembersList) : null;
        if (symbol instanceof OCNamespaceSymbol) {
            return ((OCNamespaceSymbol)symbol).getLastElementOffset();
        }
        if (symbol != null) {
            return symbol.getOffset();
        }
        return this.getOffset();
    }
}

