/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCIncludeSymbol
extends OCSymbolImpl {
    private transient VirtualFile myTargetFile;
    private boolean myOnce;
    private boolean myNext;
    private IncludePath myIncludePath;
    private int myEndOffset;

    public OCIncludeSymbol() {
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/symbols/cpp/OCIncludeSymbol", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/symbols/cpp/OCIncludeSymbol", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/symbols/cpp/OCIncludeSymbol", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCIncludeSymbol f = (OCIncludeSymbol)first;
        OCIncludeSymbol s = (OCIncludeSymbol)second;
        if (f.myNext != s.myNext) {
            return false;
        }
        if (f.myOnce != s.myOnce) {
            return false;
        }
        if (f.myEndOffset != s.myEndOffset) {
            return false;
        }
        if (!Comparing.equal((Object)f.myIncludePath, (Object)s.myIncludePath)) {
            return false;
        }
        return Comparing.equal((Object)f.myTargetFile, (Object)s.myTargetFile);
    }

    public OCIncludeSymbol(@Nullable Project project, @Nullable VirtualFile file2, int offset, VirtualFile targetFile, IncludePath path, boolean once, boolean next, int endOffset) {
        super(project, file2, offset, path.getPath(), Collections.<String>emptyList());
        this.myIncludePath = path;
        this.myTargetFile = targetFile;
        this.myOnce = once;
        this.myNext = next;
        this.myEndOffset = endOffset;
    }

    public VirtualFile getTargetFile() {
        return this.myTargetFile;
    }

    public void updateTargetFile(VirtualFile targetFile) {
        this.myTargetFile = targetFile;
    }

    public boolean isOnce() {
        return this.myOnce;
    }

    public boolean isNext() {
        return this.myNext;
    }

    public String getRelativePath() {
        return this.getName();
    }

    public String getLastPathComponent() {
        String path = this.getRelativePath();
        int idx = path.lastIndexOf(47);
        return idx >= 0 ? path.substring(idx + 1) : path;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = OCSymbolKind.IMPORT;
        if (oCSymbolKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCIncludeSymbol", "getKind"));
        }
        return oCSymbolKind;
    }

    @NotNull
    public IncludePath getIncludePath() {
        IncludePath includePath = this.myIncludePath;
        if (includePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCIncludeSymbol", "getIncludePath"));
        }
        return includePath;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    public static class IncludePath {
        public String myPath;
        public boolean myAngleBrackets;
        public static final IncludePath EMPTY = new EmptyIncludePath();

        public IncludePath() {
        }

        public IncludePath(String path, boolean angleBrackets) {
            this.myPath = path;
            this.myAngleBrackets = angleBrackets;
        }

        public String toString() {
            return this.myAngleBrackets ? "<" + this.myPath + ">" : "\"" + this.myPath + "\"";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IncludePath)) {
                return false;
            }
            IncludePath path = (IncludePath)o;
            if (this.myAngleBrackets != path.myAngleBrackets) {
                return false;
            }
            return !(this.myPath != null ? !this.myPath.equals(path.myPath) : path.myPath != null);
        }

        public int hashCode() {
            int result2 = this.myPath != null ? this.myPath.hashCode() : 0;
            result2 = 31 * result2 + (this.myAngleBrackets ? 1 : 0);
            return result2;
        }

        public String getPath() {
            return this.myPath;
        }

        public boolean isAngleBrackets() {
            return this.myAngleBrackets;
        }

        private static class EmptyIncludePath
        extends IncludePath {
            private EmptyIncludePath() {
                super("", false);
            }
        }
    }
}

