/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionSymbol
extends OCSymbolWithQualifiedName<OCElement>
implements OCSymbolWithSubstitution {
    public static final String ATTRIBUTE_IMPLICIT_BRIDGING = "ImplicitBridging";
    private OCFunctionType myType;
    @NotNull
    private List<OCTypeParameterSymbol> myTemplateParameters;
    @NotNull
    private List<OCDeclaratorSymbol> myParameterSymbols;
    private OCSymbolKind myKind;
    private int myFunctionAttributes;
    @NotNull
    private OCTypeSubstitution mySubstitution;

    public OCFunctionSymbol() {
        this.mySubstitution = OCTypeSubstitution.ID;
    }

    /*
     * WARNING - void declaration
     */
    public OCFunctionSymbol(Project project, VirtualFile file2, long offset, OCSymbolWithQualifiedName container, OCQualifiedName name, List<OCTypeParameterSymbol> templateParameters, int functionAttributes, @NotNull List<String> attributes, @NotNull OCFunctionType type, List<OCDeclaratorSymbol> parameterSymbols, OCSymbolKind kind, @Nullable OCVisibility oCVisibility) {
        void visibility;
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol", "<init>"));
        }
        super(project, file2, offset, container, name, attributes, (OCVisibility)visibility);
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myType = type;
        this.myTemplateParameters = templateParameters;
        this.myParameterSymbols = parameterSymbols;
        this.myKind = kind;
        this.myFunctionAttributes = functionAttributes;
    }

    public OCFunctionSymbol(OCFunctionSymbol origin) {
        this(origin, origin.getParent());
    }

    public OCFunctionSymbol(OCFunctionSymbol origin, OCSymbolWithQualifiedName parent) {
        super(origin.getProject(), origin.getContainingFile(), origin.getOffset(), parent, origin.getQualifiedName(), origin.getAttributes(), origin.getVisibility());
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myType = origin.myType;
        this.myTemplateParameters = origin.myTemplateParameters;
        this.myParameterSymbols = origin.myParameterSymbols;
        this.myKind = origin.myKind;
        this.myFunctionAttributes = origin.myFunctionAttributes;
        this.mySubstitution = origin.mySubstitution;
    }

    public OCFunctionSymbol(OCFunctionSymbol origin, OCTypeSubstitution substitution, OCSymbolWithQualifiedName parent, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol", "<init>"));
        }
        this(origin, parent);
        this.mySubstitution = OCTypeSubstitution.compose(origin.mySubstitution, substitution, context);
    }

    @Override
    public boolean isConst() {
        return this.myType.isConst();
    }

    public boolean isVolatile() {
        return this.myType.isVolatile();
    }

    public boolean isConstexpr() {
        return (this.myFunctionAttributes & 0x800) != 0;
    }

    public boolean isVirtual() {
        return (this.myFunctionAttributes & 2) != 0;
    }

    public boolean isPureVirtual() {
        return (this.myFunctionAttributes & 0x400) != 0;
    }

    @Override
    public boolean isStatic() {
        return (this.myFunctionAttributes & 4) != 0;
    }

    public boolean isExplicit() {
        return (this.myFunctionAttributes & 8) != 0;
    }

    public boolean isDefault() {
        return (this.myFunctionAttributes & 0x10) != 0;
    }

    public boolean isDelete() {
        return (this.myFunctionAttributes & 0x20) != 0;
    }

    public boolean isCppOperator() {
        return (this.myFunctionAttributes & 0x40) != 0;
    }

    public boolean isCppConversionOperator() {
        return (this.myFunctionAttributes & 0x80) != 0;
    }

    @Override
    public boolean isTemplateSymbol() {
        return (this.myFunctionAttributes & 0x100) != 0;
    }

    public boolean isFriendFunction() {
        return (this.myFunctionAttributes & 0x200) != 0;
    }

    public boolean isFinal() {
        return (this.myFunctionAttributes & 0x1000) != 0;
    }

    public boolean isOverride() {
        return (this.myFunctionAttributes & 0x2000) != 0;
    }

    public boolean isVararg() {
        return this.myType.isVararg();
    }

    public boolean isCppMemberOperator(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol", "isCppMemberOperator"));
        }
        return this.isCppOperator() && this.getResolvedOwner(context, false) instanceof OCStructSymbol && !this.isStatic();
    }

    public boolean isCppNonMemberOperator(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol", "isCppNonMemberOperator"));
        }
        return this.isCppOperator() && !this.isCppMemberOperator(context);
    }

    public void setType(OCFunctionType type) {
        this.myType = type;
    }

    @Nullable
    public OCFunctionDeclaration locateFunctionDefinition() {
        OCElement declarator = (OCElement)this.locateDefinition();
        PsiElement parent = declarator != null ? declarator.getParent() : null;
        return parent instanceof OCFunctionDeclaration ? (OCFunctionDeclaration)parent : null;
    }

    @Override
    @NotNull
    public List<OCTypeParameterSymbol> getTemplateParameters() {
        List<OCTypeParameterSymbol> list = this.myTemplateParameters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol", "getTemplateParameters"));
        }
        return list;
    }

    public boolean isCppConstructor() {
        return this.getKind().isConstructorOrDestructor() && !this.isCppDestructor();
    }

    public boolean isCppDestructor() {
        return this.getName().startsWith("~");
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCFunctionSymbol f = (OCFunctionSymbol)first;
        OCFunctionSymbol s = (OCFunctionSymbol)second;
        if (f.myFunctionAttributes != s.myFunctionAttributes) {
            return false;
        }
        if (!Comparing.equal((Object)((Object)f.myKind), (Object)((Object)s.myKind))) {
            return false;
        }
        if (!c.equalIterable(f.myParameterSymbols, s.myParameterSymbols)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        if (!c.equalIterable(f.myTemplateParameters, s.myTemplateParameters)) {
            return false;
        }
        return c.equalObjects(f.myType, s.myType);
    }

    @Nullable
    public OCFunctionSymbol getDeclarationInParent() {
        if (this.isPredeclaration()) {
            return this;
        }
        OCSymbolWithQualifiedName owner = this.getResolvedOwner();
        final Ref result2 = new Ref(null);
        if (owner instanceof OCStructSymbol) {
            final OCType resolvedType = this.getResolvedType();
            ((OCStructSymbol)owner).processMembers(this.getName(), new Processor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    if (symbol instanceof OCFunctionSymbol) {
                        OCType symbolType = symbol.getType().resolve(OCFunctionSymbol.this.getContainingOCFile());
                        if (!resolvedType.accept(new OCTypeEqualityVisitor(symbolType, true, new OCResolveContext())).booleanValue()) {
                            return true;
                        }
                        result2.set((Object)((OCFunctionSymbol)symbol));
                        return false;
                    }
                    return true;
                }
            });
        }
        return (OCFunctionSymbol)result2.get();
    }

    public boolean resolveIsStatic() {
        if (this.isStatic() || this.getQualifier() == null) {
            return this.isStatic();
        }
        OCFunctionSymbol predef = this.getDeclarationInParent();
        return predef != null && predef.isStatic();
    }

    @Override
    public void updateOffset(int start, int end, int lengthShift) {
        super.updateOffset(start, end, lengthShift);
        for (OCTypeParameterSymbol templateParameter : this.myTemplateParameters) {
            ((OCSymbol)((Object)templateParameter)).updateOffset(start, end, lengthShift);
        }
        for (OCDeclaratorSymbol parameterSymbol : this.myParameterSymbols) {
            parameterSymbol.updateOffset(start, end, lengthShift);
        }
    }

    @Override
    public void compact() {
        super.compact();
        for (OCTypeParameterSymbol templateParameter : this.myTemplateParameters) {
            ((OCSymbol)((Object)templateParameter)).compact();
        }
        for (OCDeclaratorSymbol parameterSymbol : this.myParameterSymbols) {
            parameterSymbol.compact();
        }
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = this.myKind;
        if (oCSymbolKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol", "getKind"));
        }
        return oCSymbolKind;
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        boolean nonVirtual = this.myParent instanceof OCStructSymbol && !this.isVirtual() && !this.isCppConstructor() && !this.isStatic();
        return OCIcons.getFunctionIcon(this.isStatic(), this.isPureVirtual(), nonVirtual, this.getVisibility());
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        OCTypeSubstitution oCTypeSubstitution = this.mySubstitution;
        if (oCTypeSubstitution == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol", "getSubstitution"));
        }
        return oCTypeSubstitution;
    }

    public int getFunctionAttributes() {
        return this.myFunctionAttributes;
    }

    @Override
    @NotNull
    public OCFunctionType getType() {
        OCFunctionType oCFunctionType = (OCFunctionType)this.mySubstitution.substitute(this.myType, new OCResolveContext());
        if (oCFunctionType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol", "getType"));
        }
        return oCFunctionType;
    }

    @NotNull
    public OCFunctionType getTypeWithoutSubstitution() {
        OCFunctionType oCFunctionType = this.myType;
        if (oCFunctionType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol", "getTypeWithoutSubstitution"));
        }
        return oCFunctionType;
    }

    public List<OCDeclaratorSymbol> getParameterSymbols() {
        return this.mySubstitution.substitute(this.myParameterSymbols, new OCResolveContext());
    }

    public int getNonInitializedParametersCount() {
        if (this.myName.equals("operator++") || this.myName.equals("operator--")) {
            return 0;
        }
        if (this.myType.hasNoParameters()) {
            return 0;
        }
        int result2 = 0;
        for (OCDeclaratorSymbol param : this.getParameterSymbols()) {
            if (param.hasInitializer() || param.getType().getTerminalType() instanceof OCEllipsisType) break;
            ++result2;
        }
        return result2;
    }

    @Override
    public OCType getEffectiveType() {
        return this.mySubstitution.substitute(this.myType.getReturnType(), new OCResolveContext());
    }

    @Override
    @NotNull
    public OCType getEffectiveResolvedType() {
        OCType type = this.getResolvedType();
        OCType result2 = type instanceof OCFunctionType ? ((OCFunctionType)type).getReturnType() : type;
        OCType oCType = this.mySubstitution.substitute(result2, new OCResolveContext());
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol", "getEffectiveResolvedType"));
        }
        return oCType;
    }

    public boolean canBeCalledWithoutArguments() {
        return this.getNonInitializedParametersCount() == 0;
    }

    public boolean isMainFunction() {
        return "main".equals(this.myName) && this.getResolvedOwner() == null;
    }

    @Override
    public String getKindUppercase() {
        return this.isCppDestructor() ? "Destructor" : super.getKindUppercase();
    }

    @Override
    @NotNull
    public String getSignature() {
        StringBuilder buffer = new StringBuilder();
        String typeText = this.getType().getReturnType().getName();
        buffer.append(typeText);
        if (!typeText.endsWith("*")) {
            buffer.append(" ");
        }
        buffer.append(this.getName());
        buffer.append(this.getParametersSignature());
        this.getType().getCVQualifiers().appendCVQualifiers(buffer);
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol", "getSignature"));
        }
        return string;
    }

    @NotNull
    public String getParametersSignature() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        boolean isFirst = true;
        for (OCDeclaratorSymbol param : this.getParameterSymbols()) {
            if (!isFirst) {
                buffer.append(", ");
            }
            buffer.append(param.getSignature());
            isFirst = false;
        }
        buffer.append(')');
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol", "getParametersSignature"));
        }
        return string;
    }

    @NotNull
    public String getSignatureWithoutParamNames() {
        String string = this.getSignatureWithoutParamNames(false, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol", "getSignatureWithoutParamNames"));
        }
        return string;
    }

    @NotNull
    public String getSignatureWithoutParamNames(boolean fullyQualifiedName, boolean addReturnType) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(fullyQualifiedName ? this.getNameWithParent() : this.getName());
        buffer.append(this.getParamsSignatureWithoutNames());
        this.getType().getCVQualifiers().appendCVQualifiers(buffer);
        if (addReturnType && !this.isCppConstructor()) {
            buffer.append(" : ");
            buffer.append(this.getType().getReturnType().getName());
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol", "getSignatureWithoutParamNames"));
        }
        return string;
    }

    @NotNull
    public String getParamsSignatureWithoutNames() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        boolean isFirst = true;
        for (OCDeclaratorSymbol param : this.getParameterSymbols()) {
            if (!isFirst) {
                buffer.append(", ");
            }
            buffer.append(param.getType().getName());
            isFirst = false;
        }
        buffer.append(")");
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol", "getParamsSignatureWithoutNames"));
        }
        return string;
    }

    public static class Attributes {
        public static final int IS_VIRTUAL = 2;
        public static final int IS_STATIC = 4;
        public static final int IS_EXPLICIT = 8;
        public static final int IS_DEFAULT = 16;
        public static final int IS_DELETE = 32;
        public static final int IS_OPERATOR = 64;
        public static final int IS_CONVERSION_OPERATOR = 128;
        public static final int IS_TEMPLATE = 256;
        public static final int IS_FRIEND = 512;
        public static final int IS_PURE_VIRTUAL = 1024;
        public static final int IS_CONSTEEXPR = 2048;
        public static final int IS_FINAL = 4096;
        public static final int IS_OVERRIDE = 8192;
        public static final int DEFAULT = 0;

        private Attributes() {
        }

        public static int create(boolean isVirtual, boolean isConstexpr, boolean isPureVirtual, boolean isStatic, boolean isExplicit, boolean isDefault, boolean isDelete, boolean isOperator, boolean isConversionOperator, boolean isTemplate, boolean isFriend, boolean isFinal, boolean isOverride) {
            int result2 = 0;
            if (isVirtual) {
                result2 |= 2;
            }
            if (isPureVirtual) {
                result2 |= 0x400;
            }
            if (isStatic) {
                result2 |= 4;
            }
            if (isExplicit) {
                result2 |= 8;
            }
            if (isDefault) {
                result2 |= 0x10;
            }
            if (isDelete) {
                result2 |= 0x20;
            }
            if (isOperator) {
                result2 |= 0x40;
            }
            if (isConversionOperator) {
                result2 |= 0x80;
            }
            if (isTemplate) {
                result2 |= 0x100;
            }
            if (isFriend) {
                result2 |= 0x200;
            }
            if (isConstexpr) {
                result2 |= 0x800;
            }
            if (isFinal) {
                result2 |= 0x1000;
            }
            if (isOverride) {
                result2 |= 0x2000;
            }
            return result2;
        }
    }
}

