/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAliasUsingSymbol
extends OCSymbolWithQualifiedName
implements Serializable {
    private OCType myType;
    @NotNull
    private List<OCTypeParameterSymbol> myTemplateParameters;
    @NotNull
    private OCTypeSubstitution mySubstitution;
    @Nullable
    private TextRange myScope;

    public OCAliasUsingSymbol() {
        this.mySubstitution = OCTypeSubstitution.ID;
    }

    /*
     * WARNING - void declaration
     */
    public OCAliasUsingSymbol(Project project, VirtualFile file2, long offset, @NotNull String name, OCSymbolWithQualifiedName parent, @NotNull List<OCTypeParameterSymbol> templateParameters, @Nullable TextRange textRange) {
        void scope;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/symbols/cpp/OCAliasUsingSymbol", "<init>"));
        }
        if (templateParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateParameters", "com/jetbrains/cidr/lang/symbols/cpp/OCAliasUsingSymbol", "<init>"));
        }
        super(project, file2, offset, parent, OCQualifiedName.with(name), Collections.<String>emptyList(), null);
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myScope = scope;
        this.myTemplateParameters = templateParameters;
    }

    public OCAliasUsingSymbol(OCAliasUsingSymbol origin, OCTypeSubstitution substitution, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/cpp/OCAliasUsingSymbol", "<init>"));
        }
        super(origin.getProject(), origin.getContainingFile(), origin.getOffset(), origin.getParent(), origin.getQualifiedName(), Collections.<String>emptyList(), null);
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myType = origin.myType;
        this.myTemplateParameters = origin.myTemplateParameters;
        this.mySubstitution = OCTypeSubstitution.compose(origin.mySubstitution, substitution, context);
        this.myScope = origin.myScope;
    }

    @Override
    @NotNull
    public OCType getType() {
        OCType oCType = this.mySubstitution.substitute(this.myType, new OCResolveContext());
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCAliasUsingSymbol", "getType"));
        }
        return oCType;
    }

    public void setType(OCType type) {
        this.myType = type;
    }

    @Override
    @Nullable
    public TextRange getScope() {
        return this.myScope;
    }

    @Override
    @NotNull
    public List<OCTypeParameterSymbol> getTemplateParameters() {
        List<OCTypeParameterSymbol> list = this.myTemplateParameters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCAliasUsingSymbol", "getTemplateParameters"));
        }
        return list;
    }

    @Override
    public boolean isTemplateSymbol() {
        return !this.myTemplateParameters.isEmpty();
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/symbols/cpp/OCAliasUsingSymbol", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/symbols/cpp/OCAliasUsingSymbol", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/symbols/cpp/OCAliasUsingSymbol", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCAliasUsingSymbol f = (OCAliasUsingSymbol)first;
        OCAliasUsingSymbol s = (OCAliasUsingSymbol)second;
        if (!Comparing.equal((Object)f.myScope, (Object)s.myScope)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        if (!c.equalIterable(f.myTemplateParameters, s.myTemplateParameters)) {
            return false;
        }
        return c.equalObjects(f.myType, s.myType);
    }

    @Override
    public String toString() {
        return "using " + this.myName + ' ' + this.myType.getName();
    }

    @Override
    public boolean isGlobal() {
        return this.myScope == null;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = OCSymbolKind.USING_SYMBOL_ALIAS;
        if (oCSymbolKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCAliasUsingSymbol", "getKind"));
        }
        return oCSymbolKind;
    }
}

