/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.ASTStructure;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCGenericArgument;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifiedNameOwner;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifierOwner;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeArgumentList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.BuilderDriverBase;
import com.jetbrains.cidr.lang.symbols.OCBuilderDriver;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSymbolReferenceResolver {
    @NotNull
    private final OCResolveContext myMemoization;
    private final boolean myProcessInsideUsings;
    private final boolean myProcessTypesOnly;
    private static final Condition<OCSymbol> NON_USING_SYMBOL = new Condition<OCSymbol>(){

        public boolean value(OCSymbol symbol) {
            return !(symbol instanceof OCUsingSymbol);
        }
    };
    private static final Class<PsiElement>[] STOP_SET = new Class[]{OCStructLike.class, OCFunctionDeclaration.class, OCDeclarator.class, OCCppNamespace.class, OCTemplateParameterList.class, OCCppUsingStatement.class};

    public OCSymbolReferenceResolver(boolean processInsideUsings, boolean processTypesOnly, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/OCSymbolReferenceResolver", "<init>"));
        }
        this.myProcessInsideUsings = processInsideUsings;
        this.myProcessTypesOnly = processTypesOnly;
        this.myMemoization = context;
    }

    public boolean processSymbolsForLocalRef(@Nullable String name, @Nullable OCSymbolReference.SymbolFilter kind, @NotNull PsiElement element, @NotNull Processor<OCSymbol> processor2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/symbols/OCSymbolReferenceResolver", "processSymbolsForLocalRef"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/symbols/OCSymbolReferenceResolver", "processSymbolsForLocalRef"));
        }
        OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = this.getFilteredByKindProcessor(kind, OCSymbolReferenceResolver.createResolveFilteringProcessor(processor2, this.myMemoization));
        PsiElement context = element;
        while (context != null) {
            OCResolveUtil.processLocalAndMemberSymbols(name, context, orderedProcessor, this.myMemoization);
            PsiFile file2 = context.getContainingFile();
            context = file2 != null ? file2.getContext() : null;
        }
        this.processBuiltInSymbols(name, element, orderedProcessor);
        if (!orderedProcessor.finish()) {
            return false;
        }
        OCSymbolReference reference = OCSymbolReferenceResolver.getGlobalReferenceFromLocal(OCQualifiedName.with(name), element, kind);
        List<OCSymbol> globals = this.myMemoization.doResolveToSymbols(reference, !this.myProcessInsideUsings, this.myProcessTypesOnly);
        ContainerUtil.process(globals, orderedProcessor);
        return orderedProcessor.finish();
    }

    public OCCommonProcessors.OrderedProcessor<OCSymbol> getFilteredByKindProcessor(final @Nullable OCSymbolReference.SymbolFilter kind, @NotNull Processor<OCSymbol> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/symbols/OCSymbolReferenceResolver", "getFilteredByKindProcessor"));
        }
        Processor<OCSymbol> filteredProcessor = kind == null ? processor2 : new Processor<OCSymbol>((Processor)processor2){
            final /* synthetic */ Processor val$processor;
            {
                this.val$processor = processor2;
            }

            public boolean process(OCSymbol symbol) {
                return !kind.accept(symbol) || this.val$processor.process((Object)symbol);
            }
        };
        class MyOrderedProcessor
        extends OCCommonProcessors.OrderedProcessor<OCSymbol> {
            final /* synthetic */ Processor val$filteredProcessor;

            public MyOrderedProcessor() {
                this.val$filteredProcessor = processor2;
                super(processor2, new Condition<OCSymbol>(){

                    public boolean value(OCSymbol symbol) {
                        return symbol.getKind().isTypedefOrAlias();
                    }
                }, new Condition<OCSymbol>(){

                    public boolean value(OCSymbol symbol) {
                        return !symbol.isPredeclaration();
                    }
                }, Conditions.alwaysTrue());
            }
        }
        return new MyOrderedProcessor();
    }

    public static OCResolveUtil.ResolveFilteringProcessor<OCSymbol> createResolveFilteringProcessor(Processor<OCSymbol> processor2, OCResolveContext context) {
        PsiElement element = context.getElement();
        PsiFile file2 = element != null ? element.getContainingFile() : null;
        int textOffset = element != null ? element.getTextRange().getEndOffset() : 0;
        return new OCResolveUtil.ResolveFilteringProcessor<OCSymbol>(processor2, file2, textOffset, context.isProcessNonImported());
    }

    public boolean processSymbolsForGlobalRef(@Nullable String name, @Nullable OCSymbolReference.SymbolFilter kind, @Nullable OCSymbolWithQualifiedName context, boolean skipImmediateContext, @NotNull Processor<OCSymbol> processor2) {
        OCSymbolWithQualifiedName owner;
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/symbols/OCSymbolReferenceResolver", "processSymbolsForGlobalRef"));
        }
        ArrayList worksets = new ArrayList();
        boolean nonqualifier = true;
        boolean skipFirst = false;
        boolean isMagic = context instanceof OCSymbolWithSubstitution && OCResolveUtil.hasNonResolvedTemplateParameters((OCSymbolWithSubstitution)((Object)context));
        for (OCSymbolWithQualifiedName temp = context; temp != null; temp = temp.getParent()) {
            if (temp.getQualifier() != null) {
                nonqualifier = false;
            }
            for (OCTypeParameterSymbol param : temp.getTemplateParameters()) {
                if (name == null && !processor2.process((Object)((OCSymbol)((Object)param)))) {
                    return false;
                }
                if (!param.getName().equals(name)) continue;
                return processor2.process((Object)((OCSymbol)((Object)param)));
            }
            if (!nonqualifier || !(temp instanceof OCFunctionSymbol) && !(temp instanceof OCStructSymbol)) continue;
            worksets.add(Collections.singletonList(temp));
            context = temp;
            skipFirst = true;
        }
        if (skipImmediateContext && !worksets.isEmpty()) {
            worksets.remove(0);
        }
        if (context != null) {
            OCQualifiedName contextName = this.getResolvedQualifiedName(context);
            if (contextName != null && skipFirst) {
                contextName = contextName.getQualifier();
            }
            while (contextName != null && contextName != OCQualifiedName.GLOBAL) {
                worksets.add(this.myMemoization.doResolveToSymbols(OCSymbolReference.getGlobalReference(contextName, OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE_LIKE), false, this.myProcessTypesOnly));
                contextName = contextName.getQualifier();
            }
        }
        worksets.add(null);
        for (owner = context; owner != null && !(owner instanceof OCStructSymbol); owner = owner.getResolvedOwner(this.myMemoization, true)) {
        }
        for (Collection collection : worksets) {
            OCSymbol collected;
            CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
            OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = this.getFilteredByKindProcessor(kind, (Processor<OCSymbol>)collector);
            if (collection != null) {
                for (OCSymbol symbol : collection) {
                    if (symbol instanceof OCNamespaceSymbol) {
                        boolean old = OCResolveContext.setNonImportedFlag(this.myMemoization, false);
                        OCStructType.processMembersOfNamespace((OCNamespaceSymbol)symbol, name, this.myProcessInsideUsings, this.myProcessTypesOnly, orderedProcessor, this.myMemoization);
                        OCResolveContext.setNonImportedFlag(this.myMemoization, old);
                        continue;
                    }
                    if (!(symbol instanceof OCFunctionSymbol)) continue;
                    for (OCDeclaratorSymbol param : ((OCFunctionSymbol)symbol).getParameterSymbols()) {
                        if (!param.getName().equals(name)) continue;
                        orderedProcessor.process(param);
                    }
                }
            } else {
                PsiFile psiFile = this.myMemoization.getFile();
                if (psiFile == null || OCLanguage.getInstance() != psiFile.getLanguage()) {
                    return false;
                }
                OCFile file2 = (OCFile)psiFile;
                OCNamespaceLikeSymbol membersContainer = file2.getMembersContainer(this.myProcessTypesOnly);
                OCStructType.processMembersOfNamespace(membersContainer, name, this.myProcessInsideUsings, this.myProcessTypesOnly, orderedProcessor, this.myMemoization);
                this.processBuiltInSymbols(name, this.myMemoization.getElement(), orderedProcessor);
                if (this.myMemoization.isProcessNonImported()) {
                    OCGlobalProjectSymbolsCache.processTopLevelSymbols(file2.getProject(), (Processor<OCSymbol>)new FilteringProcessor(NON_USING_SYMBOL, orderedProcessor), name);
                }
            }
            orderedProcessor.finish();
            Collection results = collector.getResults();
            if (results.isEmpty()) continue;
            boolean wasDefinition = false;
            boolean stopWalkUp = false;
            boolean ownerProcessed = false;
            if (owner != null && results.contains(owner) && !skipImmediateContext) {
                processor2.process((Object)owner);
                ownerProcessed = true;
            }
            for (OCSymbol collected2 : results) {
                if (skipImmediateContext && collected2 == context) continue;
                if (!collected2.isPredeclaration()) {
                    wasDefinition = true;
                    if (!collected2.getKind().isConstructorOrDestructor() && !collected2.getKind().isTemplateParameter() && collected2.getKind() != OCSymbolKind.SYMBOL_USING_SYMBOL && collected2.getKind() != OCSymbolKind.NAMESPACE) {
                        stopWalkUp = true;
                    }
                } else if (!collected2.getKind().isConstructorOrDestructor() && !collected2.getKind().isStructLike()) {
                    stopWalkUp = true;
                }
                if (Comparing.equal((Object)collected2, (Object)owner) || processor2.process((Object)collected2)) continue;
                this.myMemoization.setContextWasUsed(collection != null);
                return false;
            }
            if (!wasDefinition && (collected = (OCSymbol)collector.getResults().iterator().next()) instanceof OCSymbolWithQualifiedName) {
                for (OCSymbol impl : this.getImplementationsOfSymbol((OCSymbolWithQualifiedName)collected, isMagic)) {
                    if (impl == null || ownerProcessed && Comparing.equal((Object)impl, (Object)owner) || processor2.process((Object)impl)) continue;
                    return false;
                }
            }
            if (!stopWalkUp || name == null) continue;
            this.myMemoization.setContextWasUsed(collection != null);
            return true;
        }
        return true;
    }

    private boolean processBuiltInSymbols(@Nullable String name, @NotNull PsiElement context, Processor<OCSymbol> processor2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/OCSymbolReferenceResolver", "processBuiltInSymbols"));
        }
        if (name != null) {
            OCSymbolKind kind;
            OCType builtInType;
            if (name.startsWith("__builtin") || name.startsWith("__sync_")) {
                builtInType = OCUnknownType.INSTANCE;
                kind = OCSymbolKind.BUILTIN_SYMBOL;
            } else if (name.equals("__objc_yes") || name.equals("__objc_no")) {
                builtInType = OCIntType.BOOL;
                kind = OCSymbolKind.BUILTIN_SYMBOL;
            } else if (name.equals("_cmd") && PsiTreeUtil.getContextOfType((PsiElement)context, (Class[])new Class[]{OCMethod.class}) != null) {
                builtInType = OCReferenceType.fromText("SEL");
                kind = OCSymbolKind.PARAMETER;
            } else if (name.equals("defined") && PsiTreeUtil.getContextOfType((PsiElement)context, (Class[])new Class[]{OCDirective.class}) != null) {
                builtInType = OCUnknownType.INSTANCE;
                kind = OCSymbolKind.BUILTIN_SYMBOL;
            } else if (!OCCodeInsightUtil.isInPlainOldC(context) && name.equals("typeid")) {
                OCQualifiedName typeName = OCQualifiedName.parse("std::type_info");
                OCReferenceType returnType = new OCReferenceTypeBuilder(typeName).build();
                builtInType = new OCFunctionType(returnType, Collections.singletonList(OCUnknownType.INSTANCE));
                kind = OCSymbolKind.BUILTIN_SYMBOL;
            } else {
                OCCallExpression callExpression;
                builtInType = name.startsWith("__") ? ((callExpression = (OCCallExpression)PsiTreeUtil.getParentOfType((PsiElement)context, OCCallExpression.class)) != null && OCExpressionEvaluator.evaluateGNUBuiltInTrait(callExpression, this.myMemoization) != null ? OCIntType.BOOL : null) : null;
                kind = OCSymbolKind.BUILTIN_SYMBOL;
            }
            if (builtInType != null) {
                Project project = context.getProject();
                int offset = context.getTextRange().getEndOffset();
                OCDeclaratorSymbol symbol = new OCDeclaratorSymbol(project, null, offset, null, name, Collections.<String>emptyList(), builtInType, kind);
                return processor2.process((Object)symbol);
            }
        }
        return true;
    }

    @Nullable
    public static OCSymbolWithQualifiedName getGlobalContextFromLocal(@Nullable PsiElement localContext) {
        if (localContext instanceof OCDeclarator && localContext.getContext() instanceof OCFunctionDeclaration) {
            localContext = localContext.getContext();
        }
        OCSymbolWithQualifiedName actualContext = null;
        PsiElement context = PsiTreeUtil.getContextOfType((PsiElement)localContext, (Class[])STOP_SET);
        while (context != null) {
            Object symbol;
            OCTypeElement typeElement;
            if ((context instanceof OCDeclarator || context instanceof OCParameterList) && context.getContext() instanceof OCFunctionDeclaration) {
                context = context.getContext();
            }
            if (context instanceof OCTemplateParameterList && context.getContext() instanceof OCDeclaration && (typeElement = ((OCDeclaration)context.getContext()).getTypeElement()) != null) {
                for (PsiElement child : typeElement.getChildren()) {
                    if (!(child instanceof OCStruct)) continue;
                    context = child;
                    break;
                }
            }
            Object v0 = symbol = context instanceof OCSymbolDeclarator ? ((OCSymbolDeclarator)context).getSymbol() : null;
            if (symbol instanceof OCSymbolWithQualifiedName) {
                actualContext = symbol;
                break;
            }
            context = PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])STOP_SET);
        }
        return actualContext;
    }

    public static OCSymbolReference getGlobalReferenceFromLocal(OCQualifiedName name, PsiElement context, OCSymbolReference.SymbolFilter filter) {
        while (context instanceof OCCppNamespaceQualifier) {
            context = context.getParent();
        }
        if (context instanceof OCDeclarator && context.getParent() instanceof OCFunctionDefinition) {
            context = context.getParent();
        }
        return OCSymbolReference.getGlobalReference(name, OCSymbolReferenceResolver.getGlobalContextFromLocal(context), filter);
    }

    public static OCSymbolReference getGlobalReferenceFromLocal(OCSymbolReference reference) {
        if (reference instanceof OCSymbolReference.LocalReference) {
            return OCSymbolReferenceResolver.getGlobalReferenceFromLocal(reference.getQualifiedName(), ((OCSymbolReference.LocalReference)reference).getLocalContext(), reference.getFilter());
        }
        return reference;
    }

    @NotNull
    public static OCQualifiedName getQualifiedName(@NotNull OCNamespaceQualifierOwner element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/symbols/OCSymbolReferenceResolver", "getQualifiedName"));
        }
        OCQualifiedName oCQualifiedName = OCSymbolReferenceResolver.getQualifiedName(element, new OCResolveContext(element), null);
        if (oCQualifiedName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolReferenceResolver", "getQualifiedName"));
        }
        return oCQualifiedName;
    }

    @NotNull
    public static OCQualifiedName getQualifiedName(@NotNull OCNamespaceQualifierOwner element, @NotNull OCResolveContext context, @Nullable OCExpressionEvaluator.CachingEvaluator evaluator) {
        PsiElement firstChild;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/symbols/OCSymbolReferenceResolver", "getQualifiedName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/OCSymbolReferenceResolver", "getQualifiedName"));
        }
        OCCppNamespaceQualifier qualifierElement = element.getNamespaceQualifier();
        OCQualifiedName qualifier = qualifierElement != null ? OCSymbolReferenceResolver.getQualifiedName(qualifierElement, context, evaluator) : ((firstChild = element.getFirstChild()) != null && firstChild.getNode().getElementType() == OCTokenTypes.COLON2X ? OCQualifiedName.GLOBAL : null);
        String name = element instanceof OCNamespaceQualifiedNameOwner ? ((OCNamespaceQualifiedNameOwner)element).getName() : element.getReference().getCanonicalText();
        List<OCTypeArgument> typeArguments = OCSymbolReferenceResolver.getTypeArguments(element, context, evaluator);
        OCQualifiedName oCQualifiedName = typeArguments != null ? new OCQualifiedNameWithArguments(qualifier, name, typeArguments) : OCQualifiedName.with(qualifier, name);
        if (oCQualifiedName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolReferenceResolver", "getQualifiedName"));
        }
        return oCQualifiedName;
    }

    public static List<OCTypeArgument> getTypeArguments(@NotNull PsiElement element, @NotNull OCResolveContext context, @Nullable OCExpressionEvaluator.CachingEvaluator evaluator) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/symbols/OCSymbolReferenceResolver", "getTypeArguments"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/OCSymbolReferenceResolver", "getTypeArguments"));
        }
        ArrayList<OCTypeArgument> typeArguments = null;
        for (PsiElement child : element.getChildren()) {
            if (!(child instanceof OCTypeArgumentList)) continue;
            typeArguments = new ArrayList<OCTypeArgument>();
            for (OCElement argument : ((OCTypeArgumentList)child).getArguments()) {
                OCSymbolReferenceResolver.doProcessTypeArgument(element, typeArguments, argument);
            }
        }
        return typeArguments;
    }

    private static void doProcessTypeArgument(@NotNull PsiElement element, ArrayList<OCTypeArgument> typeArguments, OCElement argument) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/symbols/OCSymbolReferenceResolver", "doProcessTypeArgument"));
        }
        if (argument instanceof OCGenericArgument) {
            OCSymbolReferenceResolver.doProcessTypeArgument(element, typeArguments, ((OCGenericArgument)argument).getTypeElement());
        } else if (argument instanceof OCTypeElement) {
            typeArguments.add(((OCTypeElement)argument).getType());
        } else if (argument instanceof OCExpression) {
            OCFile file2 = (OCFile)element.getContainingFile();
            OCBuilderDriver<ASTNode> builderDriver = new OCBuilderDriver<ASTNode>(file2, OCInclusionContext.empty(file2.getKind(), file2), new ASTStructure(argument.getNode()), BuilderDriverBase.AST_NAMED_NODE_STRUCTURE, (Processor<OCSymbol>)CommonProcessors.alwaysTrue());
            OCExpressionSymbol symbol = builderDriver.getExpressionSymbol(argument.getNode(), new BuilderDriverBase.DeclarationContext(null, null, null, null, argument));
            typeArguments.add(new OCExpressionTypeArgument(symbol));
        }
    }

    @NotNull
    public Collection<OCSymbol> getImplementationsOfSymbol(OCSymbolWithQualifiedName symbol, boolean isMagic) {
        if (symbol instanceof OCStructSymbol && isMagic) {
            CommonProcessors.CollectProcessor<OCSymbol> collector = new CommonProcessors.CollectProcessor<OCSymbol>(){

                protected boolean accept(OCSymbol symbol) {
                    return !symbol.isPredeclaration();
                }
            };
            symbol.processSameSymbols((Processor<OCSymbol>)collector);
            Collection collection = collector.getResults();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolReferenceResolver", "getImplementationsOfSymbol"));
            }
            return collection;
        }
        OCSymbol impl = this.getVisibleImplementationOfSymbol(symbol);
        List<OCSymbol> list = impl != null ? Collections.singletonList(impl) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolReferenceResolver", "getImplementationsOfSymbol"));
        }
        return list;
    }

    @Nullable
    public OCSymbol getVisibleImplementationOfSymbol(final OCSymbolWithQualifiedName symbol) {
        final CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        final Class<?> myClass = symbol.getClass();
        String myName = symbol.getName();
        final OCFile file2 = (OCFile)this.myMemoization.getFile();
        Processor<OCSymbol> _processor = new Processor<OCSymbol>(){
            private OCQualifiedName myResolvedName;

            public boolean process(OCSymbol _symbol) {
                OCQualifiedName resolvedName;
                if (_symbol.isPredeclaration()) {
                    return true;
                }
                if (!_symbol.getClass().equals(myClass)) {
                    return true;
                }
                if (!(_symbol instanceof OCSymbolWithQualifiedName)) {
                    return true;
                }
                OCNamespaceLikeSymbol container = file2.getMembersContainer(OCSymbolReferenceResolver.this.myProcessTypesOnly);
                boolean found = false;
                OCSymbol parent = _symbol;
                while (parent != null) {
                    final OCSymbol _parent = parent;
                    if (!container.processMembers(parent.getName(), new Processor<OCSymbol>(){

                        public boolean process(OCSymbol ocSymbol) {
                            return !ocSymbol.equals(_parent);
                        }
                    })) {
                        found = true;
                        break;
                    }
                    parent = ((OCSymbolWithQualifiedName)parent).getParent();
                }
                if (!found) {
                    return true;
                }
                if (this.myResolvedName == null) {
                    this.myResolvedName = OCSymbolReferenceResolver.this.getResolvedQualifiedName(symbol);
                    if (this.myResolvedName == null) {
                        return false;
                    }
                }
                if (!this.myResolvedName.equals(resolvedName = OCSymbolReferenceResolver.this.getResolvedQualifiedName((OCSymbolWithQualifiedName)_symbol))) {
                    return true;
                }
                return processor2.process((Object)_symbol);
            }
        };
        Project project = symbol.getProject();
        if (project != null) {
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project, _processor, myName);
        }
        return (OCSymbol)processor2.getFoundValue();
    }

    @Nullable
    public OCQualifiedName getResolvedQualifiedName(OCSymbolWithQualifiedName symbol) {
        return symbol.getResolvedQualifiedName(false, this.myMemoization, this.myProcessTypesOnly, true, false, true, true);
    }
}

