/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCompatibilityAlias;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceAlias;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCGenericParameter;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCLabeledStatement;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCMacroParameter;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCUndefDirective;
import com.jetbrains.cidr.lang.psi.OCUnion;
import icons.CidrLangIcons;
import javax.swing.Icon;

public enum OCSymbolKind {
    CATCH_EXCEPTION_VARIABLE,
    LOCAL_VARIABLE,
    PARAMETER,
    LABEL,
    STRUCT_FIELD,
    PROPERTY,
    INSTANCE_VARIABLE,
    METHOD,
    FUNCTION_PREDECLARATION,
    FUNCTION_DECLARATION,
    TYPEDEF,
    COMPATIBILITY_ALIAS,
    INTERFACE,
    PROTOCOL,
    IMPLEMENTATION,
    STRUCT,
    USING_SYMBOL_ALIAS,
    ENUM,
    UNION,
    NAMESPACE_ALIAS,
    NAMESPACE,
    NAMESPACE_USING_SYMBOL,
    SYMBOL_USING_SYMBOL,
    ENUM_CONST,
    GLOBAL_VARIABLE,
    GLOBAL_VARIABLE_PREDECLARATION,
    CPP_CONSTRUCTOR_PREDECLARATION,
    CPP_CONSTRUCTOR_DECLARATION,
    MACRO,
    MACRO_PARAMETER,
    UNDEF_MACRO,
    TEMPLATE_TYPE_PARAMETER,
    TEMPLATE_VALUE_PARAMETER,
    BUILTIN_SYMBOL,
    SYNTHESIZE,
    BLOCK,
    LAMBDA,
    IMPORT,
    LOCALIZED_STRING,
    EXPRESSION,
    GENERIC_PARAMETER,
    FOREIGN_ELEMENT;


    public String getName() {
        switch (this) {
            case TYPEDEF: {
                return "Type";
            }
            case ENUM_CONST: {
                return "Enum constant";
            }
            case STRUCT_FIELD: {
                return "Field";
            }
            case FUNCTION_PREDECLARATION: 
            case FUNCTION_DECLARATION: {
                return "Function";
            }
            case CPP_CONSTRUCTOR_DECLARATION: 
            case CPP_CONSTRUCTOR_PREDECLARATION: {
                return "Constructor";
            }
            case PARAMETER: {
                return "Parameter";
            }
            case GLOBAL_VARIABLE: 
            case GLOBAL_VARIABLE_PREDECLARATION: {
                return "Global variable";
            }
            case BUILTIN_SYMBOL: {
                return "Built-in symbol";
            }
            case LOCAL_VARIABLE: {
                return "Local variable";
            }
            case CATCH_EXCEPTION_VARIABLE: {
                return "Exception variable";
            }
            case IMPLEMENTATION: {
                return "Implementation";
            }
            case INSTANCE_VARIABLE: {
                return "Instance variable";
            }
            case INTERFACE: {
                return "Interface";
            }
            case LABEL: {
                return "Label";
            }
            case MACRO: 
            case UNDEF_MACRO: {
                return "Macro";
            }
            case MACRO_PARAMETER: {
                return "Macro parameter";
            }
            case IMPORT: {
                return "Import";
            }
            case COMPATIBILITY_ALIAS: {
                return "Compatibility alias";
            }
            case METHOD: {
                return "Method";
            }
            case BLOCK: {
                return "Block";
            }
            case LAMBDA: {
                return "Lambda";
            }
            case PROPERTY: {
                return "Property";
            }
            case SYNTHESIZE: {
                return "Synthesize statement";
            }
            case PROTOCOL: {
                return "Protocol";
            }
            case STRUCT: {
                return "Struct";
            }
            case UNION: {
                return "Union";
            }
            case ENUM: {
                return "Enum";
            }
            case NAMESPACE: 
            case NAMESPACE_ALIAS: {
                return "Namespace";
            }
            case TEMPLATE_TYPE_PARAMETER: {
                return "Type parameter";
            }
            case TEMPLATE_VALUE_PARAMETER: {
                return "Template parameter";
            }
            case SYMBOL_USING_SYMBOL: 
            case NAMESPACE_USING_SYMBOL: 
            case USING_SYMBOL_ALIAS: {
                return "Using";
            }
            case LOCALIZED_STRING: {
                return "Localized string";
            }
            case EXPRESSION: {
                return "Expression";
            }
            case GENERIC_PARAMETER: {
                return "Generic parameter";
            }
        }
        return "Symbol";
    }

    public Class getPsiElementClass() {
        switch (this) {
            case BUILTIN_SYMBOL: {
                return PsiElement.class;
            }
            case IMPLEMENTATION: {
                return OCImplementation.class;
            }
            case INTERFACE: 
            case PROTOCOL: {
                return OCClassDeclaration.class;
            }
            case LABEL: {
                return OCLabeledStatement.class;
            }
            case MACRO: {
                return OCDefineDirective.class;
            }
            case UNDEF_MACRO: {
                return OCUndefDirective.class;
            }
            case MACRO_PARAMETER: {
                return OCMacroParameter.class;
            }
            case IMPORT: {
                return OCIncludeDirective.class;
            }
            case COMPATIBILITY_ALIAS: {
                return OCCompatibilityAlias.class;
            }
            case METHOD: {
                return OCMethod.class;
            }
            case BLOCK: {
                return OCBlockExpression.class;
            }
            case SYNTHESIZE: {
                return OCSynthesizeProperty.class;
            }
            case STRUCT: {
                return OCStruct.class;
            }
            case UNION: {
                return OCUnion.class;
            }
            case ENUM: {
                return OCEnum.class;
            }
            case NAMESPACE: {
                return OCCppNamespace.class;
            }
            case NAMESPACE_ALIAS: {
                return OCCppNamespaceAlias.class;
            }
            case TEMPLATE_TYPE_PARAMETER: {
                return OCTypeParameterDeclaration.class;
            }
            case SYMBOL_USING_SYMBOL: 
            case NAMESPACE_USING_SYMBOL: 
            case USING_SYMBOL_ALIAS: {
                return OCCppUsingStatement.class;
            }
            case LOCALIZED_STRING: {
                return OCLocalizedString.class;
            }
            case EXPRESSION: {
                return OCExpression.class;
            }
            case GENERIC_PARAMETER: {
                return OCGenericParameter.class;
            }
        }
        return OCDeclarator.class;
    }

    public Icon getIcon() {
        switch (this) {
            case NAMESPACE: 
            case NAMESPACE_ALIAS: 
            case NAMESPACE_USING_SYMBOL: {
                return CidrLangIcons.CodeAssistantNamespace;
            }
            case TYPEDEF: 
            case TEMPLATE_TYPE_PARAMETER: 
            case SYMBOL_USING_SYMBOL: 
            case USING_SYMBOL_ALIAS: {
                return CidrLangIcons.CodeAssistantType;
            }
            case ENUM_CONST: {
                return CidrLangIcons.CodeAssistantEnumConst;
            }
            case FUNCTION_PREDECLARATION: 
            case FUNCTION_DECLARATION: 
            case CPP_CONSTRUCTOR_DECLARATION: 
            case CPP_CONSTRUCTOR_PREDECLARATION: {
                return CidrLangIcons.CodeAssistantFunction;
            }
            case STRUCT_FIELD: 
            case INSTANCE_VARIABLE: {
                return CidrLangIcons.CodeAssistantField;
            }
            case IMPLEMENTATION: 
            case INTERFACE: {
                return CidrLangIcons.CodeAssistantClass;
            }
            case MACRO: 
            case UNDEF_MACRO: 
            case MACRO_PARAMETER: 
            case IMPORT: {
                return CidrLangIcons.CodeAssistantMacro;
            }
            case COMPATIBILITY_ALIAS: {
                return CidrLangIcons.CodeAssistantClass;
            }
            case METHOD: {
                return CidrLangIcons.CodeAssistantMember;
            }
            case PROPERTY: {
                return CidrLangIcons.CodeAssistantProperty;
            }
            case PROTOCOL: {
                return CidrLangIcons.CodeAssistantProtocol;
            }
            case STRUCT: {
                return CidrLangIcons.CodeAssistantStruct;
            }
            case UNION: {
                return CidrLangIcons.CodeAssistantUnion;
            }
            case ENUM: {
                return CidrLangIcons.CodeAssistantEnum;
            }
            case PARAMETER: 
            case TEMPLATE_VALUE_PARAMETER: 
            case GENERIC_PARAMETER: {
                return CidrLangIcons.CodeAssistantParameter;
            }
            case LOCAL_VARIABLE: 
            case CATCH_EXCEPTION_VARIABLE: 
            case LABEL: {
                return CidrLangIcons.CodeAssistantLocal;
            }
            case GLOBAL_VARIABLE: 
            case GLOBAL_VARIABLE_PREDECLARATION: 
            case BUILTIN_SYMBOL: {
                return CidrLangIcons.CodeAssistantGlobal;
            }
            case BLOCK: 
            case LAMBDA: 
            case SYNTHESIZE: 
            case LOCALIZED_STRING: 
            case EXPRESSION: {
                return null;
            }
        }
        return null;
    }

    public String getNameUppercase() {
        return this.getName();
    }

    public String getNameLowercase() {
        return StringUtil.decapitalize((String)this.getName());
    }

    public boolean isClass() {
        switch (this) {
            case IMPLEMENTATION: 
            case INTERFACE: 
            case COMPATIBILITY_ALIAS: 
            case PROTOCOL: {
                return true;
            }
        }
        return false;
    }

    public boolean isClassOrTypedef() {
        return this.isClass() || this == TYPEDEF || this == USING_SYMBOL_ALIAS;
    }

    public boolean isType() {
        return this.isClassOrTypedef() || this.isStructLike() || this == TEMPLATE_TYPE_PARAMETER || this == COMPATIBILITY_ALIAS || this == GENERIC_PARAMETER;
    }

    public boolean isStructLike() {
        switch (this) {
            case STRUCT: 
            case UNION: 
            case ENUM: {
                return true;
            }
        }
        return false;
    }

    public boolean isFunction() {
        return this == FUNCTION_PREDECLARATION || this == FUNCTION_DECLARATION;
    }

    public boolean isFunctionOrConstructor() {
        return this.isFunction() || this.isConstructorOrDestructor();
    }

    public boolean isCallable() {
        return this.isFunction() || this == METHOD || this == BLOCK || this == CPP_CONSTRUCTOR_DECLARATION || this == CPP_CONSTRUCTOR_PREDECLARATION || this == LAMBDA;
    }

    public boolean isPredeclaration() {
        return this == FUNCTION_PREDECLARATION || this == GLOBAL_VARIABLE_PREDECLARATION || this == CPP_CONSTRUCTOR_PREDECLARATION || this == STRUCT_FIELD;
    }

    public boolean isLocal() {
        return this == LOCAL_VARIABLE || this == CATCH_EXCEPTION_VARIABLE || this == LABEL || this == PARAMETER;
    }

    public boolean isConst() {
        return this == ENUM_CONST || this == TEMPLATE_VALUE_PARAMETER || this == GENERIC_PARAMETER || this.isFunction();
    }

    public OCSymbolKind toDeclarationKind() {
        switch (this) {
            case FUNCTION_PREDECLARATION: {
                return FUNCTION_DECLARATION;
            }
            case CPP_CONSTRUCTOR_PREDECLARATION: {
                return CPP_CONSTRUCTOR_DECLARATION;
            }
            case GLOBAL_VARIABLE_PREDECLARATION: {
                return GLOBAL_VARIABLE;
            }
        }
        return this;
    }

    public boolean isExpression() {
        switch (this) {
            case ENUM_CONST: 
            case STRUCT_FIELD: 
            case FUNCTION_PREDECLARATION: 
            case FUNCTION_DECLARATION: 
            case CPP_CONSTRUCTOR_DECLARATION: 
            case CPP_CONSTRUCTOR_PREDECLARATION: 
            case PARAMETER: 
            case GLOBAL_VARIABLE: 
            case GLOBAL_VARIABLE_PREDECLARATION: 
            case BUILTIN_SYMBOL: 
            case LOCAL_VARIABLE: 
            case CATCH_EXCEPTION_VARIABLE: 
            case INSTANCE_VARIABLE: 
            case LAMBDA: 
            case PROPERTY: 
            case TEMPLATE_VALUE_PARAMETER: {
                return true;
            }
        }
        return false;
    }

    public boolean isVariable() {
        switch (this) {
            case ENUM_CONST: 
            case PARAMETER: 
            case GLOBAL_VARIABLE: 
            case GLOBAL_VARIABLE_PREDECLARATION: 
            case LOCAL_VARIABLE: 
            case CATCH_EXCEPTION_VARIABLE: 
            case INSTANCE_VARIABLE: 
            case PROPERTY: 
            case TEMPLATE_VALUE_PARAMETER: {
                return true;
            }
        }
        return false;
    }

    public boolean isGlobalVariable() {
        return this == GLOBAL_VARIABLE || this == GLOBAL_VARIABLE_PREDECLARATION;
    }

    public boolean isConstructorOrDestructor() {
        return this == CPP_CONSTRUCTOR_DECLARATION || this == CPP_CONSTRUCTOR_PREDECLARATION;
    }

    public boolean isTemplateParameter() {
        return this == TEMPLATE_VALUE_PARAMETER || this == TEMPLATE_TYPE_PARAMETER || this == GENERIC_PARAMETER;
    }

    public boolean isTypedefOrAlias() {
        return this == TYPEDEF || this == COMPATIBILITY_ALIAS || this == USING_SYMBOL_ALIAS;
    }

    public boolean canBeNamespace() {
        switch (this) {
            case TYPEDEF: 
            case STRUCT: 
            case UNION: 
            case ENUM: 
            case NAMESPACE: 
            case NAMESPACE_ALIAS: 
            case TEMPLATE_TYPE_PARAMETER: {
                return true;
            }
        }
        return false;
    }

    public static OCSymbolKind parse(String name) {
        if (name == null) {
            return null;
        }
        if (name.equals("struct") || name.equals("class")) {
            return STRUCT;
        }
        if (name.equals("enum")) {
            return ENUM;
        }
        if (name.equals("union")) {
            return UNION;
        }
        return null;
    }
}

