/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class OCSymbolHolderVirtualPsiElement
extends FakePsiElement
implements OCSymbolDeclarator,
OCElement,
NavigatablePsiElement {
    @NotNull
    private final OCSymbol mySymbol;

    public OCSymbolHolderVirtualPsiElement(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/symbols/OCSymbolHolderVirtualPsiElement", "<init>"));
        }
        this.mySymbol = symbol;
    }

    @Override
    public String getName() {
        return this.mySymbol.getName();
    }

    @Override
    public ItemPresentation getPresentation() {
        return this.mySymbol.getPresentation();
    }

    protected Icon getBaseIcon() {
        return this.mySymbol.getIcon();
    }

    @Override
    public Icon getIcon(boolean open2) {
        return this.mySymbol.getIcon();
    }

    @Override
    public void navigate(boolean requestFocus) {
        int offset = this.mySymbol.getOffset();
        VirtualFile virtualFile = this.mySymbol.getContainingFile();
        if (virtualFile != null && virtualFile.isValid()) {
            new OpenFileDescriptor(this.mySymbol.getProject(), virtualFile, offset).navigate(true);
        }
    }

    @Override
    public boolean canNavigateToSource() {
        VirtualFile virtualFile = this.mySymbol.getContainingFile();
        return virtualFile != null && virtualFile.isValid();
    }

    public PsiElement getParent() {
        return this.mySymbol.getContainingPsiFile();
    }

    @NotNull
    public OCSymbol getSymbol() {
        OCSymbol oCSymbol = this.mySymbol;
        if (oCSymbol == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolHolderVirtualPsiElement", "getSymbol"));
        }
        return oCSymbol;
    }

    @Override
    public OCFile getContainingOCFile() {
        return this.mySymbol.getContainingOCFile();
    }

    @Override
    public PsiFile getContainingFile() {
        return this.mySymbol.getContainingPsiFile();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.mySymbol.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolHolderVirtualPsiElement", "getProject"));
        }
        return project;
    }

    @Override
    public String getTextWithMacros() {
        return "";
    }

    @Override
    public int getTextOffset() {
        return this.mySymbol.getOffset();
    }

    @Override
    public TextRange getTextRange() {
        return new TextRange(this.mySymbol.getOffset(), this.mySymbol.getOffset());
    }

    @Override
    public TextRange getRangeWithMacros() {
        return new TextRange(this.mySymbol.getOffset(), this.mySymbol.getOffset());
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public long getComplexOffset() {
        return 0L;
    }

    public static PsiElement create(OCSymbol symbol) {
        if (symbol.getContainingPsiFile() != null) {
            return new OCSymbolHolderVirtualPsiElement(symbol);
        }
        return null;
    }

    @Override
    public void delete() throws IncorrectOperationException {
    }

    public boolean equals(Object obj) {
        return obj instanceof OCSymbolHolderVirtualPsiElement && this.mySymbol.equals(((OCSymbolHolderVirtualPsiElement)obj).getSymbol());
    }

    public int hashCode() {
        return this.mySymbol.hashCode();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        OCLanguage oCLanguage = OCLanguage.getInstance();
        if (oCLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolHolderVirtualPsiElement", "getLanguage"));
        }
        return oCLanguage;
    }
}

