/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings.formatter.extractor;

import com.jetbrains.cidr.lang.settings.formatter.extractor.FClassSerializer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FValue {
    @NotNull
    public final String name;
    @NotNull
    public Object value;
    @NotNull
    public STATE state;
    @NotNull
    public FClassSerializer serializer;
    @NotNull
    public final VAR_KIND kind;

    public Object[] getPossibleValues() {
        return this.kind.getPossibleValues();
    }

    public int getMutagenFactor() {
        int mutagen = 1;
        if (this.state != STATE.SELECTED) {
            switch (this.kind) {
                case TAB_SIZE: {
                    ++mutagen;
                    break;
                }
                case BRACE_STYLE: {
                    mutagen += 6;
                    break;
                }
                case INDENT: {
                    mutagen += 6;
                    break;
                }
                case BLANK: {
                    ++mutagen;
                    break;
                }
                case KEEP: {
                    mutagen += 2;
                }
            }
        }
        if (this.kind == VAR_KIND.RIGHT_MARGIN) {
            mutagen = 0;
        }
        return mutagen;
    }

    public FValue(@NotNull String name, @NotNull Object value, @NotNull FClassSerializer serializer) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/settings/formatter/extractor/FValue", "<init>"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/lang/settings/formatter/extractor/FValue", "<init>"));
        }
        if (serializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializer", "com/jetbrains/cidr/lang/settings/formatter/extractor/FValue", "<init>"));
        }
        this.kind = VAR_KIND.getKind(name, value);
        this.name = name;
        this.value = value instanceof Integer && (Integer)value == 0 && this.kind == VAR_KIND.BRACE_STYLE ? Integer.valueOf(1) : value;
        this.state = STATE.INIT;
        this.serializer = serializer;
    }

    public FValue(@NotNull FValue valueZ) {
        if (valueZ == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueZ", "com/jetbrains/cidr/lang/settings/formatter/extractor/FValue", "<init>"));
        }
        this.name = valueZ.name;
        this.value = valueZ.value;
        this.state = valueZ.state;
        this.serializer = valueZ.serializer;
        this.kind = VAR_KIND.getKind(valueZ.name, valueZ.value);
    }

    @Nullable
    @Contract(value="false -> null")
    public FValue write(boolean retPrevValue) {
        Object orig = this.serializer.write(this.name, this.value, retPrevValue);
        return orig == null ? null : new FValue(this.name, orig, this.serializer);
    }

    public static List<FValue> readAll(String instanceName, Object instance) {
        Class<?> cls = instance.getClass();
        ArrayList<FValue> ret = new ArrayList<FValue>();
        FClassSerializer serializer = new FClassSerializer(instanceName, instance);
        for (Field field : cls.getDeclaredFields()) {
            if ((field = FClassSerializer.getPreparedField(field)) == null || field.getName().endsWith("_FORCE")) continue;
            try {
                ret.add(new FValue(field.getName(), field.get(instance), serializer));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public String toString() {
        return this.name + "=" + this.value + ";";
    }

    static enum VAR_KIND {
        RIGHT_MARGIN(VAR_KIND.getRMValues()),
        BLANK(new Object[]{0, 1, 2}),
        INDENT(new Object[]{0, 1, 2, 3, 4, 5, 6, 7, 8}),
        DEFAULT(new Object[]{0, 1, 2, 3, 4, 5, 6, 7, 8}),
        TAB_SIZE(new Object[]{2, 4, 8}),
        WRAP(new Object[]{0, 1, 2, 5}),
        BRACE_STYLE(new Object[]{1, 2, 3, 4, 5}),
        KEEP(new Object[]{true, false}),
        BOOL(new Object[]{true, false}),
        NOTHING(new Object[0]);

        @NotNull
        private Object[] myPossibleValues;

        private VAR_KIND(Object[] objects) {
            if (objects == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/jetbrains/cidr/lang/settings/formatter/extractor/FValue$VAR_KIND", "<init>"));
            }
            this.myPossibleValues = objects;
        }

        @NotNull
        public Object[] getPossibleValues() {
            if (this.myPossibleValues == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/formatter/extractor/FValue$VAR_KIND", "getPossibleValues"));
            }
            return this.myPossibleValues;
        }

        @NotNull
        private static Object[] getRMValues() {
            int from = 10;
            int to = 120;
            Object[] ret = new Object[to - from + 1];
            ret[0] = -1;
            for (int i = to; i > from; --i) {
                ret[i - from] = i;
            }
            if (ret == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/formatter/extractor/FValue$VAR_KIND", "getRMValues"));
            }
            return ret;
        }

        @NotNull
        public static VAR_KIND getKind(@NotNull String name, @NotNull Object value) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/settings/formatter/extractor/FValue$VAR_KIND", "getKind"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/lang/settings/formatter/extractor/FValue$VAR_KIND", "getKind"));
            }
            if (value.getClass().equals(Integer.class)) {
                if (name.equals("RIGHT_MARGIN")) {
                    VAR_KIND vAR_KIND = RIGHT_MARGIN;
                    if (vAR_KIND == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/formatter/extractor/FValue$VAR_KIND", "getKind"));
                    }
                    return vAR_KIND;
                }
                if (name.endsWith("_WRAP")) {
                    VAR_KIND vAR_KIND = WRAP;
                    if (vAR_KIND == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/formatter/extractor/FValue$VAR_KIND", "getKind"));
                    }
                    return vAR_KIND;
                }
                if (name.endsWith("BRACE_STYLE") || name.endsWith("BRACE_PLACEMENT")) {
                    VAR_KIND vAR_KIND = BRACE_STYLE;
                    if (vAR_KIND == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/formatter/extractor/FValue$VAR_KIND", "getKind"));
                    }
                    return vAR_KIND;
                }
                if (name.contains("TAB_SIZE")) {
                    VAR_KIND vAR_KIND = TAB_SIZE;
                    if (vAR_KIND == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/formatter/extractor/FValue$VAR_KIND", "getKind"));
                    }
                    return vAR_KIND;
                }
                if (name.contains("INDENT")) {
                    VAR_KIND vAR_KIND = INDENT;
                    if (vAR_KIND == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/formatter/extractor/FValue$VAR_KIND", "getKind"));
                    }
                    return vAR_KIND;
                }
                if (name.contains("BLANK")) {
                    VAR_KIND vAR_KIND = BLANK;
                    if (vAR_KIND == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/formatter/extractor/FValue$VAR_KIND", "getKind"));
                    }
                    return vAR_KIND;
                }
                VAR_KIND vAR_KIND = DEFAULT;
                if (vAR_KIND == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/formatter/extractor/FValue$VAR_KIND", "getKind"));
                }
                return vAR_KIND;
            }
            if (value.getClass().equals(Boolean.class)) {
                if (name.contains("KEEP")) {
                    VAR_KIND vAR_KIND = KEEP;
                    if (vAR_KIND == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/formatter/extractor/FValue$VAR_KIND", "getKind"));
                    }
                    return vAR_KIND;
                }
                VAR_KIND vAR_KIND = BOOL;
                if (vAR_KIND == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/formatter/extractor/FValue$VAR_KIND", "getKind"));
                }
                return vAR_KIND;
            }
            VAR_KIND vAR_KIND = NOTHING;
            if (vAR_KIND == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/formatter/extractor/FValue$VAR_KIND", "getKind"));
            }
            return vAR_KIND;
        }
    }

    public static enum STATE {
        INIT,
        SELECTED,
        ANY;

    }
}

