/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings.formatter.extractor;

import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.settings.formatter.extractor.FDiffer;
import com.jetbrains.cidr.lang.settings.formatter.extractor.FGeneration;
import com.jetbrains.cidr.lang.settings.formatter.extractor.FGens;
import com.jetbrains.cidr.lang.settings.formatter.extractor.FValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FUtils {
    public static int CRITICAL_SYMBOL_WEIGHT = 100;
    private static Map<String, String> LANG_TO_CLASS = new HashMap<String, String>();
    static long rseed;
    static final long RAND_MAX_32 = Integer.MAX_VALUE;
    static final long RAND_MAX = 32767L;

    public static int getTabSize(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/cidr/lang/settings/formatter/extractor/FUtils", "getTabSize"));
        }
        CommonCodeStyleSettings.IndentOptions options = settings.getCommonSettings((Language)OCLanguage.getInstance()).getIndentOptions();
        return options == null ? 4 : options.TAB_SIZE;
    }

    public static int getNormalizedLength(@NotNull CodeStyleSettings settings, @NotNull String text) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/cidr/lang/settings/formatter/extractor/FUtils", "getNormalizedLength"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/settings/formatter/extractor/FUtils", "getNormalizedLength"));
        }
        return text.replaceAll("\t", StringUtil.repeatSymbol((char)' ', (int)FUtils.getTabSize(settings))).replaceAll("\n", StringUtil.repeatSymbol((char)' ', (int)CRITICAL_SYMBOL_WEIGHT)).length();
    }

    public static boolean isSpace(char c) {
        return " \t\n".indexOf(c) >= 0;
    }

    public static boolean isBracket(char c) {
        return "(){}[]<>".indexOf(c) >= 0;
    }

    public static int getDiff(@NotNull CodeStyleSettings settings, @NotNull String oldV, @NotNull String newV) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/cidr/lang/settings/formatter/extractor/FUtils", "getDiff"));
        }
        if (oldV == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldV", "com/jetbrains/cidr/lang/settings/formatter/extractor/FUtils", "getDiff"));
        }
        if (newV == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newV", "com/jetbrains/cidr/lang/settings/formatter/extractor/FUtils", "getDiff"));
        }
        oldV = oldV.trim();
        newV = newV.trim();
        int diff = 0;
        int oPos = 0;
        int nPos = 0;
        int oEnd = oldV.length();
        int nEnd = newV.length();
        StringBuilder oSp = new StringBuilder();
        StringBuilder nSp = new StringBuilder();
        while (oPos < oEnd || nPos < nEnd) {
            char ch;
            oSp.setLength(0);
            nSp.setLength(0);
            while (oPos < oEnd && FUtils.isSpace(ch = oldV.charAt(oPos))) {
                oSp.append(ch);
                ++oPos;
            }
            while (nPos < nEnd && FUtils.isSpace(ch = newV.charAt(nPos))) {
                nSp.append(ch);
                ++nPos;
            }
            diff += Math.abs(FUtils.getNormalizedLength(settings, oSp.toString()) - FUtils.getNormalizedLength(settings, nSp.toString()));
            while (oPos < oEnd && nPos < nEnd && (ch = oldV.charAt(oPos)) == newV.charAt(nPos) && !FUtils.isSpace(ch)) {
                ++oPos;
                ++nPos;
            }
            if (oPos >= oEnd || nPos >= nEnd || FUtils.isSpace(oldV.charAt(oPos)) || FUtils.isSpace(newV.charAt(nPos))) continue;
            System.out.println("AST changed!");
            return 0x1FFFFFFF;
        }
        return diff;
    }

    @NotNull
    public static List<FValue> getFormattingValues(CodeStyleSettings settings, Language language) {
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings(language);
        CommonCodeStyleSettings.IndentOptions indentOptions = commonSettings.getIndentOptions();
        Object ocSettings = FUtils.getLanguageSettings(settings, language);
        List<FValue> values = FValue.readAll("commonSettings", commonSettings);
        values.addAll(FValue.readAll("ocSettings", ocSettings));
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)language);
        if (provider != null) {
            Set supportedFields = provider.getSupportedFields();
            ArrayList<FValue> cvalues = new ArrayList<FValue>(values.size());
            for (FValue value : values) {
                if (!supportedFields.contains(value.name)) continue;
                cvalues.add(value);
            }
            values = cvalues;
        }
        List<FValue> valuesOrder = FValue.readAll("indentOptions", indentOptions);
        valuesOrder.addAll(values);
        List<FValue> list = valuesOrder;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/formatter/extractor/FUtils", "getFormattingValues"));
        }
        return list;
    }

    @Nullable
    public static Object getLanguageSettings(@NotNull CodeStyleSettings settings, @NotNull Language language) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/cidr/lang/settings/formatter/extractor/FUtils", "getLanguageSettings"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/jetbrains/cidr/lang/settings/formatter/extractor/FUtils", "getLanguageSettings"));
        }
        String customSettingsClassName = LANG_TO_CLASS.get(language.getID());
        if (customSettingsClassName == null) {
            return null;
        }
        try {
            Class<?> customSettingsClass = Class.forName(customSettingsClassName);
            return settings.getCustomSettings(customSettingsClass);
        }
        catch (ClassNotFoundException e) {
            OCLog.LOG.warn("Failed to load custom settings class class " + customSettingsClassName);
            return null;
        }
    }

    public static void adjustValuesMin(@NotNull FGens gens, @NotNull FDiffer differ, @NotNull ProgressIndicator indicator) {
        if (gens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gens", "com/jetbrains/cidr/lang/settings/formatter/extractor/FUtils", "adjustValuesMin"));
        }
        if (differ == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "differ", "com/jetbrains/cidr/lang/settings/formatter/extractor/FUtils", "adjustValuesMin"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/lang/settings/formatter/extractor/FUtils", "adjustValuesMin"));
        }
        List<FValue> values = gens.getValues();
        int length = values.size();
        int i = 0;
        for (FValue value : values) {
            indicator.checkCanceled();
            indicator.setText2("Value:" + value.name);
            indicator.setFraction(0.5 + 0.5 * (double)i / (double)length);
            Object bestValue = value.value;
            int bestScope = differ.getDifference(gens);
            for (Object cnst : value.getPossibleValues()) {
                if (cnst.equals(value.value)) continue;
                value.value = cnst;
                int diff = differ.getDifference(gens);
                if (diff < bestScope) {
                    bestValue = cnst;
                    bestScope = diff;
                    value.state = FValue.STATE.SELECTED;
                    continue;
                }
                if (diff <= bestScope) continue;
                value.state = FValue.STATE.SELECTED;
            }
            value.value = bestValue;
            ++i;
        }
    }

    public static void adjustValuesGA(@NotNull FGens gens, @NotNull FDiffer differ, @NotNull ProgressIndicator indicator) {
        if (gens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gens", "com/jetbrains/cidr/lang/settings/formatter/extractor/FUtils", "adjustValuesGA"));
        }
        if (differ == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "differ", "com/jetbrains/cidr/lang/settings/formatter/extractor/FUtils", "adjustValuesGA"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/lang/settings/formatter/extractor/FUtils", "adjustValuesGA"));
        }
        FGeneration generation = FGeneration.createZeroGeneration(gens);
        while (generation.tryAgain()) {
            indicator.checkCanceled();
            int age = generation.getAge();
            indicator.setText2(" age:" + age + "/" + generation.getParentKind());
            indicator.setFraction(0.5 * (double)age / (double)FGeneration.GEN_COUNT);
            generation = FGeneration.createNextGeneration(differ, generation);
        }
        gens.copyFrom(generation.getBestGens(differ));
    }

    public static void resetRandom() {
        rseed = 0L;
    }

    public static long getRandom() {
        rseed = rseed * 214013L + 2531011L & Integer.MAX_VALUE;
        return rseed >> 16;
    }

    public static int getRandomLess(int count) {
        int ret = (int)(FUtils.getRandom() * (long)count / 32767L);
        if (ret >= count) {
            return count - 1;
        }
        if (ret < 0) {
            return 0;
        }
        return ret;
    }

    static {
        LANG_TO_CLASS.put("Scala", "org.jetbrains.plugins.scala.lang.formatting.settings.ScalaCodeStyleSettings");
        LANG_TO_CLASS.put("Java", "com.intellij.psi.codeStyle.JavaCodeStyleSettings");
        LANG_TO_CLASS.put("ObjectiveC", "com.jetbrains.cidr.lang.settings.OCCodeStyleSettings");
        rseed = 0L;
    }
}

