/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.openapi.options.Configurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.util.PlatformUtils;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.settings.OCCodeStyleMainPanel;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class OCCodeStyleSettingsProvider
extends CodeStyleSettingsProvider {
    public CustomCodeStyleSettings createCustomSettings(CodeStyleSettings settings) {
        return new OCCodeStyleSettings(settings);
    }

    @NotNull
    public Configurable createSettingsPage(CodeStyleSettings settings, CodeStyleSettings originalSettings) {
        CodeStyleAbstractConfigurable codeStyleAbstractConfigurable = new CodeStyleAbstractConfigurable(settings, originalSettings, this.getConfigurableDisplayName()){

            @Override
            protected CodeStyleAbstractPanel createPanel(CodeStyleSettings settings) {
                return new OCCodeStyleMainPanel(this.getCurrentSettings(), settings);
            }

            public String getHelpTopic() {
                return PlatformUtils.isAppCode() ? "topicId2221" : "reference.settings.codestyle.ccpp";
            }
        };
        if (codeStyleAbstractConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/OCCodeStyleSettingsProvider", "createSettingsPage"));
        }
        return codeStyleAbstractConfigurable;
    }

    public DisplayPriority getPriority() {
        return PlatformUtils.isCidr() ? DisplayPriority.KEY_LANGUAGE_SETTINGS : DisplayPriority.LANGUAGE_SETTINGS;
    }

    public String getConfigurableDisplayName() {
        return OCLanguage.getInstance().getDisplayName();
    }
}

