/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import org.jetbrains.annotations.NotNull;

public abstract class OCBaseLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    protected final Language myLanguage;

    protected OCBaseLanguageCodeStyleSettingsProvider(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/jetbrains/cidr/lang/settings/OCBaseLanguageCodeStyleSettingsProvider", "<init>"));
        }
        this.myLanguage = language;
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/OCBaseLanguageCodeStyleSettingsProvider", "getLanguage"));
        }
        return language;
    }

    @NotNull
    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings settings = new CommonCodeStyleSettings(this.getLanguage());
        settings.initIndentOptions();
        CommonCodeStyleSettings commonCodeStyleSettings = settings;
        if (commonCodeStyleSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/OCBaseLanguageCodeStyleSettingsProvider", "getDefaultCommonSettings"));
        }
        return commonCodeStyleSettings;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "com/jetbrains/cidr/lang/settings/OCBaseLanguageCodeStyleSettingsProvider", "getCodeSample"));
        }
        String fileName = OCBaseLanguageCodeStyleSettingsProvider.getCodeSampleFileName(settingsType);
        return this.getCodeSampleContent(fileName);
    }

    @NotNull
    public static String getCodeSampleFileName(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        String fileName;
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "com/jetbrains/cidr/lang/settings/OCBaseLanguageCodeStyleSettingsProvider", "getCodeSampleFileName"));
        }
        switch (settingsType) {
            default: {
                fileName = "General";
                break;
            }
            case SPACING_SETTINGS: {
                fileName = "Spaces";
                break;
            }
            case BLANK_LINES_SETTINGS: {
                fileName = "BlankLines";
                break;
            }
            case INDENT_SETTINGS: {
                fileName = "Indents";
            }
        }
        String string = fileName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/OCBaseLanguageCodeStyleSettingsProvider", "getCodeSampleFileName"));
        }
        return string;
    }

    @NotNull
    protected abstract String getCodeSampleContent(@NotNull String var1);
}

