/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.usages;

import com.intellij.find.findUsages.CommonFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.StateRestoringCheckBox;
import com.jetbrains.cidr.lang.search.usages.OCFindUsagesHandler;
import com.jetbrains.cidr.lang.search.usages.OCFindUsagesOptions;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class OCFindUsagesDialog
extends CommonFindUsagesDialog {
    private StateRestoringCheckBox myIvarUsagesCB;
    private StateRestoringCheckBox myPropertyUsagesCB;
    private StateRestoringCheckBox myDerivedClassUsagesCB;

    public OCFindUsagesDialog(PsiElement element, Project project, FindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, @NotNull FindUsagesHandler handler2) {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/jetbrains/cidr/lang/search/usages/OCFindUsagesDialog", "<init>"));
        }
        super(element, project, findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, handler2);
        this.init();
    }

    @Override
    public void calcFindUsagesOptions(FindUsagesOptions options) {
        super.calcFindUsagesOptions(options);
        if (OCFindUsagesDialog.isToChange(this.myIvarUsagesCB)) {
            ((OCFindUsagesOptions)options).isSearchForIvars = OCFindUsagesDialog.isSelected(this.myIvarUsagesCB);
        }
        if (OCFindUsagesDialog.isToChange(this.myPropertyUsagesCB)) {
            ((OCFindUsagesOptions)options).isSearchForProperties = OCFindUsagesDialog.isSelected(this.myPropertyUsagesCB);
        }
        if (OCFindUsagesDialog.isToChange(this.myDerivedClassUsagesCB)) {
            ((OCFindUsagesOptions)options).isSearchForDerivedClasses = OCFindUsagesDialog.isSelected(this.myDerivedClassUsagesCB);
        }
    }

    @Override
    protected void addUsagesOptions(final JPanel optionsPanel) {
        final OCFindUsagesOptions options = OCFindUsagesOptions.getInstance(this.myPsiElement.getProject());
        new OCFindUsagesHandler(this.myPsiElement).processSecondaryElements(new OCFindUsagesHandler.AssociatedElementProcessor(){

            @Override
            public boolean proceedProperty(OCPropertySymbol property) {
                OCFindUsagesDialog.this.myPropertyUsagesCB = OCFindUsagesDialog.this.addCheckboxToPanel("Include " + property.getNameWithKindLowercase(), options.isSearchForProperties, optionsPanel, false);
                OCFindUsagesDialog.this.myPropertyUsagesCB.setMnemonic('p');
                return false;
            }

            @Override
            public boolean proceedIvar(OCInstanceVariableSymbol ivar) {
                OCFindUsagesDialog.this.myIvarUsagesCB = OCFindUsagesDialog.this.addCheckboxToPanel("Include " + ivar.getNameWithKindLowercase(), options.isSearchForIvars, optionsPanel, false);
                OCFindUsagesDialog.this.myIvarUsagesCB.setMnemonic('i');
                return false;
            }

            @Override
            public boolean proceedDerivedClasses() {
                OCFindUsagesDialog.this.myDerivedClassUsagesCB = OCFindUsagesDialog.this.addCheckboxToPanel("Include derived classes", options.isSearchForDerivedClasses, optionsPanel, false);
                OCFindUsagesDialog.this.myDerivedClassUsagesCB.setMnemonic('d');
                return false;
            }

            public boolean process(PsiElement element) {
                return false;
            }
        });
        super.addUsagesOptions(optionsPanel);
    }

    @Override
    protected void doOKAction() {
        OCFindUsagesOptions options = OCFindUsagesOptions.getInstance(this.myPsiElement.getProject());
        if (OCFindUsagesDialog.isToChange(this.myIvarUsagesCB)) {
            options.isSearchForIvars = this.myIvarUsagesCB.isSelected();
        }
        if (OCFindUsagesDialog.isToChange(this.myPropertyUsagesCB)) {
            options.isSearchForProperties = this.myPropertyUsagesCB.isSelected();
        }
        if (OCFindUsagesDialog.isToChange(this.myDerivedClassUsagesCB)) {
            options.isSearchForDerivedClasses = this.myDerivedClassUsagesCB.isSelected();
        }
        super.doOKAction();
    }
}

