/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.scopes;

import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSearchScope {
    private static final Key<GlobalSearchScope> PROJECT_SOURCES_SCOPE = Key.create((String)"PROJECT_SOURCES_SCOPE");
    private static final Key<CachedValue<Collection<VirtualFile>>> EXPLICIT_PROJECT_SOURCE_FILES = Key.create((String)"EXPLICIT_PROJECT_SOURCE_FILES");

    @NotNull
    public static GlobalSearchScope getGotoSymbolScope(@NotNull Project project, boolean includeNonProjectFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/search/scopes/OCSearchScope", "getGotoSymbolScope"));
        }
        GlobalSearchScope globalSearchScope = includeNonProjectFiles ? ProjectScope.getAllScope((Project)project) : OCSearchScope.getProjectSourcesScope(project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/search/scopes/OCSearchScope", "getGotoSymbolScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getProjectSourcesScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/search/scopes/OCSearchScope", "getProjectSourcesScope"));
        }
        GlobalSearchScope cached = (GlobalSearchScope)project.getUserData(PROJECT_SOURCES_SCOPE);
        GlobalSearchScope globalSearchScope = cached != null ? cached : (GlobalSearchScope)((UserDataHolderEx)project).putUserDataIfAbsent(PROJECT_SOURCES_SCOPE, (Object)OCSearchScope.createProjectSourcesScope(project));
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/search/scopes/OCSearchScope", "getProjectSourcesScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    private static DelegatingGlobalSearchScope createProjectSourcesScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/search/scopes/OCSearchScope", "createProjectSourcesScope"));
        }
        final ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope(ProjectScope.getContentScope((Project)project)){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/search/scopes/OCSearchScope$1", "contains"));
                }
                return OCSearchScope.isSourceFile(index, file2);
            }
        };
        if (delegatingGlobalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/search/scopes/OCSearchScope", "createProjectSourcesScope"));
        }
        return delegatingGlobalSearchScope;
    }

    private static boolean isSourceFile(ProjectFileIndex index, VirtualFile file2) {
        return index.isInSourceContent(file2) && !index.isInLibrarySource(file2) && !index.isInLibraryClasses(file2);
    }

    @NotNull
    public static Collection<VirtualFile> getExplicitlySpecifiedProjectSourceFiles(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/search/scopes/OCSearchScope", "getExplicitlySpecifiedProjectSourceFiles"));
        }
        Collection collection = (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, EXPLICIT_PROJECT_SOURCE_FILES, (CachedValueProvider)new CachedValueProvider<Collection<VirtualFile>>(){

            @Nullable
            public CachedValueProvider.Result<Collection<VirtualFile>> compute() {
                THashSet result2 = new THashSet();
                ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
                final ProjectFileIndex index = rootManager.getFileIndex();
                final FileTypeRegistry typeRegistry = FileTypeRegistry.getInstance();
                for (VirtualFile eachSourceRoot : rootManager.getContentSourceRoots()) {
                    VfsUtilCore.visitChildrenRecursively((VirtualFile)eachSourceRoot, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0], (Set)result2){
                        final /* synthetic */ Set val$result;
                        {
                            this.val$result = set;
                            super(arg0);
                        }

                        public boolean visitFile(@NotNull VirtualFile each) {
                            if (each == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/jetbrains/cidr/lang/search/scopes/OCSearchScope$2$1", "visitFile"));
                            }
                            if (index.isExcluded(each) || typeRegistry.isFileIgnored(each)) {
                                return false;
                            }
                            if (!each.isDirectory() && OCSearchScope.isSourceFile(index, each)) {
                                this.val$result.add(each);
                            }
                            return true;
                        }
                    });
                }
                return CachedValueProvider.Result.create(Collections.unmodifiableCollection(result2), OCSearchScope.getProjectSourcesCacheDependencies(project));
            }
        }, false);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/search/scopes/OCSearchScope", "getExplicitlySpecifiedProjectSourceFiles"));
        }
        return collection;
    }

    @NotNull
    public static Collection<?> getProjectSourcesCacheDependencies(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/search/scopes/OCSearchScope", "getProjectSourcesCacheDependencies"));
        }
        List<ModificationTracker> list = Arrays.asList(VirtualFileManager.getInstance(), ProjectRootManager.getInstance((Project)project));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/search/scopes/OCSearchScope", "getProjectSourcesCacheDependencies"));
        }
        return list;
    }

    @Contract(value="null->false")
    public static boolean isInProjectSources(@Nullable OCSymbol symbol) {
        return OCSearchScope.isInProjectSources((PsiElement)OCSearchScope.getContainingFile(symbol));
    }

    @Nullable
    private static PsiFile getContainingFile(@Nullable OCSymbol symbol) {
        if (symbol == null || symbol.getKind() == OCSymbolKind.BUILTIN_SYMBOL) {
            return null;
        }
        return symbol.getContainingPsiFile();
    }

    @Contract(value="null->false")
    public static boolean isInProjectSources(@Nullable PsiElement element) {
        VirtualFile file2 = OCSearchScope.getVirtualFile(element);
        return file2 != null && OCSearchScope.getProjectSourcesScope(element.getProject()).contains(file2);
    }

    @Contract(value="null->false")
    public static boolean isInProjectSourcesOrLibraries(@Nullable OCSymbol symbol) {
        return OCSearchScope.isInProjectSourcesOrLibraries((PsiElement)OCSearchScope.getContainingFile(symbol));
    }

    @Contract(value="null->false")
    public static boolean isInProjectSourcesOrLibraries(@Nullable PsiElement element) {
        VirtualFile file2 = OCSearchScope.getVirtualFile(element);
        if (file2 == null) {
            return false;
        }
        return OCSearchScope.getProjectSourcesScope(element.getProject()).contains(file2) || ProjectScope.getLibrariesScope((Project)element.getProject()).contains(file2);
    }

    @Contract(value="null->false")
    public static boolean isInLibraries(@Nullable OCSymbol symbol) {
        return OCSearchScope.isInLibraries((PsiElement)OCSearchScope.getContainingFile(symbol));
    }

    @Contract(value="null->false")
    public static boolean isInLibraries(@Nullable PsiElement element) {
        VirtualFile file2 = OCSearchScope.getVirtualFile(element);
        if (file2 == null) {
            return false;
        }
        return ProjectScope.getLibrariesScope((Project)element.getProject()).contains(file2);
    }

    @Nullable
    private static VirtualFile getVirtualFile(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 instanceof PsiCodeFragment) {
            PsiElement context = file2.getContext();
            file2 = context == null ? null : context.getContainingFile();
        }
        return file2 == null ? null : OCInclusionContextUtil.getVirtualFile(file2);
    }
}

