/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import org.jetbrains.annotations.NotNull;

public class OCLocalizedStringReferencesSearch
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(final @NotNull ReferencesSearch.SearchParameters queryParameters, final @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/jetbrains/cidr/lang/search/OCLocalizedStringReferencesSearch", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/cidr/lang/search/OCLocalizedStringReferencesSearch", "execute"));
        }
        return (Boolean)new ReadAction<Boolean>(){

            protected void run(@NotNull Result<Boolean> result2) {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/lang/search/OCLocalizedStringReferencesSearch$1", "run"));
                }
                result2.setResult((Object)OCLocalizedStringReferencesSearch.doExecute(queryParameters, (Processor<PsiReference>)consumer));
            }
        }.execute().getResultObject();
    }

    private static Boolean doExecute(ReferencesSearch.SearchParameters queryParameters, final Processor<PsiReference> consumer) {
        final PsiElement string = queryParameters.getElementToSearch();
        if (!(string instanceof OCLocalizedString)) {
            return true;
        }
        PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance((Project)string.getProject());
        String text = ((OCLocalizedString)string).getName();
        if (text == null || text.isEmpty()) {
            return true;
        }
        return helper.processElementsWithWord(new TextOccurenceProcessor(){

            public boolean execute(@NotNull PsiElement element, int offsetInElement) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/search/OCLocalizedStringReferencesSearch$2", "execute"));
                }
                PsiReference[] references = new PsiReference[]{};
                if (element instanceof OCLiteralExpression) {
                    references = element.getReferences();
                } else if (element instanceof OCMacroCall) {
                    references = new PsiReference[]{element.findReferenceAt(offsetInElement)};
                }
                for (PsiReference reference : references) {
                    if (reference == null || !reference.isReferenceTo(string) || consumer.process((Object)reference)) continue;
                    return false;
                }
                return true;
            }
        }, queryParameters.getEffectiveSearchScope(), text, (short)4, true);
    }
}

